/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.reader;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mule.weave.v2.core.io.MemoryService;
import org.mule.weave.v2.core.io.TrackingClosable;
import org.mule.weave.v2.core.io.service.BufferFileClassifier$;
import org.mule.weave.v2.core.io.service.WorkingDirectoryService;
import org.mule.weave.v2.model.service.SettingsService;
import org.mule.weave.v2.module.reader.DefaultLongArray$;
import org.mule.weave.v2.module.reader.ILongArray;
import org.mule.weave.v2.module.reader.ILongArray$LongArrayIterator$;
import org.mule.weave.v2.module.reader.PersistedLongArray$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0$mcV$sp;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\tea\u0001B\u001a5\u0001\u0005C\u0001B\u0016\u0001\u0003\u0002\u0003\u0006Ia\u0016\u0005\t;\u0002\u0011\t\u0011)A\u0005=\"AQ\r\u0001B\u0001B\u0003%a\rC\u0003j\u0001\u0011\u0005!\u000e\u0003\u0005p\u0001!\u0015\r\u0011\"\u0001q\u0011!1\b\u0001#b\u0001\n\u00039\bbB>\u0001\u0001\u0004%\t\u0001 \u0005\n\u0003\u000f\u0001\u0001\u0019!C\u0001\u0003\u0013Aq!!\u0006\u0001A\u0003&Q\u0010\u0003\u0005\u0002\u0018\u0001\u0001\r\u0011\"\u0001}\u0011%\tI\u0002\u0001a\u0001\n\u0003\tY\u0002C\u0004\u0002 \u0001\u0001\u000b\u0015B?\t\u0011\u0005\u0005\u0002\u00011A\u0005\u0002qD\u0011\"a\t\u0001\u0001\u0004%\t!!\n\t\u000f\u0005%\u0002\u0001)Q\u0005{\"I\u00111\u0006\u0001C\u0002\u0013\u0005\u0011Q\u0006\u0005\t\u0003k\u0001\u0001\u0015!\u0003\u00020!I\u0011q\u0007\u0001C\u0002\u0013\u0005\u0011\u0011\b\u0005\t\u0003\u000f\u0002\u0001\u0015!\u0003\u0002<!I\u0011\u0011\n\u0001C\u0002\u0013\u0005\u0011\u0011\b\u0005\t\u0003\u0017\u0002\u0001\u0015!\u0003\u0002<!A\u0011Q\n\u0001A\u0002\u0013\u0005A\u0010C\u0005\u0002P\u0001\u0001\r\u0011\"\u0001\u0002R!9\u0011Q\u000b\u0001!B\u0013i\b\"CA,\u0001\u0001\u0007I\u0011AA\u0017\u0011%\tI\u0006\u0001a\u0001\n\u0003\tY\u0006\u0003\u0005\u0002`\u0001\u0001\u000b\u0015BA\u0018\u0011\u001d\t\t\u0007\u0001C!\u0003GBq!!\u001a\u0001\t\u0013\t9\u0007C\u0005\u0002t\u0001\t\n\u0011\"\u0003\u0002v!9\u00111\u0012\u0001\u0005\u0002\u0005\r\u0004bBAG\u0001\u0011\u0005\u0013q\u0012\u0005\b\u0003/\u0003A\u0011IAM\u0011\u001d\t)\u000b\u0001C\u0001\u0003GBq!a*\u0001\t\u0013\tI\u000bC\u0004\u00028\u0002!\t%a\u0019\t\u000f\u0005e\u0006\u0001\"\u0011\u0002<\"1\u00111\u0019\u0001\u0005BqDa!!2\u0001\t\u0003b\bbBAd\u0001\u0011\u0005\u0013\u0011\u001a\u0005\b\u0003\u001b\u0004A\u0011BAh\u0011\u001d\tI\u000e\u0001C\u0001\u00037Dq!a8\u0001\t\u0003\n\t\u000fC\u0004\u0002d\u0002!\t%a\u0019\b\u000f\u0005\u0015H\u0007#\u0001\u0002h\u001a11\u0007\u000eE\u0001\u0003SDa!\u001b\u0018\u0005\u0002\u0005E\bbBAd]\u0011\u0005\u00111\u001f\u0005\n\u0005\u0007q#\u0019!C\u0001\u0005\u000bA\u0001Ba\u0006/A\u0003%!q\u0001\u0002\u0013!\u0016\u00148/[:uK\u0012duN\\4BeJ\f\u0017P\u0003\u00026m\u00051!/Z1eKJT!a\u000e\u001d\u0002\r5|G-\u001e7f\u0015\tI$(\u0001\u0002we)\u00111\bP\u0001\u0006o\u0016\fg/\u001a\u0006\u0003{y\nA!\\;mK*\tq(A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u0005*s\u0005CA\"I\u001b\u0005!%BA#G\u0003\u0011a\u0017M\\4\u000b\u0003\u001d\u000bAA[1wC&\u0011\u0011\n\u0012\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005-cU\"\u0001\u001b\n\u00055#$AC%M_:<\u0017I\u001d:bsB\u0011q\nV\u0007\u0002!*\u0011\u0011KU\u0001\u0003S>T!a\u0015\u001d\u0002\t\r|'/Z\u0005\u0003+B\u0013\u0001\u0003\u0016:bG.LgnZ\"m_N\f'\r\\3\u0002/]|'o[5oO\u0012K'/Z2u_JL8+\u001a:wS\u000e,\u0007C\u0001-\\\u001b\u0005I&B\u0001.Q\u0003\u001d\u0019XM\u001d<jG\u0016L!\u0001X-\u0003/]{'o[5oO\u0012K'/Z2u_JL8+\u001a:wS\u000e,\u0017aD:fiRLgnZ:TKJ4\u0018nY3\u0011\u0005}\u001bW\"\u00011\u000b\u0005i\u000b'B\u000129\u0003\u0015iw\u000eZ3m\u0013\t!\u0007MA\bTKR$\u0018N\\4t'\u0016\u0014h/[2f\u00035iW-\\8ssN+'O^5dKB\u0011qjZ\u0005\u0003QB\u0013Q\"T3n_JL8+\u001a:wS\u000e,\u0017A\u0002\u001fj]&$h\b\u0006\u0003lY6t\u0007CA&\u0001\u0011\u00151F\u00011\u0001X\u0011\u0015iF\u00011\u0001_\u0011\u0015)G\u00011\u0001g\u0003!!X-\u001c9GS2,W#A9\u0011\u0005I$X\"A:\u000b\u0005E3\u0015BA;t\u0005\u00111\u0015\u000e\\3\u0002!I\fg\u000eZ8n\u0003\u000e\u001cWm]:GS2,W#\u0001=\u0011\u0005IL\u0018B\u0001>t\u0005A\u0011\u0016M\u001c3p[\u0006\u001b7-Z:t\r&dW-\u0001\u0005gS2,7+\u001b>f+\u0005i\bc\u0001@\u0002\u00045\tqP\u0003\u0002\u0002\u0002\u0005)1oY1mC&\u0019\u0011QA@\u0003\t1{gnZ\u0001\rM&dWmU5{K~#S-\u001d\u000b\u0005\u0003\u0017\t\t\u0002E\u0002\u007f\u0003\u001bI1!a\u0004\u0000\u0005\u0011)f.\u001b;\t\u0011\u0005M\u0001\"!AA\u0002u\f1\u0001\u001f\u00132\u0003%1\u0017\u000e\\3TSj,\u0007%A\u0003`g&TX-A\u0005`g&TXm\u0018\u0013fcR!\u00111BA\u000f\u0011!\t\u0019bCA\u0001\u0002\u0004i\u0018AB0tSj,\u0007%\u0001\u0007ck\u001a4WM](gMN,G/\u0001\tck\u001a4WM](gMN,Go\u0018\u0013fcR!\u00111BA\u0014\u0011!\t\u0019BDA\u0001\u0002\u0004i\u0018!\u00042vM\u001a,'o\u00144gg\u0016$\b%A\u0006ck\u001a4WM\u001d'j[&$XCAA\u0018!\rq\u0018\u0011G\u0005\u0004\u0003gy(aA%oi\u0006a!-\u001e4gKJd\u0015.\\5uA\u0005Q!/Z1e\u0005V4g-\u001a:\u0016\u0005\u0005m\u0002\u0003BA\u001f\u0003\u0007j!!a\u0010\u000b\u0007\u0005\u0005c)A\u0002oS>LA!!\u0012\u0002@\tQ!)\u001f;f\u0005V4g-\u001a:\u0002\u0017I,\u0017\r\u001a\"vM\u001a,'\u000fI\u0001\foJLG/\u001a\"vM\u001a,'/\u0001\u0007xe&$XMQ;gM\u0016\u0014\b%A\u0003`Y\u0006\u001cH/A\u0005`Y\u0006\u001cHo\u0018\u0013fcR!\u00111BA*\u0011!\t\u0019bFA\u0001\u0002\u0004i\u0018AB0mCN$\b%\u0001\bv]\u001adWo\u001d5fI\u000e{WO\u001c;\u0002%Utg\r\\;tQ\u0016$7i\\;oi~#S-\u001d\u000b\u0005\u0003\u0017\ti\u0006C\u0005\u0002\u0014i\t\t\u00111\u0001\u00020\u0005yQO\u001c4mkNDW\rZ\"pk:$\b%A\u0003dY>\u001cX\r\u0006\u0002\u0002\f\u00059Am\\\"m_N,G\u0003BA\u0006\u0003SB\u0011\"a\u001b\u001e!\u0003\u0005\r!!\u001c\u0002\u000b\u0005\u001c\u0018P\\2\u0011\u0007y\fy'C\u0002\u0002r}\u0014qAQ8pY\u0016\fg.A\te_\u000ecwn]3%I\u00164\u0017-\u001e7uIE*\"!a\u001e+\t\u00055\u0014\u0011P\u0016\u0003\u0003w\u0002B!! \u0002\b6\u0011\u0011q\u0010\u0006\u0005\u0003\u0003\u000b\u0019)A\u0005v]\u000eDWmY6fI*\u0019\u0011QQ@\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\n\u0006}$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006I1/Z3l)>,uJR\u0001\tIAdWo\u001d\u0013fcR!\u0011\u0011SAJ\u001b\u0005\u0001\u0001BBAKA\u0001\u0007Q0\u0001\u0003fY\u0016l\u0017!\u0004\u0013qYV\u001cH\u0005\u001d7vg\u0012*\u0017\u000f\u0006\u0003\u0002\u0012\u0006m\u0005bBAOC\u0001\u0007\u0011qT\u0001\u0006K2,Wn\u001d\t\u0005}\u0006\u0005V0C\u0002\u0002$~\u0014Q!\u0011:sCf\f1B\u001a7vg\"\u0014UO\u001a4fe\u0006YAo\u001c\"zi\u0016\f%O]1z)\u0011\tY+a-\u0011\u000by\f\t+!,\u0011\u0007y\fy+C\u0002\u00022~\u0014AAQ=uK\"9\u0011QW\u0012A\u0002\u0005}\u0015!\u0002<bYV,\u0017!B2mK\u0006\u0014\u0018AB;qI\u0006$X\r\u0006\u0004\u0002\f\u0005u\u0016\u0011\u0019\u0005\u0007\u0003\u007f+\u0003\u0019A?\u0002\u0007%$\u0007\u0010\u0003\u0004\u0002\u0016\u0016\u0002\r!`\u0001\u0005g&TX-\u0001\u0003mCN$\u0018!B1qa2LHcA?\u0002L\"1\u0011q\u0018\u0015A\u0002u\fa\"[:J]NLG-\u001a\"vM\u001a,'\u000f\u0006\u0005\u0002n\u0005E\u0017Q[Al\u0011\u0019\t\u0019.\u000ba\u0001{\u0006i\u0011N\u001c3fqB{7/\u001b;j_:Da!!\t*\u0001\u0004i\bbBA\u0016S\u0001\u0007\u0011qF\u0001\re\u0016dw.\u00193Ck\u001a4WM\u001d\u000b\u0005\u0003\u0017\ti\u000e\u0003\u0004\u0002T*\u0002\r!`\u0001\fSN\u0004VM]:jgR,G-\u0006\u0002\u0002n\u0005Aa-\u001b8bY&TX-\u0001\nQKJ\u001c\u0018n\u001d;fI2{gnZ!se\u0006L\bCA&/'\rq\u00131\u001e\t\u0004}\u00065\u0018bAAx\u007f\n1\u0011I\\=SK\u001a$\"!a:\u0015\u0005\u0005UHcA6\u0002x\"9\u0011\u0011 \u0019A\u0004\u0005m\u0018aA2uqB!\u0011Q`A\u0000\u001b\u0005\t\u0017b\u0001B\u0001C\n\tRI^1mk\u0006$\u0018n\u001c8D_:$X\r\u001f;\u0002\r1{uiR#S+\t\u00119\u0001\u0005\u0003\u0003\n\tMQB\u0001B\u0006\u0015\u0011\u0011iAa\u0004\u0002\u000f1|wmZ5oO*\u0019!\u0011\u0003$\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005+\u0011YA\u0001\u0004M_\u001e<WM]\u0001\b\u0019>;u)\u0012*!\u0001")
public class PersistedLongArray
implements ILongArray,
TrackingClosable {
    private File tempFile;
    private RandomAccessFile randomAccessFile;
    private final WorkingDirectoryService workingDirectoryService;
    private final MemoryService memoryService;
    private long fileSize;
    private long _size;
    private long bufferOffset;
    private final int bufferLimit;
    private final ByteBuffer readBuffer;
    private final ByteBuffer writeBuffer;
    private long _last;
    private int unflushedCount;
    private Exception org$mule$weave$v2$core$io$TrackingClosable$$closerResponsible;
    private volatile boolean org$mule$weave$v2$core$io$TrackingClosable$$closed;
    private volatile ILongArray$LongArrayIterator$ LongArrayIterator$module;
    private volatile byte bitmap$0;

    public static Logger LOGGER() {
        return PersistedLongArray$.MODULE$.LOGGER();
    }

    @Override
    public void assertNotClosed() {
        TrackingClosable.assertNotClosed$(this);
    }

    @Override
    public boolean isClosed() {
        return TrackingClosable.isClosed$(this);
    }

    @Override
    public long indexWhere(Function1<Object, Object> p, long from) {
        return ILongArray.indexWhere$(this, p, from);
    }

    @Override
    public long indexWhere$default$2() {
        return ILongArray.indexWhere$default$2$(this);
    }

    @Override
    public <U> void foreach(Function1<Object, U> f) {
        ILongArray.foreach$(this, f);
    }

    @Override
    public Option<Object> find(Function1<Object, Object> predicate, long from) {
        return ILongArray.find$(this, predicate, from);
    }

    @Override
    public long find$default$2() {
        return ILongArray.find$default$2$(this);
    }

    @Override
    public <T> Seq<T> map(Function1<Object, T> f) {
        return ILongArray.map$(this, f);
    }

    @Override
    public PrimitiveIterator.OfLong iterator(long from) {
        return ILongArray.iterator$(this, from);
    }

    @Override
    public long iterator$default$1() {
        return ILongArray.iterator$default$1$(this);
    }

    @Override
    public Exception org$mule$weave$v2$core$io$TrackingClosable$$closerResponsible() {
        return this.org$mule$weave$v2$core$io$TrackingClosable$$closerResponsible;
    }

    @Override
    public void org$mule$weave$v2$core$io$TrackingClosable$$closerResponsible_$eq(Exception x$1) {
        this.org$mule$weave$v2$core$io$TrackingClosable$$closerResponsible = x$1;
    }

    @Override
    public boolean org$mule$weave$v2$core$io$TrackingClosable$$closed() {
        return this.org$mule$weave$v2$core$io$TrackingClosable$$closed;
    }

    @Override
    public void org$mule$weave$v2$core$io$TrackingClosable$$closed_$eq(boolean x$1) {
        this.org$mule$weave$v2$core$io$TrackingClosable$$closed = x$1;
    }

    @Override
    public ILongArray$LongArrayIterator$ LongArrayIterator() {
        if (this.LongArrayIterator$module == null) {
            this.LongArrayIterator$lzycompute$1();
        }
        return this.LongArrayIterator$module;
    }

    private File tempFile$lzycompute() {
        PersistedLongArray persistedLongArray = this;
        synchronized (persistedLongArray) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.tempFile = this.workingDirectoryService.newBufferFile(BufferFileClassifier$.MODULE$.INDEX());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.tempFile;
    }

    public File tempFile() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.tempFile$lzycompute() : this.tempFile;
    }

    private RandomAccessFile randomAccessFile$lzycompute() {
        PersistedLongArray persistedLongArray = this;
        synchronized (persistedLongArray) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.randomAccessFile = new RandomAccessFile(this.tempFile(), "rw");
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.randomAccessFile;
    }

    public RandomAccessFile randomAccessFile() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.randomAccessFile$lzycompute() : this.randomAccessFile;
    }

    public long fileSize() {
        return this.fileSize;
    }

    public void fileSize_$eq(long x$1) {
        this.fileSize = x$1;
    }

    public long _size() {
        return this._size;
    }

    public void _size_$eq(long x$1) {
        this._size = x$1;
    }

    public long bufferOffset() {
        return this.bufferOffset;
    }

    public void bufferOffset_$eq(long x$1) {
        this.bufferOffset = x$1;
    }

    public int bufferLimit() {
        return this.bufferLimit;
    }

    public ByteBuffer readBuffer() {
        return this.readBuffer;
    }

    public ByteBuffer writeBuffer() {
        return this.writeBuffer;
    }

    public long _last() {
        return this._last;
    }

    public void _last_$eq(long x$1) {
        this._last = x$1;
    }

    public int unflushedCount() {
        return this.unflushedCount;
    }

    public void unflushedCount_$eq(int x$1) {
        this.unflushedCount = x$1;
    }

    @Override
    public void close() {
        this.doClose(true);
    }

    private void doClose(boolean async) {
        block0: {
            TrackingClosable.close$(this);
            this.memoryService.release(this.readBuffer(), "index-r");
            this.memoryService.release(this.writeBuffer(), "index-w");
            Try$.MODULE$.apply((JFunction0$mcV$sp & Serializable)() -> this.randomAccessFile().close());
            boolean deleted = this.workingDirectoryService.releaseBufferFile(this.tempFile(), async);
            if (deleted) break block0;
            PersistedLongArray$.MODULE$.LOGGER().log(Level.WARNING, new StringBuilder(28).append("Unable to delete tmp file: ").append(this.tempFile().getAbsolutePath()).append(".").toString());
        }
    }

    private boolean doClose$default$1() {
        return true;
    }

    public void seekToEOF() {
        this.randomAccessFile().seek(this.fileSize());
    }

    @Override
    public PersistedLongArray $plus$eq(long elem) {
        if (this.unflushedCount() + DefaultLongArray$.MODULE$.LONG_SIZE() > this.bufferLimit()) {
            this.seekToEOF();
            this.flushBuffer();
        }
        this.writeBuffer().putLong(elem);
        this.unflushedCount_$eq(this.unflushedCount() + DefaultLongArray$.MODULE$.LONG_SIZE());
        this._size_$eq(this._size() + 1L);
        this._last_$eq(elem);
        return this;
    }

    @Override
    public PersistedLongArray $plus$plus$eq(long[] elems) {
        block4: {
            this.assertNotClosed();
            if (elems.length <= 0) break block4;
            int elemsSizeInBytes = DefaultLongArray$.MODULE$.LONG_SIZE() * elems.length;
            if (elemsSizeInBytes >= this.bufferLimit()) {
                this.seekToEOF();
                this.flushBuffer();
                byte[] byteArray = this.toByteArray(elems);
                this.randomAccessFile().write(byteArray);
                this.fileSize_$eq(this.fileSize() + (long)byteArray.length);
            } else {
                if (this.unflushedCount() + elemsSizeInBytes > this.bufferLimit()) {
                    this.seekToEOF();
                    this.flushBuffer();
                }
                for (int i = 0; i < elems.length; ++i) {
                    this.writeBuffer().putLong(elems[i]);
                }
                this.unflushedCount_$eq(this.unflushedCount() + elemsSizeInBytes);
            }
            this._size_$eq(this._size() + (long)elems.length);
            this._last_$eq(elems[elems.length - 1]);
        }
        return this;
    }

    public void flushBuffer() {
        block1: {
            if (this.unflushedCount() <= 0) break block1;
            this.writeBuffer().flip();
            int result = 0;
            do {
                result = this.randomAccessFile().getChannel().write(this.writeBuffer());
                this.fileSize_$eq(this.fileSize() + (long)result);
            } while (result > 0);
            this.writeBuffer().clear();
            this.unflushedCount_$eq(0);
        }
    }

    private byte[] toByteArray(long[] value) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8 * value.length);
        byteBuffer.asLongBuffer().put(value);
        return byteBuffer.array();
    }

    @Override
    public void clear() {
        this.writeBuffer().clear();
        this.unflushedCount_$eq(0);
        this.readBuffer().clear();
        this.bufferOffset_$eq(-1L);
        this._size_$eq(0L);
        this._last_$eq(-1L);
        this.randomAccessFile().setLength(0L);
        this.fileSize_$eq(0L);
    }

    @Override
    public void update(long idx, long elem) {
        block2: {
            Object object;
            this.assertNotClosed();
            long indexPosition = idx * (long)DefaultLongArray$.MODULE$.LONG_SIZE();
            long writeBufOffset = this.fileSize();
            boolean insideBuffer = this.isInsideBuffer(indexPosition, writeBufOffset, this.writeBuffer().limit());
            if (insideBuffer) {
                int pos = this.writeBuffer().position();
                this.writeBuffer().position((int)(indexPosition - writeBufOffset));
                this.writeBuffer().asLongBuffer().put(elem);
                object = this.writeBuffer().position(pos);
            } else {
                this.randomAccessFile().seek(idx * (long)DefaultLongArray$.MODULE$.LONG_SIZE());
                this.randomAccessFile().writeLong(elem);
                object = BoxedUnit.UNIT;
            }
            if (idx != this.size() - 1L) break block2;
            this._last_$eq(elem);
        }
    }

    @Override
    public long size() {
        return this._size();
    }

    @Override
    public long last() {
        if (this._last() == -1L) {
            throw new NoSuchElementException();
        }
        return this._last();
    }

    @Override
    public long apply(long idx) {
        long l;
        this.assertNotClosed();
        if (idx == this.size() - 1L) {
            l = this._last();
        } else {
            long result;
            boolean bufferNotInitialized;
            long indexPosition = idx * (long)DefaultLongArray$.MODULE$.LONG_SIZE();
            boolean insideBuffer = this.isInsideBuffer(indexPosition, this.bufferOffset(), this.readBuffer().limit());
            boolean bl = bufferNotInitialized = this.bufferOffset() == -1L;
            if (bufferNotInitialized || !insideBuffer) {
                this.reloadBuffer(indexPosition);
            }
            long bufferPos = indexPosition - this.bufferOffset();
            this.readBuffer().position((int)bufferPos);
            l = result = this.readBuffer().getLong();
        }
        return l;
    }

    private boolean isInsideBuffer(long indexPosition, long bufferOffset, int bufferLimit) {
        return indexPosition >= bufferOffset && indexPosition <= bufferOffset + (long)bufferLimit - (long)DefaultLongArray$.MODULE$.LONG_SIZE();
    }

    public void reloadBuffer(long indexPosition) {
        if (this.unflushedCount() > 0) {
            this.seekToEOF();
            this.flushBuffer();
        }
        int totalBytesRead = 0;
        int result = 0;
        this.readBuffer().clear();
        do {
            result = this.randomAccessFile().getChannel().read(this.readBuffer(), indexPosition + (long)totalBytesRead);
            totalBytesRead += result;
        } while (result > 0);
        this.readBuffer().flip();
        this.bufferOffset_$eq(indexPosition);
    }

    @Override
    public boolean isPersisted() {
        return true;
    }

    public void finalize() {
        if (!this.isClosed()) {
            Predef$.MODULE$.println(new StringBuilder(119).append("[warning] PersistedLongArray(fileName: `").append(this.tempFile().getName()).append("` is being GCed but is still open. It is going to be closed to avoid tmp leaks.").toString());
            try {
                this.doClose(false);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        super.finalize();
    }

    private final void LongArrayIterator$lzycompute$1() {
        PersistedLongArray persistedLongArray = this;
        synchronized (persistedLongArray) {
            if (this.LongArrayIterator$module == null) {
                this.LongArrayIterator$module = new ILongArray$LongArrayIterator$(this);
            }
        }
    }

    public PersistedLongArray(WorkingDirectoryService workingDirectoryService, SettingsService settingsService, MemoryService memoryService) {
        this.workingDirectoryService = workingDirectoryService;
        this.memoryService = memoryService;
        ILongArray.$init$(this);
        TrackingClosable.$init$(this);
        this.fileSize = 0L;
        this._size = 0L;
        this.bufferOffset = -1L;
        this.bufferLimit = settingsService.memory().indexSize();
        this.readBuffer = memoryService.take("index-r");
        this.writeBuffer = memoryService.take("index-w");
        this._last = -1L;
        this.unflushedCount = 0;
    }
}

