/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.utils;

import java.io.Serializable;
import org.mule.weave.v2.parser.exception.InvalidEscapeException;
import org.mule.weave.v2.parser.location.Location;
import org.mule.weave.v2.parser.location.UnknownLocation$;
import org.mule.weave.v2.sdk.NameIdentifierHelper$;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class StringEscapeHelper$ {
    public static StringEscapeHelper$ MODULE$;

    static {
        new StringEscapeHelper$();
    }

    public String unescapeString(String str, char quotedBy, Location location) {
        Iterator<Object> charIterator = new StringOps(Predef$.MODULE$.augmentString(str)).iterator();
        StringBuilder result = new StringBuilder();
        while (charIterator.hasNext()) {
            StringBuilder stringBuilder;
            char next = BoxesRunTime.unboxToChar(charIterator.next());
            if (next == '\\' && charIterator.hasNext()) {
                char controlChar = BoxesRunTime.unboxToChar(charIterator.next());
                if (controlChar == quotedBy) {
                    stringBuilder = result.append(controlChar);
                    continue;
                }
                char c = controlChar;
                switch (c) {
                    case '/': 
                    case '\\': {
                        stringBuilder = result.append(controlChar);
                        break;
                    }
                    case 'n': {
                        stringBuilder = result.append('\n');
                        break;
                    }
                    case 'b': {
                        stringBuilder = result.append('\b');
                        break;
                    }
                    case 'f': {
                        stringBuilder = result.append('\f');
                        break;
                    }
                    case 'r': {
                        stringBuilder = result.append('\r');
                        break;
                    }
                    case 't': {
                        stringBuilder = result.append('\t');
                        break;
                    }
                    case '$': {
                        stringBuilder = result.append('$');
                        break;
                    }
                    case 'u': {
                        StringBuilder sb = new StringBuilder();
                        for (int i = 0; i < 4; ++i) {
                            Serializable serializable = charIterator.hasNext() ? sb.append(BoxesRunTime.unboxToChar(charIterator.next())) : BoxedUnit.UNIT;
                        }
                        try {
                            int codePoint = Integer.parseInt(sb.mkString(), 16);
                            String str1 = Character.toString((char)codePoint);
                            stringBuilder = result.append(str1);
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new InvalidEscapeException("Unicode", new java.lang.StringBuilder(1).append("\\").append(controlChar).append(sb.toString()).toString(), str, location);
                        }
                    }
                    default: {
                        stringBuilder = result.append(next).append(controlChar);
                        break;
                    }
                }
                continue;
            }
            stringBuilder = result.append(next);
        }
        return result.toString();
    }

    public char unescapeString$default$2() {
        return '\"';
    }

    public Location unescapeString$default$3() {
        return UnknownLocation$.MODULE$;
    }

    public String escapeString(String strValue, char quotes, boolean insertQuotes) {
        StringBuilder result = new StringBuilder();
        int len = strValue.length();
        Serializable serializable = insertQuotes ? result.append(quotes) : BoxedUnit.UNIT;
        for (int i = 0; i < len; ++i) {
            char c = strValue.charAt(i);
            StringBuilder stringBuilder = c == quotes ? result.append('\\').append(quotes) : ('\\' == c ? (len >= i + 6 && strValue.substring(i + 1, i + 6).matches("u[0-9a-fA-F]{4}") ? result.append("\\") : result.append("\\\\")) : ('$' == c ? result.append("\\$") : ('\b' == c ? result.append("\\b") : ('\f' == c ? result.append("\\f") : ('\n' == c ? result.append("\\n") : ('\r' == c ? result.append("\\r") : ('\t' == c ? result.append("\\t") : (this.isNonPrintableCharacter(c) ? result.append(new StringOps(Predef$.MODULE$.augmentString("\\u%04x")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(c)}))) : result.append(c)))))))));
        }
        Serializable serializable2 = insertQuotes ? result.append(quotes) : BoxedUnit.UNIT;
        return result.mkString();
    }

    public char escapeString$default$2() {
        return '\"';
    }

    public boolean escapeString$default$3() {
        return true;
    }

    private boolean isNonPrintableCharacter(char c) {
        return c == '\u00ad' || c >= '\u0000' && c <= '\u001f' || c >= '\u007f' && c <= '\u009f' || c >= '\u0600' && c <= '\u0604' || c == '\u070f' || c == '\u17b4' || c == '\u17b5' || c >= '\u200c' && c <= '\u200f' || c >= '\u2060' && c <= '\u206f' || c == '\ufeff' || c >= '\ufff0' && c <= '\uffff';
    }

    public boolean keyRequiresQuotes(String key) {
        return !NameIdentifierHelper$.MODULE$.isValidIdentifier(key);
    }

    private StringEscapeHelper$() {
        MODULE$ = this;
    }
}

