/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons.nodes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.raml.v2.internal.impl.v10.nodes.LibraryRefNode;
import org.raml.yagi.framework.nodes.AbstractRamlNode;
import org.raml.yagi.framework.nodes.KeyValueNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.NodeType;
import org.raml.yagi.framework.nodes.ReferenceNode;
import org.raml.yagi.framework.nodes.SimpleTypeNode;
import org.raml.yagi.framework.util.NodeUtils;

public abstract class AbstractReferenceNode
extends AbstractRamlNode
implements ReferenceNode {
    private Node refNode;
    private Node contextNode;

    public AbstractReferenceNode() {
    }

    public AbstractReferenceNode(AbstractReferenceNode node) {
        super(node);
        this.refNode = node.refNode;
        this.contextNode = node.contextNode;
    }

    @Override
    @Nullable
    public final Node getRefNode() {
        if (this.refNode == null) {
            this.refNode = this.resolveReference();
        }
        return this.refNode;
    }

    @Nullable
    public abstract Node resolveReference();

    private Node getRelativeNode() {
        if (!this.getChildren().isEmpty() && this.getChildren().get(0) instanceof ReferenceNode) {
            return ((ReferenceNode)this.getChildren().get(0)).getRefNode();
        }
        return NodeUtils.getContextNode(this);
    }

    protected List<Node> getContextNodes() {
        ArrayList<Node> contextNodes = new ArrayList<Node>();
        contextNodes.add(this.getRelativeNode());
        if (this.contextNode != null && this.contextNode != contextNodes.get(0)) {
            contextNodes.add(0, this.contextNode);
        }
        return contextNodes;
    }

    @Override
    public NodeType getType() {
        return NodeType.Reference;
    }

    public Map<String, Node> getParameters() {
        HashMap<String, Node> params = new HashMap<String, Node>();
        Node parametersNode = this.getParametersNode();
        if (parametersNode != null) {
            for (Node node : parametersNode.getChildren()) {
                KeyValueNode keyValueNode = (KeyValueNode)node;
                String paramName = ((SimpleTypeNode)keyValueNode.getKey()).getLiteralValue();
                Node value = keyValueNode.getValue();
                params.put(paramName, value.copy());
            }
        }
        return params;
    }

    public Node getParametersNode() {
        List<Node> children = this.getChildren();
        if (children.size() == 1 && children.get(0) instanceof KeyValueNode) {
            return ((KeyValueNode)children.get(0)).getValue();
        }
        if (children.size() == 2 && children.get(0) instanceof LibraryRefNode) {
            return ((KeyValueNode)children.get(1)).getValue();
        }
        return null;
    }

    @Override
    public void setContextNode(Node contextNode) {
        this.contextNode = contextNode;
    }
}

