/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.utils;

import java.util.ArrayList;
import java.util.List;
import org.raml.v2.internal.impl.commons.RamlVersion;
import org.raml.v2.internal.impl.commons.nodes.RamlVersionAnnotation;
import org.raml.v2.internal.impl.v10.nodes.LibraryLinkNode;
import org.raml.yagi.framework.nodes.ErrorNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.NodeAnnotation;
import org.raml.yagi.framework.util.NodeUtils;

public class RamlNodeUtils {
    public static boolean isErrorResult(Node node) {
        if (NodeUtils.isErrorResult(node)) {
            return true;
        }
        if (node != null) {
            List<LibraryLinkNode> descendantsWith = node.findDescendantsWith(LibraryLinkNode.class);
            for (LibraryLinkNode libraryLinkNode : descendantsWith) {
                if (!RamlNodeUtils.isErrorResult(libraryLinkNode.getRefNode())) continue;
                return true;
            }
        }
        return false;
    }

    public static List<ErrorNode> getErrors(Node node) {
        ArrayList<ErrorNode> result = new ArrayList<ErrorNode>();
        if (node != null) {
            if (node instanceof ErrorNode) {
                result.add((ErrorNode)node);
            }
            result.addAll(node.findDescendantsWith(ErrorNode.class));
            List<LibraryLinkNode> descendantsWith = node.findDescendantsWith(LibraryLinkNode.class);
            for (LibraryLinkNode libraryLinkNode : descendantsWith) {
                result.addAll(RamlNodeUtils.getErrors(libraryLinkNode.getRefNode()));
            }
        }
        return result;
    }

    public static RamlVersion getVersion(Node node) {
        do {
            for (NodeAnnotation annotation : node.annotations()) {
                if (!(annotation instanceof RamlVersionAnnotation)) continue;
                return ((RamlVersionAnnotation)annotation).getVersion();
            }
        } while ((node = node.getParent()) != null);
        throw new RuntimeException("Raml Version not specified.");
    }
}

