/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.utils;

import java.io.File;
import java.net.URI;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResourcePathUtils {
    private static final Pattern TEMPLATE_PATTERN = Pattern.compile("\\{([^}]+)\\}");

    public static String toAbsoluteLocation(String basePath, String relativePath) {
        String result = relativePath;
        if (!ResourcePathUtils.isAbsolute(relativePath)) {
            int lastSlash = basePath.lastIndexOf("/");
            if (lastSlash == -1) {
                lastSlash = basePath.lastIndexOf("/");
            }
            if (lastSlash != -1) {
                result = basePath.substring(0, lastSlash + 1) + relativePath;
                if (ResourcePathUtils.isUri(result)) {
                    URI resultUri = URI.create(result);
                    result = resultUri.normalize().toString();
                } else {
                    result = Paths.get(result, new String[0]).normalize().toString().replace("\\", "/");
                }
            }
        }
        if (result.contains("#")) {
            return result.split("#")[0];
        }
        return result;
    }

    public static boolean isUri(String includePath) {
        return includePath.startsWith("http:") || includePath.startsWith("https:") || includePath.startsWith("file:");
    }

    public static boolean isAbsolute(String includePath) {
        return includePath.startsWith("http:") || includePath.startsWith("https:") || includePath.startsWith("file:") || includePath.startsWith("/") || new File(includePath).isAbsolute();
    }

    public static List<String> getUriTemplates(String value) {
        ArrayList<String> result = new ArrayList<String>();
        if (value != null) {
            Matcher m4 = TEMPLATE_PATTERN.matcher(value);
            while (m4.find()) {
                result.add(m4.group(1));
            }
        }
        return result;
    }
}

