/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.utils;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.internal.impl.commons.nodes.ExternalSchemaTypeExpressionNode;
import org.raml.v2.internal.impl.commons.nodes.TypeDeclarationNode;
import org.raml.v2.internal.impl.commons.nodes.TypeExpressionNode;
import org.raml.v2.internal.impl.commons.type.JsonSchemaExternalType;
import org.raml.v2.internal.impl.commons.type.ResolvedType;
import org.raml.v2.internal.impl.commons.type.XmlSchemaExternalType;
import org.raml.v2.internal.impl.v10.nodes.NamedTypeExpressionNode;
import org.raml.v2.internal.utils.xml.XsdResourceResolver;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.util.NodeUtils;
import org.xml.sax.SAXException;

public class SchemaGenerator {
    private static String DEFINITIONS = "/definitions/";
    private static LoadingCache<JsonSchemaExternalType, JsonSchema> jsonSchemaCache = CacheBuilder.newBuilder().maximumSize(Integer.parseInt(System.getProperty("yagi.json_cache_size", "200"))).build(new CacheLoader<JsonSchemaExternalType, JsonSchema>(){

        @Override
        public JsonSchema load(JsonSchemaExternalType jsonTypeDefinition) throws IOException, ProcessingException {
            return SchemaGenerator.loadJsonSchema(jsonTypeDefinition);
        }
    });

    public static Schema generateXmlSchema(ResourceLoader resourceLoader, XmlSchemaExternalType xmlTypeDefinition) throws SAXException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        factory.setResourceResolver(new XsdResourceResolver(resourceLoader, xmlTypeDefinition.getSchemaPath()));
        String includedResourceUri = SchemaGenerator.resolveResourceUriIfIncluded(xmlTypeDefinition);
        return factory.newSchema(new StreamSource(new StringReader(xmlTypeDefinition.getSchemaValue()), includedResourceUri));
    }

    private static JsonSchema loadJsonSchema(JsonSchemaExternalType jsonTypeDefinition) throws IOException, ProcessingException {
        String includedResourceUri = SchemaGenerator.resolveResourceUriIfIncluded(jsonTypeDefinition);
        JsonNode jsonSchema = JsonLoader.fromString(jsonTypeDefinition.getSchemaValue());
        JsonSchemaFactory factory = JsonSchemaFactory.byDefault();
        JsonSchema result = jsonTypeDefinition.getInternalFragment() != null ? (includedResourceUri != null ? factory.getJsonSchema(includedResourceUri + "#" + DEFINITIONS + jsonTypeDefinition.getInternalFragment()) : factory.getJsonSchema(jsonSchema, DEFINITIONS + jsonTypeDefinition.getInternalFragment())) : (includedResourceUri != null ? factory.getJsonSchema(includedResourceUri) : factory.getJsonSchema(jsonSchema));
        return result;
    }

    public static JsonSchema generateJsonSchema(JsonSchemaExternalType jsonTypeDefinition) throws IOException, ProcessingException {
        try {
            return jsonSchemaCache.get(jsonTypeDefinition);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof JsonParseException) {
                throw (JsonParseException)e.getCause();
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new ProcessingException(e.getMessage(), e.getCause());
        }
    }

    @Nullable
    private static String resolveResourceUriIfIncluded(ResolvedType typeDefinition) {
        TypeExpressionNode typeExpressionNode = typeDefinition.getTypeExpressionNode();
        if (typeExpressionNode instanceof ExternalSchemaTypeExpressionNode) {
            ExternalSchemaTypeExpressionNode schema = (ExternalSchemaTypeExpressionNode)typeExpressionNode;
            return SchemaGenerator.getIncludedResourceUri(schema);
        }
        List<ExternalSchemaTypeExpressionNode> schemas = typeExpressionNode.findDescendantsWith(ExternalSchemaTypeExpressionNode.class);
        if (schemas.size() > 0) {
            return SchemaGenerator.getIncludedResourceUri(schemas.get(0));
        }
        List<NamedTypeExpressionNode> refNode = typeExpressionNode.findDescendantsWith(NamedTypeExpressionNode.class);
        if (refNode.size() > 0 && (typeExpressionNode = refNode.get(0).resolveReference()) != null && (schemas = typeExpressionNode.findDescendantsWith(ExternalSchemaTypeExpressionNode.class)).size() > 0) {
            return SchemaGenerator.getIncludedResourceUri(schemas.get(0));
        }
        return null;
    }

    private static String getIncludedResourceUri(ExternalSchemaTypeExpressionNode schemaNode) {
        TypeDeclarationNode parentTypeDeclaration;
        String includedResourceUri = schemaNode.getStartPosition().getIncludedResourceUri();
        if (includedResourceUri == null && (parentTypeDeclaration = NodeUtils.getAncestor((Node)schemaNode, TypeDeclarationNode.class)) != null) {
            return parentTypeDeclaration.getStartPosition().getIncludedResourceUri();
        }
        return includedResourceUri;
    }

    public static boolean isJsonSchema(String schema) {
        return schema.trim().startsWith("{");
    }

    public static boolean isXmlSchema(String schema) {
        return schema.trim().startsWith("<");
    }
}

