package org.mule.weave.v2.dwb.api;

import java.util.List;
import java.util.Map;

public interface IWeaveValue<T> {
    /**
     * This returns the underlying data, Strings, Integer, Map, List, etc...
     */
    T evaluate();

    default <X> X evaluateAs() {
        return (X) evaluate();
    }

    default Map<String, IWeaveValue<?>> evaluateAsObject() {
        return evaluateAs();
    }

    default List<IWeaveValue<?>> evaluateAsArray() {
        return evaluateAs();
    }

    default boolean isObject() {
        return false;
    }

    default boolean isArray() {
        return false;
    }

    void accept(IWeaveValueVisitor visitor);

    Map<String, IWeaveValue<?>> getSchema();
}
