package org.mule.weave.v2.dwb.api;

import javax.xml.namespace.QName;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.*;

@SuppressWarnings("unused")
public interface WeaveStreamWriter extends AutoCloseable {
    void flush();
    InputStream getResult();

    WeaveStreamWriter writeStartDocument();
    WeaveStreamWriter writeEndDocument();

    WeaveStreamWriter writeStartObject();
    WeaveStreamWriter writeEndObject();
    WeaveStreamWriter writeStartArray();
    WeaveStreamWriter writeEndArray();

    WeaveStreamWriter writeKey(String localName);
    WeaveStreamWriter writeKey(QName qName);

    WeaveStreamWriter writeStartAttribute();
    WeaveStreamWriter writeEndAttribute();

    WeaveStreamWriter writeStartSchema();
    WeaveStreamWriter writeEndSchema();

    WeaveStreamWriter writeInt(int number);
    WeaveStreamWriter writeLong(long number);
    WeaveStreamWriter writeBigInt(BigInteger number);
    WeaveStreamWriter writeDouble(double number);
    WeaveStreamWriter writeBigDecimal(BigDecimal number);

    WeaveStreamWriter writeString(String str);
    WeaveStreamWriter writeDateTime(ZonedDateTime zonedDateTime);
    WeaveStreamWriter writeLocalDate(LocalDate localDate);
    WeaveStreamWriter writePeriod(Period period);
    WeaveStreamWriter writeLocalDateTime(LocalDateTime localDateTime);
    WeaveStreamWriter writeTime(OffsetTime offsetTime);
    WeaveStreamWriter writeLocalTime(LocalTime localTime);
    WeaveStreamWriter writeTimeZone(ZoneId zoneId);
    WeaveStreamWriter writeBinary(byte[] bytes);
    WeaveStreamWriter writeBinary(InputStream inputStream);
    WeaveStreamWriter writeRegex(String regex);
    WeaveStreamWriter writeRange(int from, int to);
    WeaveStreamWriter writeNull();


    //---------------- Transactions ----------------
    WeaveStreamWriter beginTransaction();
    WeaveStreamWriter endTransaction();
    WeaveStreamWriter commit();
    WeaveStreamWriter rollback();

    //----------------------------------------------

    /**
     * Dumps the given dwb into this writer's output stream.
     */
    WeaveStreamWriter mergeStream(InputStream dwb);
}
