/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.excel;

import java.io.OutputStream;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.ArraySeq;
import org.mule.weave.v2.model.structure.KeyValuePair;
import org.mule.weave.v2.model.structure.ObjectSeq;
import org.mule.weave.v2.model.structure.QualifiedName;
import org.mule.weave.v2.model.types.ArrayType$;
import org.mule.weave.v2.model.types.BooleanType$;
import org.mule.weave.v2.model.types.DateTimeType$;
import org.mule.weave.v2.model.types.KeyType$;
import org.mule.weave.v2.model.types.LocalDateTimeType$;
import org.mule.weave.v2.model.types.LocalDateType$;
import org.mule.weave.v2.model.types.NumberType$;
import org.mule.weave.v2.model.types.ObjectType$;
import org.mule.weave.v2.model.types.StringType$;
import org.mule.weave.v2.model.types.TimeType$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.module.ConfigurableReaderWriter;
import org.mule.weave.v2.module.excel.ExcelSettings;
import org.mule.weave.v2.module.pojo.writer.converter.DataConverter;
import org.mule.weave.v2.module.pojo.writer.converter.DataConverter$;
import org.mule.weave.v2.module.pojo.writer.converter.JavaDataConverter;
import org.mule.weave.v2.module.writer.Writer;
import org.mule.weave.v2.parser.location.Location;
import org.mule.weave.v2.parser.location.LocationCapable;
import scala.Function1;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import spire.math.Number;

@ScalaSignature(bytes="\u0006\u0001\u0005=e\u0001B\u0001\u0003\u0001=\u00111\"\u0012=dK2<&/\u001b;fe*\u00111\u0001B\u0001\u0006Kb\u001cW\r\u001c\u0006\u0003\u000b\u0019\ta!\\8ek2,'BA\u0004\t\u0003\t1(G\u0003\u0002\n\u0015\u0005)q/Z1wK*\u00111\u0002D\u0001\u0005[VdWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\r\u0001\u0001C\u0006\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005]QR\"\u0001\r\u000b\u0005e!\u0011AB<sSR,'/\u0003\u0002\u001c1\t1qK]5uKJD\u0001\"\b\u0001\u0003\u0002\u0003\u0006IAH\u0001\u0003_N\u0004\"a\b\u0013\u000e\u0003\u0001R!!\t\u0012\u0002\u0005%|'\"A\u0012\u0002\t)\fg/Y\u0005\u0003K\u0001\u0012AbT;uaV$8\u000b\u001e:fC6DQa\n\u0001\u0005\u0002!\na\u0001P5oSRtDCA\u0015,!\tQ\u0003!D\u0001\u0003\u0011\u0015ib\u00051\u0001\u001f\u0011\u001di\u0003A1A\u0005B9\n\u0001b]3ui&twm]\u000b\u0002_A\u0011!\u0006M\u0005\u0003c\t\u0011Q\"\u0012=dK2\u001cV\r\u001e;j]\u001e\u001c\bBB\u001a\u0001A\u0003%q&A\u0005tKR$\u0018N\\4tA!AQ\u0007\u0001EC\u0002\u0013%a'\u0001\u0002xEV\tq\u0007\u0005\u00029\u00036\t\u0011H\u0003\u0002;w\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003yu\nA\u0001_:tM*\u0011ahP\u0001\u0004a>L'B\u0001!\r\u0003\u0019\t\u0007/Y2iK&\u0011!)\u000f\u0002\u000e'b\u001b6KR,pe.\u0014wn\\6\t\u000b\u0011\u0003A\u0011I#\u0002\rI,7/\u001e7u+\u00051\u0005CA\tH\u0013\tA%CA\u0002B]fDQA\u0013\u0001\u0005B-\u000b!b\u001e:ji\u00164\u0016\r\\;f)\ta\u0005\f\u0006\u0002N!B\u0011\u0011CT\u0005\u0003\u001fJ\u0011A!\u00168ji\")\u0011+\u0013a\u0002%\u0006\u00191\r\u001e=\u0011\u0005M3V\"\u0001+\u000b\u0005U3\u0011!B7pI\u0016d\u0017BA,U\u0005E)e/\u00197vCRLwN\\\"p]R,\u0007\u0010\u001e\u0005\u00063&\u0003\rAW\u0001\u0006m\u0006dW/\u001a\u0019\u00037\u000e\u00042\u0001X0b\u001b\u0005i&B\u00010U\u0003\u00191\u0018\r\\;fg&\u0011\u0001-\u0018\u0002\u0006-\u0006dW/\u001a\t\u0003E\u000ed\u0001\u0001B\u0005e1\u0006\u0005\t\u0011!B\u0001K\n\u0019q\fJ\u0019\u0012\u0005\u00194\u0005CA\th\u0013\tA'CA\u0004O_RD\u0017N\\4\t\u000b)\u0004A\u0011A6\u0002\u0015]\u0014\u0018\u000e^3TQ\u0016,G\u000fF\u0002m]n$\"!T7\t\u000bEK\u00079\u0001*\t\u000b=L\u0007\u0019\u00019\u0002\u0013MDW-\u001a;OC6,\u0007CA9y\u001d\t\u0011h\u000f\u0005\u0002t%5\tAO\u0003\u0002v\u001d\u00051AH]8pizJ!a\u001e\n\u0002\rA\u0013X\rZ3g\u0013\tI(P\u0001\u0004TiJLgn\u001a\u0006\u0003oJAQ\u0001`5A\u0002u\fAb\u001d5fKR\u001cuN\u001c;f]R\u0004RA`A\u0004\u0003\u001bq1a`A\u0002\u001d\r\u0019\u0018\u0011A\u0005\u0002'%\u0019\u0011Q\u0001\n\u0002\u000fA\f7m[1hK&!\u0011\u0011BA\u0006\u0005!IE/\u001a:bi>\u0014(bAA\u0003%A\"\u0011qBA\n!\u0011av,!\u0005\u0011\u0007\t\f\u0019\u0002\u0002\u0006\u0002\u0016m\f\t\u0011!A\u0003\u0002\u0015\u00141a\u0018\u00133\u0011\u001d\tI\u0002\u0001C\u0001\u00037\tq\u0002Z8Xe&$XMR5sgR\u0014vn\u001e\u000b\t\u0003;\t\t#a\u000b\u0002<Q\u0019Q*a\b\t\rE\u000b9\u0002q\u0001S\u0011!\t\u0019#a\u0006A\u0002\u0005\u0015\u0012!B:iK\u0016$\bc\u0001\u001d\u0002(%\u0019\u0011\u0011F\u001d\u0003\u0015MC6k\u0015$TQ\u0016,G\u000f\u0003\u0005\u0002.\u0005]\u0001\u0019AA\u0018\u0003!\u0011xn\u001e,bYV,\u0007\u0003BA\u0019\u0003oi!!a\r\u000b\u0007\u0005UB+A\u0005tiJ,8\r^;sK&!\u0011\u0011HA\u001a\u0005%y%M[3diN+\u0017\u000f\u0003\u0005\u0002>\u0005]\u0001\u0019AA \u0003\u0019\u0011xn\u001e(v[B\u0019\u0011#!\u0011\n\u0007\u0005\r#CA\u0002J]RDq!a\u0012\u0001\t\u0003\tI%\u0001\u0006e_^\u0013\u0018\u000e^3S_^$b!a\u0013\u0002P\u0005eCcA'\u0002N!1\u0011+!\u0012A\u0004IC\u0001\"!\u0015\u0002F\u0001\u0007\u00111K\u0001\u0004e><\bc\u0001\u001d\u0002V%\u0019\u0011qK\u001d\u0003\u0011MC6k\u0015$S_^D\u0001\"!\f\u0002F\u0001\u0007\u0011q\u0006\u0005\b\u0003;\u0002A\u0011AA0\u0003%9(/\u001b;f\u0007\u0016dG\u000e\u0006\u0004\u0002b\u0005\u0015\u0014q\u000e\u000b\u0004\u001b\u0006\r\u0004BB)\u0002\\\u0001\u000f!\u000b\u0003\u0005\u0002h\u0005m\u0003\u0019AA5\u0003\u0011\u0019W\r\u001c7\u0011\u0007a\nY'C\u0002\u0002ne\u0012\u0011b\u0015-T'\u001a\u001bU\r\u001c7\t\u0011\u0005E\u00141\fa\u0001\u0003g\n\u0011bY3mYZ\u000bG.^31\t\u0005U\u0014\u0011\u0010\t\u00059~\u000b9\bE\u0002c\u0003s\"1\"a\u001f\u0002p\u0005\u0005\t\u0011!B\u0001K\n\u0019q\fJ\u001a\t\u000f\u0005}\u0004\u0001\"\u0001\u0002\u0002\u0006\t2/\u001a;DK2dG)\u0019;b\r>\u0014X.\u0019;\u0015\u000b5\u000b\u0019)!\"\t\u0011\u0005\u001d\u0014Q\u0010a\u0001\u0003SBq!a\"\u0002~\u0001\u0007\u0001/\u0001\u0004g_Jl\u0017\r\u001e\u0005\b\u0003\u0017\u0003A\u0011IAG\u0003\u0015\u0019Gn\\:f)\u0005i\u0005")
public class ExcelWriter
implements Writer {
    private SXSSFWorkbook wb;
    private final OutputStream os;
    private final ExcelSettings settings;
    private volatile boolean bitmap$0;

    public void startDocument(LocationCapable location) {
        Writer.startDocument$((Writer)this, (LocationCapable)location);
    }

    public void defineNamespace(LocationCapable location, String prefix, String uri) {
        Writer.defineNamespace$((Writer)this, (LocationCapable)location, (String)prefix, (String)uri);
    }

    public void endDocument(LocationCapable location) {
        Writer.endDocument$((Writer)this, (LocationCapable)location);
    }

    public void flush() {
        Writer.flush$((Writer)this);
    }

    public void setOption(Location location, String optionName, Object value) {
        ConfigurableReaderWriter.setOption$((ConfigurableReaderWriter)this, (Location)location, (String)optionName, (Object)value);
    }

    public ExcelSettings settings() {
        return this.settings;
    }

    /*
     * WARNING - void declaration
     */
    private SXSSFWorkbook wb$lzycompute() {
        ExcelWriter excelWriter = this;
        synchronized (excelWriter) {
            if (!this.bitmap$0) {
                void var2_2;
                SXSSFWorkbook workbook = new SXSSFWorkbook(1000);
                workbook.setCompressTempFiles(true);
                this.wb = var2_2;
                this.bitmap$0 = true;
            }
        }
        return this.wb;
    }

    private SXSSFWorkbook wb() {
        return !this.bitmap$0 ? this.wb$lzycompute() : this.wb;
    }

    public Object result() {
        return this.os;
    }

    public void writeValue(Value<?> value, EvaluationContext ctx) {
        Iterator objectSeq = ((ObjectSeq)ObjectType$.MODULE$.coerce(value, ctx).evaluate(ctx)).toIterator(ctx);
        objectSeq.foreach((Function1 & Serializable & scala.Serializable)keyValuePair -> {
            ExcelWriter.$anonfun$writeValue$1(this, ctx, keyValuePair);
            return BoxedUnit.UNIT;
        });
        this.wb().write(this.os);
    }

    public void writeSheet(String sheetName, Iterator<Value<?>> sheetContent, EvaluationContext ctx) {
        SXSSFSheet sheet = this.wb().createSheet(sheetName);
        int rowNum = this.settings().headerRowNum();
        if (this.settings().header() && sheetContent.hasNext()) {
            ObjectSeq rowObjectSeq = (ObjectSeq)ObjectType$.MODULE$.coerce((Value)sheetContent.next(), ctx).evaluate(ctx);
            this.doWriteFirstRow(sheet, rowObjectSeq, rowNum, ctx);
            rowNum += 2;
        }
        while (sheetContent.hasNext()) {
            SXSSFRow row = sheet.createRow(rowNum);
            ObjectSeq rowObjectSeq = (ObjectSeq)ObjectType$.MODULE$.coerce((Value)sheetContent.next(), ctx).evaluate(ctx);
            this.doWriteRow(row, rowObjectSeq, ctx);
            ++rowNum;
        }
    }

    public void doWriteFirstRow(SXSSFSheet sheet, ObjectSeq rowValue, int rowNum, EvaluationContext ctx) {
        SXSSFRow row0 = sheet.createRow(rowNum);
        SXSSFRow row1 = sheet.createRow(rowNum + 1);
        int colNumber = this.settings().headerColNum();
        Iterator keyValuePairs = rowValue.toIterator(ctx);
        while (keyValuePairs.hasNext()) {
            KeyValuePair keyValuePair = (KeyValuePair)keyValuePairs.next();
            SXSSFCell headerCell = row0.createCell(colNumber);
            String headerString = ((QualifiedName)KeyType$.MODULE$.coerce(keyValuePair._1(), ctx).evaluate(ctx)).name();
            headerCell.setCellValue(headerString);
            SXSSFCell cell = row1.createCell(colNumber);
            this.writeCell(cell, keyValuePair._2(), ctx);
            ++colNumber;
        }
    }

    public void doWriteRow(SXSSFRow row, ObjectSeq rowValue, EvaluationContext ctx) {
        int colNumber = this.settings().headerColNum();
        Iterator keyValuePairs = rowValue.toIterator(ctx);
        while (keyValuePairs.hasNext()) {
            SXSSFCell cell = row.createCell(colNumber);
            Value cellValue = ((KeyValuePair)keyValuePairs.next())._2();
            this.writeCell(cell, cellValue, ctx);
            ++colNumber;
        }
    }

    public void writeCell(SXSSFCell cell, Value<?> cellValue, EvaluationContext ctx) {
        Value<?> value = cellValue;
        if (StringType$.MODULE$.accepts(value, ctx)) {
            String cellStr = (String)StringType$.MODULE$.coerce(value, ctx).evaluate(ctx);
            cell.setCellValue(cellStr);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (BooleanType$.MODULE$.accepts(value, ctx)) {
            boolean booleanValue = BoxesRunTime.unboxToBoolean((Object)BooleanType$.MODULE$.coerce(value, ctx).evaluate(ctx));
            cell.setCellValue(booleanValue);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (NumberType$.MODULE$.accepts(value, ctx)) {
            Number cellNumber = (Number)NumberType$.MODULE$.coerce(value, ctx).evaluate(ctx);
            cell.setCellValue(cellNumber.toDouble());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (TimeType$.MODULE$.accepts(value, ctx)) {
            OffsetTime timeValue = (OffsetTime)TimeType$.MODULE$.coerce(value, ctx).evaluate(ctx);
            String timeStr = timeValue.format(DateTimeFormatter.ofPattern("HH:mm:ss"));
            double excelTime = DateUtil.convertTime((String)timeStr);
            cell.setCellValue(excelTime);
            this.setCellDataFormat(cell, "hh:mm:ss");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (DateTimeType$.MODULE$.accepts(value, ctx) || LocalDateTimeType$.MODULE$.accepts(value, ctx)) {
            ZonedDateTime dateTime = (ZonedDateTime)DateTimeType$.MODULE$.coerce(value, ctx).evaluate(ctx);
            Calendar calendar = JavaDataConverter.CalendarDataConverter$$.MODULE$.asCalendar(dateTime);
            this.setCellDataFormat(cell, "yyyy-MM-ddThh:mm:ss");
            cell.setCellValue(calendar);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (LocalDateType$.MODULE$.accepts(value, ctx)) {
            LocalDate localDate = (LocalDate)LocalDateType$.MODULE$.coerce(value, ctx).evaluate(ctx);
            Date date = ((Calendar)DataConverter$.MODULE$.to((Object)localDate, value.valueType(ctx).schema(ctx), (DataConverter)JavaDataConverter.CalendarDataConverter$$.MODULE$).get()).getTime();
            cell.setCellValue(date);
            this.setCellDataFormat(cell, "yyyy-MM-dd");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void setCellDataFormat(SXSSFCell cell, String format) {
        CellStyle cellStyle = this.wb().createCellStyle();
        cellStyle.setDataFormat(this.wb().getCreationHelper().createDataFormat().getFormat(format));
        cell.setCellStyle(cellStyle);
    }

    public void close() {
        this.wb().dispose();
        this.os.close();
    }

    public static final /* synthetic */ void $anonfun$writeValue$1(ExcelWriter $this, EvaluationContext ctx$1, KeyValuePair keyValuePair) {
        String sheetName = ((QualifiedName)keyValuePair._1().evaluate(ctx$1)).name();
        ArraySeq sheetContent = (ArraySeq)ArrayType$.MODULE$.coerce(keyValuePair._2(), ctx$1).evaluate(ctx$1);
        $this.writeSheet(sheetName, sheetContent.toIterator(), ctx$1);
    }

    public ExcelWriter(OutputStream os) {
        this.os = os;
        ConfigurableReaderWriter.$init$((ConfigurableReaderWriter)this);
        Writer.$init$((Writer)this);
        this.settings = new ExcelSettings();
    }
}

