/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.excel;

import java.io.OutputStream;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.ArraySeq;
import org.mule.weave.v2.model.structure.KeyValuePair;
import org.mule.weave.v2.model.structure.ObjectSeq;
import org.mule.weave.v2.model.structure.QualifiedName;
import org.mule.weave.v2.model.types.ArrayType$;
import org.mule.weave.v2.model.types.BooleanType$;
import org.mule.weave.v2.model.types.DateTimeType$;
import org.mule.weave.v2.model.types.KeyType$;
import org.mule.weave.v2.model.types.LocalDateTimeType$;
import org.mule.weave.v2.model.types.LocalDateType$;
import org.mule.weave.v2.model.types.NumberType$;
import org.mule.weave.v2.model.types.ObjectType$;
import org.mule.weave.v2.model.types.StringType$;
import org.mule.weave.v2.model.types.TimeType$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.module.ConfigurableReaderWriter;
import org.mule.weave.v2.module.excel.ExcelSettings;
import org.mule.weave.v2.module.pojo.writer.converter.DataConverter;
import org.mule.weave.v2.module.pojo.writer.converter.DataConverter$;
import org.mule.weave.v2.module.pojo.writer.converter.JavaDataConverter;
import org.mule.weave.v2.module.writer.Writer;
import org.mule.weave.v2.parser.location.Location;
import org.mule.weave.v2.parser.location.LocationCapable;
import scala.Function1;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import spire.math.Number;

@ScalaSignature(bytes="\u0006\u0001\u0005Ue\u0001B\u0001\u0003\u0001=\u00111\"\u0012=dK2<&/\u001b;fe*\u00111\u0001B\u0001\u0006Kb\u001cW\r\u001c\u0006\u0003\u000b\u0019\ta!\\8ek2,'BA\u0004\t\u0003\t1(G\u0003\u0002\n\u0015\u0005)q/Z1wK*\u00111\u0002D\u0001\u0005[VdWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\r\u0001\u0001C\u0006\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005]QR\"\u0001\r\u000b\u0005e!\u0011AB<sSR,'/\u0003\u0002\u001c1\t1qK]5uKJD\u0001\"\b\u0001\u0003\u0002\u0003\u0006IAH\u0001\u0003_N\u0004\"a\b\u0013\u000e\u0003\u0001R!!\t\u0012\u0002\u0005%|'\"A\u0012\u0002\t)\fg/Y\u0005\u0003K\u0001\u0012AbT;uaV$8\u000b\u001e:fC6D\u0001b\n\u0001\u0003\u0006\u0004%\t\u0001K\u0001\tg\u0016$H/\u001b8hgV\t\u0011\u0006\u0005\u0002+W5\t!!\u0003\u0002-\u0005\tiQ\t_2fYN+G\u000f^5oOND\u0001B\f\u0001\u0003\u0002\u0003\u0006I!K\u0001\ng\u0016$H/\u001b8hg\u0002BQ\u0001\r\u0001\u0005\u0002E\na\u0001P5oSRtDc\u0001\u001a4iA\u0011!\u0006\u0001\u0005\u0006;=\u0002\rA\b\u0005\u0006O=\u0002\r!\u000b\u0005\tm\u0001A)\u0019!C\u0005o\u0005\u0011qOY\u000b\u0002qA\u0011\u0011HQ\u0007\u0002u)\u00111\bP\u0001\ngR\u0014X-Y7j]\u001eT!!\u0010 \u0002\ta\u001c8O\u001a\u0006\u0003\u007f\u0001\u000b1\u0001]8j\u0015\t\tE\"\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003\u0007j\u0012Qb\u0015-T'\u001a;vN]6c_>\\\u0007\"B#\u0001\t\u00032\u0015A\u0002:fgVdG/F\u0001H!\t\t\u0002*\u0003\u0002J%\t\u0019\u0011I\\=\t\u000b-\u0003A\u0011\t'\u0002\u0019\u0011|wK]5uKZ\u000bG.^3\u0015\u00055KFC\u0001(R!\t\tr*\u0003\u0002Q%\t!QK\\5u\u0011\u0015\u0011&\nq\u0001T\u0003\r\u0019G\u000f\u001f\t\u0003)^k\u0011!\u0016\u0006\u0003-\u001a\tQ!\\8eK2L!\u0001W+\u0003#\u00153\u0018\r\\;bi&|gnQ8oi\u0016DH\u000fC\u0003[\u0015\u0002\u00071,A\u0003wC2,X\r\r\u0002]IB\u0019Q\f\u00192\u000e\u0003yS!aX+\u0002\rY\fG.^3t\u0013\t\tgLA\u0003WC2,X\r\u0005\u0002dI2\u0001A!C3Z\u0003\u0003\u0005\tQ!\u0001g\u0005\ryF%M\t\u0003O\u001e\u0003\"!\u00055\n\u0005%\u0014\"a\u0002(pi\"Lgn\u001a\u0005\u0006W\u0002!\t\u0001\\\u0001\u000boJLG/Z*iK\u0016$HcA7pyR\u0011aJ\u001c\u0005\u0006%*\u0004\u001da\u0015\u0005\u0006a*\u0004\r!]\u0001\ng\",W\r\u001e(b[\u0016\u0004\"A]=\u000f\u0005M<\bC\u0001;\u0013\u001b\u0005)(B\u0001<\u000f\u0003\u0019a$o\\8u}%\u0011\u0001PE\u0001\u0007!J,G-\u001a4\n\u0005i\\(AB*ue&twM\u0003\u0002y%!)QP\u001ba\u0001}\u0006a1\u000f[3fi\u000e{g\u000e^3oiB)q0!\u0003\u0002\u00109!\u0011\u0011AA\u0003\u001d\r!\u00181A\u0005\u0002'%\u0019\u0011q\u0001\n\u0002\u000fA\f7m[1hK&!\u00111BA\u0007\u0005!IE/\u001a:bi>\u0014(bAA\u0004%A\"\u0011\u0011CA\u000b!\u0011i\u0006-a\u0005\u0011\u0007\r\f)\u0002\u0002\u0006\u0002\u0018q\f\t\u0011!A\u0003\u0002\u0019\u00141a\u0018\u00133\u0011\u001d\tY\u0002\u0001C\u0001\u0003;\tq\u0002Z8Xe&$XMR5sgR\u0014vn\u001e\u000b\t\u0003?\t\u0019#!\f\u0002>Q\u0019a*!\t\t\rI\u000bI\u0002q\u0001T\u0011!\t)#!\u0007A\u0002\u0005\u001d\u0012!B:iK\u0016$\bcA\u001d\u0002*%\u0019\u00111\u0006\u001e\u0003\u0015MC6k\u0015$TQ\u0016,G\u000f\u0003\u0005\u00020\u0005e\u0001\u0019AA\u0019\u0003!\u0011xn\u001e,bYV,\u0007\u0003BA\u001a\u0003si!!!\u000e\u000b\u0007\u0005]R+A\u0005tiJ,8\r^;sK&!\u00111HA\u001b\u0005%y%M[3diN+\u0017\u000f\u0003\u0005\u0002@\u0005e\u0001\u0019AA!\u0003\u0019\u0011xn\u001e(v[B\u0019\u0011#a\u0011\n\u0007\u0005\u0015#CA\u0002J]RDq!!\u0013\u0001\t\u0003\tY%\u0001\u0006e_^\u0013\u0018\u000e^3S_^$b!!\u0014\u0002R\u0005mCc\u0001(\u0002P!1!+a\u0012A\u0004MC\u0001\"a\u0015\u0002H\u0001\u0007\u0011QK\u0001\u0004e><\bcA\u001d\u0002X%\u0019\u0011\u0011\f\u001e\u0003\u0011MC6k\u0015$S_^D\u0001\"a\f\u0002H\u0001\u0007\u0011\u0011\u0007\u0005\b\u0003?\u0002A\u0011AA1\u0003%9(/\u001b;f\u0007\u0016dG\u000e\u0006\u0004\u0002d\u0005\u001d\u0014\u0011\u000f\u000b\u0004\u001d\u0006\u0015\u0004B\u0002*\u0002^\u0001\u000f1\u000b\u0003\u0005\u0002j\u0005u\u0003\u0019AA6\u0003\u0011\u0019W\r\u001c7\u0011\u0007e\ni'C\u0002\u0002pi\u0012\u0011b\u0015-T'\u001a\u001bU\r\u001c7\t\u0011\u0005M\u0014Q\fa\u0001\u0003k\n\u0011bY3mYZ\u000bG.^31\t\u0005]\u00141\u0010\t\u0005;\u0002\fI\bE\u0002d\u0003w\"1\"! \u0002r\u0005\u0005\t\u0011!B\u0001M\n\u0019q\fJ\u001a\t\u000f\u0005\u0005\u0005\u0001\"\u0001\u0002\u0004\u0006\t2/\u001a;DK2dG)\u0019;b\r>\u0014X.\u0019;\u0015\u000b9\u000b))a\"\t\u0011\u0005%\u0014q\u0010a\u0001\u0003WBq!!#\u0002\u0000\u0001\u0007\u0011/\u0001\u0004g_Jl\u0017\r\u001e\u0005\b\u0003\u001b\u0003A\u0011IAH\u0003\u0015\u0019Gn\\:f)\u0005q\u0005bBAJ\u0001\u0011\u0005\u0013qR\u0001\u0006M2,8\u000f\u001b")
public class ExcelWriter
implements Writer {
    private SXSSFWorkbook wb;
    private final OutputStream os;
    private final ExcelSettings settings;
    private volatile boolean bitmap$0;

    public void startDocument(LocationCapable location) {
        Writer.startDocument$((Writer)this, (LocationCapable)location);
    }

    public void defineNamespace(LocationCapable location, String prefix, String uri) {
        Writer.defineNamespace$((Writer)this, (LocationCapable)location, (String)prefix, (String)uri);
    }

    public final void writeValue(Value<?> value, EvaluationContext ctx) {
        Writer.writeValue$((Writer)this, value, (EvaluationContext)ctx);
    }

    public String getName() {
        return Writer.getName$((Writer)this);
    }

    public final void endDocument(LocationCapable location) {
        Writer.endDocument$((Writer)this, (LocationCapable)location);
    }

    public void doEndDocument(LocationCapable location) {
        Writer.doEndDocument$((Writer)this, (LocationCapable)location);
    }

    public void setOption(Location location, String optionName, Object value) {
        ConfigurableReaderWriter.setOption$((ConfigurableReaderWriter)this, (Location)location, (String)optionName, (Object)value);
    }

    public ExcelSettings settings() {
        return this.settings;
    }

    /*
     * WARNING - void declaration
     */
    private SXSSFWorkbook wb$lzycompute() {
        ExcelWriter excelWriter = this;
        synchronized (excelWriter) {
            if (!this.bitmap$0) {
                void var2_2;
                SXSSFWorkbook workbook = new SXSSFWorkbook(1000);
                workbook.setCompressTempFiles(true);
                this.wb = var2_2;
                this.bitmap$0 = true;
            }
        }
        return this.wb;
    }

    private SXSSFWorkbook wb() {
        return !this.bitmap$0 ? this.wb$lzycompute() : this.wb;
    }

    public Object result() {
        return this.os;
    }

    public void doWriteValue(Value<?> value, EvaluationContext ctx) {
        Iterator objectSeq = ((ObjectSeq)ObjectType$.MODULE$.coerce(value, ctx).evaluate(ctx)).toIterator(ctx);
        objectSeq.foreach((Function1 & Serializable & scala.Serializable)keyValuePair -> {
            ExcelWriter.$anonfun$doWriteValue$1(this, ctx, keyValuePair);
            return BoxedUnit.UNIT;
        });
        this.wb().write(this.os);
    }

    public void writeSheet(String sheetName, Iterator<Value<?>> sheetContent, EvaluationContext ctx) {
        SXSSFSheet sheet = this.wb().createSheet(sheetName);
        int rowNum = this.settings().headerRowNum();
        if (this.settings().header() && sheetContent.hasNext()) {
            ObjectSeq rowObjectSeq = (ObjectSeq)ObjectType$.MODULE$.coerce((Value)sheetContent.next(), ctx).evaluate(ctx);
            this.doWriteFirstRow(sheet, rowObjectSeq, rowNum, ctx);
            rowNum += 2;
        }
        while (sheetContent.hasNext()) {
            SXSSFRow row = sheet.createRow(rowNum);
            ObjectSeq rowObjectSeq = (ObjectSeq)ObjectType$.MODULE$.coerce((Value)sheetContent.next(), ctx).evaluate(ctx);
            this.doWriteRow(row, rowObjectSeq, ctx);
            ++rowNum;
        }
    }

    public void doWriteFirstRow(SXSSFSheet sheet, ObjectSeq rowValue, int rowNum, EvaluationContext ctx) {
        SXSSFRow row0 = sheet.createRow(rowNum);
        SXSSFRow row1 = sheet.createRow(rowNum + 1);
        int colNumber = this.settings().headerColNum();
        Iterator keyValuePairs = rowValue.toIterator(ctx);
        while (keyValuePairs.hasNext()) {
            KeyValuePair keyValuePair = (KeyValuePair)keyValuePairs.next();
            SXSSFCell headerCell = row0.createCell(colNumber);
            String headerString = ((QualifiedName)KeyType$.MODULE$.coerce(keyValuePair._1(), ctx).evaluate(ctx)).name();
            headerCell.setCellValue(headerString);
            SXSSFCell cell = row1.createCell(colNumber);
            this.writeCell(cell, keyValuePair._2(), ctx);
            ++colNumber;
        }
    }

    public void doWriteRow(SXSSFRow row, ObjectSeq rowValue, EvaluationContext ctx) {
        int colNumber = this.settings().headerColNum();
        Iterator keyValuePairs = rowValue.toIterator(ctx);
        while (keyValuePairs.hasNext()) {
            SXSSFCell cell = row.createCell(colNumber);
            Value cellValue = ((KeyValuePair)keyValuePairs.next())._2();
            this.writeCell(cell, cellValue, ctx);
            ++colNumber;
        }
    }

    public void writeCell(SXSSFCell cell, Value<?> cellValue, EvaluationContext ctx) {
        Value<?> value = cellValue;
        if (StringType$.MODULE$.accepts(value, ctx)) {
            String cellStr = (String)StringType$.MODULE$.coerce(value, ctx).evaluate(ctx);
            cell.setCellValue(cellStr);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (BooleanType$.MODULE$.accepts(value, ctx)) {
            boolean booleanValue = BoxesRunTime.unboxToBoolean((Object)BooleanType$.MODULE$.coerce(value, ctx).evaluate(ctx));
            cell.setCellValue(booleanValue);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (NumberType$.MODULE$.accepts(value, ctx)) {
            Number cellNumber = (Number)NumberType$.MODULE$.coerce(value, ctx).evaluate(ctx);
            cell.setCellValue(cellNumber.toDouble());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (TimeType$.MODULE$.accepts(value, ctx)) {
            OffsetTime timeValue = (OffsetTime)TimeType$.MODULE$.coerce(value, ctx).evaluate(ctx);
            String timeStr = timeValue.format(DateTimeFormatter.ofPattern("HH:mm:ss"));
            double excelTime = DateUtil.convertTime((String)timeStr);
            cell.setCellValue(excelTime);
            this.setCellDataFormat(cell, "hh:mm:ss");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (DateTimeType$.MODULE$.accepts(value, ctx) || LocalDateTimeType$.MODULE$.accepts(value, ctx)) {
            ZonedDateTime dateTime = (ZonedDateTime)DateTimeType$.MODULE$.coerce(value, ctx).evaluate(ctx);
            Calendar calendar = JavaDataConverter.CalendarDataConverter$$.MODULE$.asCalendar(dateTime);
            this.setCellDataFormat(cell, "yyyy-MM-ddThh:mm:ss");
            cell.setCellValue(calendar);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (LocalDateType$.MODULE$.accepts(value, ctx)) {
            LocalDate localDate = (LocalDate)LocalDateType$.MODULE$.coerce(value, ctx).evaluate(ctx);
            Date date = ((Calendar)DataConverter$.MODULE$.to((Object)localDate, value.valueType(ctx).schema(ctx), (DataConverter)JavaDataConverter.CalendarDataConverter$$.MODULE$).get()).getTime();
            cell.setCellValue(date);
            this.setCellDataFormat(cell, "yyyy-MM-dd");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void setCellDataFormat(SXSSFCell cell, String format) {
        CellStyle cellStyle = this.wb().createCellStyle();
        cellStyle.setDataFormat(this.wb().getCreationHelper().createDataFormat().getFormat(format));
        cell.setCellStyle(cellStyle);
    }

    public void close() {
        this.wb().dispose();
        this.os.close();
    }

    public void flush() {
        this.os.flush();
    }

    public static final /* synthetic */ void $anonfun$doWriteValue$1(ExcelWriter $this, EvaluationContext ctx$1, KeyValuePair keyValuePair) {
        String sheetName = ((QualifiedName)keyValuePair._1().evaluate(ctx$1)).name();
        ArraySeq sheetContent = (ArraySeq)ArrayType$.MODULE$.coerce(keyValuePair._2(), ctx$1).evaluate(ctx$1);
        $this.writeSheet(sheetName, sheetContent.toIterator(), ctx$1);
    }

    public ExcelWriter(OutputStream os, ExcelSettings settings) {
        this.os = os;
        this.settings = settings;
        ConfigurableReaderWriter.$init$((ConfigurableReaderWriter)this);
        Writer.$init$((Writer)this);
    }
}

