/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.http.functions.utils;

import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpCookie;
import java.util.List;
import java.util.Optional;
import org.mule.weave.v2.core.io.SeekableStream$;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.KeyValuePair;
import org.mule.weave.v2.model.structure.KeyValuePair$;
import org.mule.weave.v2.model.structure.schema.Schema;
import org.mule.weave.v2.model.values.BinaryValue$;
import org.mule.weave.v2.model.values.KeyValue$;
import org.mule.weave.v2.model.values.NumberValue$;
import org.mule.weave.v2.model.values.ObjectValue;
import org.mule.weave.v2.model.values.ObjectValue$;
import org.mule.weave.v2.model.values.ObjectValueBuilder;
import org.mule.weave.v2.model.values.StringValue$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.model.values.math.Number$;
import org.mule.weave.v2.module.http.functions.utils.HttpClientResponseConverter$;
import org.mule.weave.v2.module.http.functions.utils.HttpClientResponseCookieConverter;
import org.mule.weave.v2.module.http.functions.utils.MetadataConverter$;
import org.mule.weave.v2.module.http.functions.utils.StopWatch;
import org.mule.weave.v2.module.http.service.HttpClientHeaders;
import org.mule.weave.v2.module.http.service.HttpClientResponse;
import org.mule.weave.v2.module.reader.SourceProvider;
import org.mule.weave.v2.module.reader.SourceProvider$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rf\u0001B\u0011#\u0001MB\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\")a\t\u0001C\u0001\u000f\"91\n\u0001b\u0001\n\u0013a\u0005BB+\u0001A\u0003%Q\nC\u0004W\u0001\t\u0007I\u0011B,\t\rm\u0003\u0001\u0015!\u0003Y\u0011\u001da\u0006A1A\u0005\n]Ca!\u0018\u0001!\u0002\u0013A\u0006b\u00020\u0001\u0005\u0004%Ia\u0016\u0005\u0007?\u0002\u0001\u000b\u0011\u0002-\t\u000b\u0001\u0004A\u0011A1\t\u000bE\u0004A\u0011\u0002:\t\u000f\u0005=\u0001\u0001\"\u0003\u0002\u0012!9\u0011\u0011\b\u0001\u0005\n\u0005m\u0002bBA5\u0001\u0011%\u00111N\u0004\b\u0003w\u0012\u0003\u0012AA?\r\u0019\t#\u0005#\u0001\u0002\u0000!1aI\u0005C\u0001\u0003\u0003C\u0001\"a!\u0013\u0005\u0004%I\u0001\u0014\u0005\b\u0003\u000b\u0013\u0002\u0015!\u0003N\u0011!\t9I\u0005b\u0001\n\u0013a\u0005bBAE%\u0001\u0006I!\u0014\u0005\t\u0003\u0017\u0013\"\u0019!C\u0005\u0019\"9\u0011Q\u0012\n!\u0002\u0013i\u0005\u0002CAH%\t\u0007I\u0011\u0002'\t\u000f\u0005E%\u0003)A\u0005\u001b\"A\u00111\u0013\nC\u0002\u0013%A\nC\u0004\u0002\u0016J\u0001\u000b\u0011B'\t\u0011\u0005]%C1A\u0005\n1Cq!!'\u0013A\u0003%Q\nC\u0004\u0002\u001cJ!\t!!(\u00037!#H\u000f]\"mS\u0016tGOU3ta>t7/Z\"p]Z,'\u000f^3s\u0015\t\u0019C%A\u0003vi&d7O\u0003\u0002&M\u0005Ia-\u001e8di&|gn\u001d\u0006\u0003O!\nA\u0001\u001b;ua*\u0011\u0011FK\u0001\u0007[>$W\u000f\\3\u000b\u0005-b\u0013A\u0001<3\u0015\tic&A\u0003xK\u00064XM\u0003\u00020a\u0005!Q.\u001e7f\u0015\u0005\t\u0014aA8sO\u000e\u00011C\u0001\u00015!\t)\u0004(D\u00017\u0015\u00059\u0014!B:dC2\f\u0017BA\u001d7\u0005\u0019\te.\u001f*fM\u0006A!/Z:q_:\u001cX\r\u0005\u0002=\u007f5\tQH\u0003\u0002?M\u000591/\u001a:wS\u000e,\u0017B\u0001!>\u0005IAE\u000f\u001e9DY&,g\u000e\u001e*fgB|gn]3\u0002\u0013M$x\u000e],bi\u000eD\u0007CA\"E\u001b\u0005\u0011\u0013BA##\u0005%\u0019Fo\u001c9XCR\u001c\u0007.\u0001\u0004=S:LGO\u0010\u000b\u0004\u0011&S\u0005CA\"\u0001\u0011\u0015Q4\u00011\u0001<\u0011\u0015\t5\u00011\u0001C\u0003U\u0019uJ\u0014+F\u001dR{F*\u0012(H)\"{\u0006*R!E\u000bJ+\u0012!\u0014\t\u0003\u001dNk\u0011a\u0014\u0006\u0003!F\u000bA\u0001\\1oO*\t!+\u0001\u0003kCZ\f\u0017B\u0001+P\u0005\u0019\u0019FO]5oO\u000612i\u0014(U\u000b:#v\fT#O\u000fRCu\fS#B\t\u0016\u0013\u0006%\u0001\fO\u001f~\u001buJ\u0014+F\u001dR{6\u000bV!U+N{6i\u0014#F+\u0005A\u0006CA\u001bZ\u0013\tQfGA\u0002J]R\fqCT(`\u0007>sE+\u0012(U?N#\u0016\tV+T?\u000e{E)\u0012\u0011\u000219{EkX'P\t&3\u0015*\u0012#`'R\u000bE+V*`\u0007>#U)A\rO\u001fR{Vj\u0014#J\r&+EiX*U\u0003R+6kX\"P\t\u0016\u0003\u0013!\u0007*F'\u0016#vlQ(O)\u0016sEkX*U\u0003R+6kX\"P\t\u0016\u000b!DU#T\u000bR{6i\u0014(U\u000b:#vl\u0015+B)V\u001bvlQ(E\u000b\u0002\nqaY8om\u0016\u0014H\u000fF\u0001c)\t\u00197\u000e\u0005\u0002eS6\tQM\u0003\u0002gO\u00061a/\u00197vKNT!\u0001\u001b\u0016\u0002\u000b5|G-\u001a7\n\u0005),'aC(cU\u0016\u001cGOV1mk\u0016DQ\u0001\u001c\u0007A\u00045\f1a\u0019;y!\tqw.D\u0001h\u0013\t\u0001xMA\tFm\u0006dW/\u0019;j_:\u001cuN\u001c;fqR\fa\"Y:IK\u0006$WM]:WC2,X\rF\u0002t\u0003\u000b\u0001$\u0001^=\u0011\u0007\u0011,x/\u0003\u0002wK\n)a+\u00197vKB\u0011\u00010\u001f\u0007\u0001\t%QX\"!A\u0001\u0002\u000b\u00051PA\u0002`IE\n\"\u0001`@\u0011\u0005Uj\u0018B\u0001@7\u0005\u001dqu\u000e\u001e5j]\u001e\u00042!NA\u0001\u0013\r\t\u0019A\u000e\u0002\u0004\u0003:L\bbBA\u0004\u001b\u0001\u0007\u0011\u0011B\u0001\u0012QR$\bo\u00117jK:$\b*Z1eKJ\u001c\bc\u0001\u001f\u0002\f%\u0019\u0011QB\u001f\u0003#!#H\u000f]\"mS\u0016tG\u000fS3bI\u0016\u00148/A\u0007bg\u000e{wn[5f-\u0006dW/\u001a\u000b\u0005\u0003'\ti\u0002\r\u0003\u0002\u0016\u0005e\u0001\u0003\u00023v\u0003/\u00012\u0001_A\r\t)\tYBDA\u0001\u0002\u0003\u0015\ta\u001f\u0002\u0004?\u0012\u0012\u0004bBA\u0010\u001d\u0001\u0007\u0011\u0011E\u0001\bG>|7.[3t!\u0019\t\u0019#!\u000b\u0002.5\u0011\u0011Q\u0005\u0006\u0004\u0003O\t\u0016\u0001B;uS2LA!a\u000b\u0002&\t!A*[:u!\u0011\ty#!\u000e\u000e\u0005\u0005E\"bAA\u001a#\u0006\u0019a.\u001a;\n\t\u0005]\u0012\u0011\u0007\u0002\u000b\u0011R$\boQ8pW&,\u0017aB1eI\n{G-\u001f\u000b\u000b\u0003{\t9%a\u0016\u0002\\\u0005}C\u0003BA \u0003\u000b\u00022!NA!\u0013\r\t\u0019E\u000e\u0002\u0005+:LG\u000fC\u0003m\u001f\u0001\u000fQ\u000eC\u0004\u0002J=\u0001\r!a\u0013\u0002\t\t|G-\u001f\t\u0005\u0003\u001b\n\u0019&\u0004\u0002\u0002P)\u0019\u0011\u0011K)\u0002\u0005%|\u0017\u0002BA+\u0003\u001f\u00121\"\u00138qkR\u001cFO]3b[\"1\u0011\u0011L\bA\u0002a\u000b!b\u001d;biV\u001c8i\u001c3f\u0011\u001d\tif\u0004a\u0001\u0003\u0013\tq\u0001[3bI\u0016\u00148\u000fC\u0004\u0002b=\u0001\r!a\u0019\u0002\u000f\t,\u0018\u000e\u001c3feB\u0019A-!\u001a\n\u0007\u0005\u001dTM\u0001\nPE*,7\r\u001e,bYV,')^5mI\u0016\u0014\u0018\u0001F3yiJ\f7\r^\"p]R,g\u000e\u001e'f]\u001e$\b\u000e\u0006\u0003\u0002n\u0005e\u0004#B\u001b\u0002p\u0005M\u0014bAA9m\t1q\n\u001d;j_:\u00042!NA;\u0013\r\t9H\u000e\u0002\u0005\u0019>tw\rC\u0004\u0002^A\u0001\r!!\u0003\u00027!#H\u000f]\"mS\u0016tGOU3ta>t7/Z\"p]Z,'\u000f^3s!\t\u0019%c\u0005\u0002\u0013iQ\u0011\u0011QP\u0001\u0007'R\u000bE+V*\u0002\u000fM#\u0016\tV+TA\u0005Y1\u000bV!U+N{F+\u0012-U\u00031\u0019F+\u0011+V'~#V\t\u0017+!\u0003\u001dAU)\u0011#F%N\u000b\u0001\u0002S#B\t\u0016\u00136\u000bI\u0001\u0005\u0005>#\u0015,A\u0003C\u001f\u0012K\u0006%A\u0004D\u001f>[\u0015*R*\u0002\u0011\r{ujS%F'\u0002\nAbQ(O)\u0016sEk\u0018+Z!\u0016\u000bQbQ(O)\u0016sEk\u0018+Z!\u0016\u0003\u0013!B1qa2LH#\u0002%\u0002 \u0006\u0005\u0006\"\u0002\u001e!\u0001\u0004Y\u0004\"B!!\u0001\u0004\u0011\u0005")
public class HttpClientResponseConverter {
    private final HttpClientResponse response;
    private final StopWatch stopWatch;
    private final String CONTENT_LENGTH_HEADER;
    private final int NO_CONTENT_STATUS_CODE;
    private final int NOT_MODIFIED_STATUS_CODE;
    private final int RESET_CONTENT_STATUS_CODE;

    public static HttpClientResponseConverter apply(HttpClientResponse httpClientResponse, StopWatch stopWatch) {
        return HttpClientResponseConverter$.MODULE$.apply(httpClientResponse, stopWatch);
    }

    private String CONTENT_LENGTH_HEADER() {
        return this.CONTENT_LENGTH_HEADER;
    }

    private int NO_CONTENT_STATUS_CODE() {
        return this.NO_CONTENT_STATUS_CODE;
    }

    private int NOT_MODIFIED_STATUS_CODE() {
        return this.NOT_MODIFIED_STATUS_CODE;
    }

    private int RESET_CONTENT_STATUS_CODE() {
        return this.RESET_CONTENT_STATUS_CODE;
    }

    public ObjectValue convert(EvaluationContext ctx) {
        ObjectValueBuilder builder = new ObjectValueBuilder();
        builder.addPair(HttpClientResponseConverter$.MODULE$.org$mule$weave$v2$module$http$functions$utils$HttpClientResponseConverter$$STATUS(), (Value)NumberValue$.MODULE$.apply(Number$.MODULE$.apply(this.response.getStatus())));
        this.response.getStatusText().ifPresent(st -> builder.addPair(HttpClientResponseConverter$.MODULE$.org$mule$weave$v2$module$http$functions$utils$HttpClientResponseConverter$$STATUS_TEXT(), (Value)StringValue$.MODULE$.apply(st)));
        builder.addPair(HttpClientResponseConverter$.MODULE$.org$mule$weave$v2$module$http$functions$utils$HttpClientResponseConverter$$HEADERS(), this.asHeadersValue(this.response.getHeaders()));
        this.response.getBody().ifPresent(body -> this.addBody((InputStream)body, $this.response.getStatus(), $this.response.getHeaders(), builder, ctx));
        builder.addPair(HttpClientResponseConverter$.MODULE$.org$mule$weave$v2$module$http$functions$utils$HttpClientResponseConverter$$COOKIES(), this.asCookieValue(this.response.getCookies()));
        this.response.getContentType().ifPresent(contentType -> builder.addPair(HttpClientResponseConverter$.MODULE$.org$mule$weave$v2$module$http$functions$utils$HttpClientResponseConverter$$CONTENT_TYPE(), (Value)StringValue$.MODULE$.apply(contentType)));
        this.stopWatch.stop();
        Schema schema = MetadataConverter$.MODULE$.apply(this.response.getMetadata(), this.stopWatch.getTotal()).convert();
        return builder.withSchema(schema);
    }

    private Value<?> asHeadersValue(HttpClientHeaders httpClientHeaders) {
        Seq entries = httpClientHeaders != null && httpClientHeaders.getHeaders() != null ? (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(httpClientHeaders.getHeaders()).asScala()).map((Function1 & Serializable & scala.Serializable)header -> new KeyValuePair((Value)KeyValue$.MODULE$.apply(header.getName()), (Value)StringValue$.MODULE$.apply(header.getValue()), KeyValuePair$.MODULE$.apply$default$3()), Buffer$.MODULE$.canBuildFrom()) : (Seq)Nil$.MODULE$;
        return ObjectValue$.MODULE$.apply((KeyValuePair[])entries.toArray(ClassTag$.MODULE$.apply(KeyValuePair.class)));
    }

    private Value<?> asCookieValue(List<HttpCookie> cookies) {
        Seq entries = cookies != null ? (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(cookies).asScala()).map((Function1 & Serializable & scala.Serializable)cookie -> {
            HttpClientResponseCookieConverter converter = new HttpClientResponseCookieConverter((HttpCookie)cookie);
            return new KeyValuePair((Value)KeyValue$.MODULE$.apply(cookie.getName()), (Value)converter.convert(), KeyValuePair$.MODULE$.apply$default$3());
        }, Buffer$.MODULE$.canBuildFrom()) : (Seq)Nil$.MODULE$;
        return ObjectValue$.MODULE$.apply((KeyValuePair[])entries.toArray(ClassTag$.MODULE$.apply(KeyValuePair.class)));
    }

    private void addBody(InputStream body, int statusCode, HttpClientHeaders headers, ObjectValueBuilder builder, EvaluationContext ctx) {
        boolean addBodyField = true;
        Option<Object> maybeContentLength = this.extractContentLength(headers);
        if (maybeContentLength.isDefined()) {
            long contentLength = BoxesRunTime.unboxToLong((Object)maybeContentLength.get());
            if (contentLength <= 0L) {
                addBodyField = false;
                if (ctx.serviceManager().loggingService().isDebugEnabled()) {
                    ctx.serviceManager().loggingService().logDebug(new StringBuilder(59).append("Ignoring HTTP response body field because ").append(this.CONTENT_LENGTH_HEADER()).append(" header value is ").append(contentLength).toString());
                }
            }
        } else if (this.NO_CONTENT_STATUS_CODE() == statusCode || this.NOT_MODIFIED_STATUS_CODE() == statusCode || this.RESET_CONTENT_STATUS_CODE() == statusCode) {
            addBodyField = false;
            if (ctx.serviceManager().loggingService().isDebugEnabled()) {
                ctx.serviceManager().loggingService().logDebug(new StringBuilder(76).append("Ignoring HTTP response body field because the status: ").append(statusCode).append(" does not support body").toString());
            }
        }
        if (addBodyField) {
            SourceProvider sourceProvider = SourceProvider$.MODULE$.apply((Object)SeekableStream$.MODULE$.apply(body, ctx));
            builder.addPair(HttpClientResponseConverter$.MODULE$.org$mule$weave$v2$module$http$functions$utils$HttpClientResponseConverter$$BODY(), (Value)BinaryValue$.MODULE$.apply(sourceProvider.asInputStream(ctx), ctx));
            return;
        }
    }

    private Option<Object> extractContentLength(HttpClientHeaders headers) {
        if (headers != null) {
            Optional<String> contentLengthHeaderValues = headers.firstValueIgnoreCase(this.CONTENT_LENGTH_HEADER());
            if (contentLengthHeaderValues.isPresent()) {
                None$ contentLength = None$.MODULE$;
                try {
                    contentLength = new Some((Object)BoxesRunTime.boxToLong((long)Long.parseLong(contentLengthHeaderValues.get())));
                }
                catch (NumberFormatException numberFormatException) {}
                return contentLength;
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    public HttpClientResponseConverter(HttpClientResponse response, StopWatch stopWatch) {
        this.response = response;
        this.stopWatch = stopWatch;
        this.CONTENT_LENGTH_HEADER = "Content-Length";
        this.NO_CONTENT_STATUS_CODE = 204;
        this.NOT_MODIFIED_STATUS_CODE = 304;
        this.RESET_CONTENT_STATUS_CODE = 205;
    }
}

