/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.http.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class HttpClientHeaders {
    private final List<HttpHeader> headers;

    public HttpClientHeaders(List<HttpHeader> headers) {
        this.headers = headers;
    }

    public List<HttpHeader> getHeaders() {
        return Collections.unmodifiableList(this.headers);
    }

    public Set<String> names() {
        return this.headers.stream().map(HttpHeader::getName).collect(Collectors.toSet());
    }

    public Set<String> namesIgnoreCase() {
        TreeSet<String> names = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        this.headers.forEach(header -> names.add(header.getName()));
        return names;
    }

    public List<String> allValues(String name) {
        return this.headers.stream().filter(h -> h.getName().equals(name)).map(HttpHeader::getValue).collect(Collectors.toList());
    }

    public List<String> allValuesIgnoreCase(String name) {
        return this.headers.stream().filter(h -> h.getName().equalsIgnoreCase(name)).map(HttpHeader::getValue).collect(Collectors.toList());
    }

    public Optional<String> firstValue(String name) {
        return this.headers.stream().filter(h -> h.getName().equals(name)).map(HttpHeader::getValue).findFirst();
    }

    public Optional<String> firstValueIgnoreCase(String name) {
        return this.headers.stream().filter(h -> h.getName().equalsIgnoreCase(name)).map(HttpHeader::getValue).findFirst();
    }

    public static HttpClientHeaders of(Map<String, List<String>> headers) {
        Objects.requireNonNull(headers, "'headers' must not be null");
        ArrayList<HttpHeader> headersList = new ArrayList<HttpHeader>();
        headers.forEach((key, values) -> values.forEach(value -> {
            HttpHeader header = new HttpHeader((String)key, (String)value);
            headersList.add(header);
        }));
        return new HttpClientHeaders(headersList);
    }

    public static final class HttpHeader {
        private final String name;
        private final String value;

        public HttpHeader(String name, String value) {
            Objects.requireNonNull(name, "name must not be null");
            Objects.requireNonNull(value, "value must not be null");
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public static HttpHeader of(String name, String value) {
            return new HttpHeader(name, value);
        }
    }

    public static final class Builder {
        private final List<HttpHeader> headers = new ArrayList<HttpHeader>();

        public Builder addHeader(String name, String value) {
            Objects.requireNonNull(name, "name must not be null");
            Objects.requireNonNull(value, "value must not be null");
            return this.addHeader(HttpHeader.of(name, value));
        }

        public Builder addHeader(HttpHeader header) {
            Objects.requireNonNull(header, "header must not be null");
            this.headers.add(header);
            return this;
        }

        public HttpClientHeaders build() {
            return new HttpClientHeaders(this.headers);
        }
    }
}

