/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.http.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.mule.weave.v2.module.http.netty.NettyHttpServerInitializer;
import org.mule.weave.v2.module.http.service.FailedStatus;
import org.mule.weave.v2.module.http.service.HttpServerConfig;
import org.mule.weave.v2.module.http.service.HttpServerRequest;
import org.mule.weave.v2.module.http.service.HttpServerResponse;
import org.mule.weave.v2.module.http.service.HttpServerService;
import org.mule.weave.v2.module.http.service.HttpServerStatus;
import org.mule.weave.v2.module.http.service.RunningStatus;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001e2Aa\u0001\u0003\u0001'!)\u0001\u0005\u0001C\u0001C!)A\u0005\u0001C!K\t1b*\u001a;us\"#H\u000f]*feZ,'oU3sm&\u001cWM\u0003\u0002\u0006\r\u0005)a.\u001a;us*\u0011q\u0001C\u0001\u0005QR$\bO\u0003\u0002\n\u0015\u00051Qn\u001c3vY\u0016T!a\u0003\u0007\u0002\u0005Y\u0014$BA\u0007\u000f\u0003\u00159X-\u0019<f\u0015\ty\u0001#\u0001\u0003nk2,'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001!\"\u0004\u0005\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIbC\u0001\u0004B]f\u0014VM\u001a\t\u00037yi\u0011\u0001\b\u0006\u0003;\u0019\tqa]3sm&\u001cW-\u0003\u0002 9\t\t\u0002\n\u001e;q'\u0016\u0014h/\u001a:TKJ4\u0018nY3\u0002\rqJg.\u001b;?)\u0005\u0011\u0003CA\u0012\u0001\u001b\u0005!\u0011AB:feZ,'\u000fF\u0002'S9\u0002\"aG\u0014\n\u0005!b\"\u0001\u0005%uiB\u001cVM\u001d<feN#\u0018\r^;t\u0011\u0015Q#\u00011\u0001,\u0003\u0019\u0019wN\u001c4jOB\u00111\u0004L\u0005\u0003[q\u0011\u0001\u0003\u0013;uaN+'O^3s\u0007>tg-[4\t\u000b=\u0012\u0001\u0019\u0001\u0019\u0002\u0011\r\fG\u000e\u001c2bG.\u0004B!F\u00194m%\u0011!G\u0006\u0002\n\rVt7\r^5p]F\u0002\"a\u0007\u001b\n\u0005Ub\"!\u0005%uiB\u001cVM\u001d<feJ+\u0017/^3tiB\u00111dN\u0005\u0003qq\u0011!\u0003\u0013;uaN+'O^3s%\u0016\u001c\bo\u001c8tK\u0002")
public class NettyHttpServerService
implements HttpServerService {
    public HttpServerStatus server(HttpServerConfig config, Function1<HttpServerRequest, HttpServerResponse> callback) {
        Success success;
        ChannelFuture serverChannelFuture;
        FailedStatus failedStatus;
        Try triedUnit;
        NioEventLoopGroup boss = new NioEventLoopGroup();
        NioEventLoopGroup workers = new NioEventLoopGroup();
        ServerBootstrap bootstrap = new ServerBootstrap();
        ((ServerBootstrap)bootstrap.group((EventLoopGroup)boss, (EventLoopGroup)workers).channel(NioServerSocketChannel.class).localAddress((SocketAddress)new InetSocketAddress(config.host(), config.port()))).childHandler((ChannelHandler)new NettyHttpServerInitializer(config, callback));
        Try try_ = triedUnit = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> bootstrap.bind().sync());
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            exception.printStackTrace();
            failedStatus = new FailedStatus(exception.getMessage());
        } else if (try_ instanceof Success && (serverChannelFuture = (ChannelFuture)(success = (Success)try_).value()) != null) {
            ChannelFuture channelFuture = serverChannelFuture;
            failedStatus = new RunningStatus(config.host(), config.port(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Predef$.MODULE$.println((Object)"Stopping server.");
                boss.shutdownGracefully();
                workers.shutdownGracefully();
                channelFuture.channel().closeFuture().sync();
                Predef$.MODULE$.println((Object)"Server stopped.");
            });
        } else {
            throw new MatchError((Object)try_);
        }
        return failedStatus;
    }
}

