/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.http.functions;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.ServiceManager;
import org.mule.weave.v2.model.capabilities.UnknownLocationCapable$;
import org.mule.weave.v2.model.structure.KeyValuePair;
import org.mule.weave.v2.model.structure.ObjectSeq;
import org.mule.weave.v2.model.types.BinaryType$;
import org.mule.weave.v2.model.types.FunctionType$;
import org.mule.weave.v2.model.types.ObjectType$;
import org.mule.weave.v2.model.types.Type;
import org.mule.weave.v2.model.values.BooleanValue$;
import org.mule.weave.v2.model.values.BridgeFunctionValue;
import org.mule.weave.v2.model.values.BridgeFunctionValue$;
import org.mule.weave.v2.model.values.Function2Value;
import org.mule.weave.v2.model.values.FunctionValue;
import org.mule.weave.v2.model.values.KeyValue$;
import org.mule.weave.v2.model.values.NumberValue$;
import org.mule.weave.v2.model.values.ObjectValue;
import org.mule.weave.v2.model.values.ObjectValue$;
import org.mule.weave.v2.model.values.StringValue$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.model.values.WeaveFunction2;
import org.mule.weave.v2.module.DataFormat;
import org.mule.weave.v2.module.DataFormatManager$;
import org.mule.weave.v2.module.http.functions.HttpBodyValue;
import org.mule.weave.v2.module.http.functions.HttpBodyValue$;
import org.mule.weave.v2.module.http.functions.HttpServerFunction$;
import org.mule.weave.v2.module.http.service.FailedStatus;
import org.mule.weave.v2.module.http.service.HttpConfig;
import org.mule.weave.v2.module.http.service.HttpRequest;
import org.mule.weave.v2.module.http.service.HttpResponse;
import org.mule.weave.v2.module.http.service.HttpServerService;
import org.mule.weave.v2.module.http.service.HttpServerStatus;
import org.mule.weave.v2.module.http.service.RunningStatus;
import org.mule.weave.v2.module.http.undertow.UndertowHttpServerService;
import org.mule.weave.v2.module.reader.AutoPersistedOutputStream;
import org.mule.weave.v2.module.writer.Writer;
import org.mule.weave.v2.parser.location.LocationCapable;
import org.mule.weave.v2.util.ObjectValueUtils$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import spire.math.Number$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015e\u0001B\u0001\u0003\u0001E\u0011!\u0003\u0013;uaN+'O^3s\rVt7\r^5p]*\u00111\u0001B\u0001\nMVt7\r^5p]NT!!\u0002\u0004\u0002\t!$H\u000f\u001d\u0006\u0003\u000f!\ta!\\8ek2,'BA\u0005\u000b\u0003\t1(G\u0003\u0002\f\u0019\u0005)q/Z1wK*\u0011QBD\u0001\u0005[VdWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\r\u0001!\u0003\u0007\t\u0003'Yi\u0011\u0001\u0006\u0006\u0002+\u0005)1oY1mC&\u0011q\u0003\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005eqR\"\u0001\u000e\u000b\u0005ma\u0012A\u0002<bYV,7O\u0003\u0002\u001e\u0011\u0005)Qn\u001c3fY&\u0011qD\u0007\u0002\u000f/\u0016\fg/\u001a$v]\u000e$\u0018n\u001c83\u0011\u0015\t\u0003\u0001\"\u0001#\u0003\u0019a\u0014N\\5u}Q\t1\u0005\u0005\u0002%\u00015\t!\u0001C\u0003'\u0001\u0011\u0005q%\u0001\tu_N+\u0017o\u00142kK\u000e$h+\u00197vKR\u0011\u0001f\u000b\t\u00033%J!A\u000b\u000e\u0003\u0017=\u0013'.Z2u-\u0006dW/\u001a\u0005\u0006Y\u0015\u0002\r!L\u0001\bQ\u0016\fG-\u001a:t!\rqc'\u000f\b\u0003_Qr!\u0001M\u001a\u000e\u0003ER!A\r\t\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0012BA\u001b\u0015\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u000e\u001d\u0003\u0007M+\u0017O\u0003\u00026)A!1C\u000f\u001f=\u0013\tYDC\u0001\u0004UkBdWM\r\t\u0003{\u0005s!AP \u0011\u0005A\"\u0012B\u0001!\u0015\u0003\u0019\u0001&/\u001a3fM&\u0011!i\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0001#\u0002\"B#\u0001\t\u00031\u0015\u0001\u0006;p%\u0016\fX/Z:u\u001f\nTWm\u0019;WC2,X\r\u0006\u0002)\u000f\")\u0001\n\u0012a\u0001\u0013\u00069!/Z9vKN$\bC\u0001&N\u001b\u0005Y%B\u0001'\u0005\u0003\u001d\u0019XM\u001d<jG\u0016L!AT&\u0003\u0017!#H\u000f\u001d*fcV,7\u000f\u001e\u0005\u0006!\u0002!\t!U\u0001\u000fi>DE\u000f\u001e9SKN\u0004xN\\:f)\t\u0011F\f\u0006\u0002T-B\u0011!\nV\u0005\u0003+.\u0013A\u0002\u0013;uaJ+7\u000f]8og\u0016DQaV(A\u0004a\u000b1a\u0019;y!\tI&,D\u0001\u001d\u0013\tYFDA\tFm\u0006dW/\u0019;j_:\u001cuN\u001c;fqRDQ!X(A\u0002y\u000bQA^1mk\u0016\u0004$a\u00183\u0011\u0007e\u0001'-\u0003\u0002b5\t)a+\u00197vKB\u00111\r\u001a\u0007\u0001\t%)G,!A\u0001\u0002\u000b\u0005aMA\u0002`IE\n\"a\u001a6\u0011\u0005MA\u0017BA5\u0015\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"aE6\n\u00051$\"aA!os\")a\u000e\u0001C!_\u0006!1-\u00197m)\u0011\u0001Xo\u001e@1\u0005E\u001c\bcA\raeB\u00111m\u001d\u0003\ni6\f\t\u0011!A\u0003\u0002\u0019\u00141a\u0018\u00135\u0011\u00151X\u000e1\u0001Y\u0003\u001d\u0019wN\u001c;fqRDQ\u0001_7A\u0002e\faA^1mk\u0016\f\u0004G\u0001>}!\rI\u0002m\u001f\t\u0003Gr$\u0011\"`<\u0002\u0002\u0003\u0005)\u0011\u00014\u0003\u0007}##\u0007\u0003\u0004\u0000[\u0002\u0007\u0011\u0011A\u0001\u0007m\u0006dW/\u001a\u001a1\t\u0005\r\u0011q\u0001\t\u00053\u0001\f)\u0001E\u0002d\u0003\u000f!!\"!\u0003\u007f\u0003\u0003\u0005\tQ!\u0001g\u0005\ryFeM\u0004\b\u0003\u001b\u0011\u0001\u0012AA\b\u0003IAE\u000f\u001e9TKJ4XM\u001d$v]\u000e$\u0018n\u001c8\u0011\u0007\u0011\n\tB\u0002\u0004\u0002\u0005!\u0005\u00111C\n\u0004\u0003#\u0011\u0002bB\u0011\u0002\u0012\u0011\u0005\u0011q\u0003\u000b\u0003\u0003\u001fA!\"a\u0007\u0002\u0012\t\u0007I\u0011AA\u000f\u00035\u0011u\nR-`\u0017\u0016KvLT!N\u000bV\u0011\u0011q\u0004\t\u0005\u0003C\tY#\u0004\u0002\u0002$)!\u0011QEA\u0014\u0003\u0011a\u0017M\\4\u000b\u0005\u0005%\u0012\u0001\u00026bm\u0006L1AQA\u0012\u0011%\ty#!\u0005!\u0002\u0013\ty\"\u0001\bC\u001f\u0012KvlS#Z?:\u000bU*\u0012\u0011\t\u0015\u0005M\u0012\u0011\u0003b\u0001\n\u0003\ti\"\u0001\tI\u000b\u0006#UIU*`\u0017\u0016KvLT!N\u000b\"I\u0011qGA\tA\u0003%\u0011qD\u0001\u0012\u0011\u0016\u000bE)\u0012*T?.+\u0015l\u0018(B\u001b\u0016\u0003\u0003BCA\u001e\u0003#\u0011\r\u0011\"\u0001\u0002\u001e\u0005)\u0012+V#S3~\u0003\u0016IU!N'~[U)W0O\u00036+\u0005\"CA \u0003#\u0001\u000b\u0011BA\u0010\u0003Y\tV+\u0012*Z?B\u000b%+Q'T?.+\u0015l\u0018(B\u001b\u0016\u0003\u0003BCA\"\u0003#\u0011\r\u0011\"\u0001\u0002\u001e\u0005i\u0001+\u0011+I?.+\u0015l\u0018(B\u001b\u0016C\u0011\"a\u0012\u0002\u0012\u0001\u0006I!a\b\u0002\u001dA\u000bE\u000bS0L\u000bf{f*Q'FA!Q\u00111JA\t\u0005\u0004%\t!!\b\u0002\u001f5+E\u000bS(E?.+\u0015l\u0018(B\u001b\u0016C\u0011\"a\u0014\u0002\u0012\u0001\u0006I!a\b\u0002!5+E\u000bS(E?.+\u0015l\u0018(B\u001b\u0016\u0003\u0003BCA*\u0003#\u0011\r\u0011\"\u0001\u0002\u001e\u0005!2\u000bV!U+N{6i\u0014#F?.+\u0015l\u0018(B\u001b\u0016C\u0011\"a\u0016\u0002\u0012\u0001\u0006I!a\b\u0002+M#\u0016\tV+T?\u000e{E)R0L\u000bf{f*Q'FA!Q\u00111LA\t\u0005\u0004%\t!!\b\u0002\u001bA{%\u000bV0L\u000bf{f*Q'F\u0011%\ty&!\u0005!\u0002\u0013\ty\"\u0001\bQ\u001fJ#vlS#Z?:\u000bU*\u0012\u0011\t\u0015\u0005\r\u0014\u0011\u0003b\u0001\n\u0003\ti\"A\u0007I\u001fN#vlS#Z?:\u000bU*\u0012\u0005\n\u0003O\n\t\u0002)A\u0005\u0003?\ta\u0002S(T)~[U)W0O\u00036+\u0005\u0005\u0003\u0006\u0002l\u0005E!\u0019!C\u0001\u0003;\t1cQ(O)\u0016sEk\u0018+Z!\u0016{\u0006*R!E\u000bJC\u0011\"a\u001c\u0002\u0012\u0001\u0006I!a\b\u0002)\r{e\nV#O)~#\u0016\fU#`\u0011\u0016\u000bE)\u0012*!\u0011)\t\u0019(!\u0005C\u0002\u0013\u0005\u0011QD\u0001\f\u000bR\u000bui\u0018%F\u0003\u0012+%\u000bC\u0005\u0002x\u0005E\u0001\u0015!\u0003\u0002 \u0005aQ\tV!H?\"+\u0015\tR#SA!A\u00111PA\t\t\u0003\ti(A\u0003baBd\u0017\u0010\u0006\u0002\u0002\u0000A\u0019\u0011$!!\n\u0007\u0005\r%D\u0001\bGk:\u001cG/[8oeY\u000bG.^3")
public class HttpServerFunction
implements WeaveFunction2 {
    public static Function2Value apply() {
        return HttpServerFunction$.MODULE$.apply();
    }

    public static String ETAG_HEADER() {
        return HttpServerFunction$.MODULE$.ETAG_HEADER();
    }

    public static String CONTENT_TYPE_HEADER() {
        return HttpServerFunction$.MODULE$.CONTENT_TYPE_HEADER();
    }

    public static String HOST_KEY_NAME() {
        return HttpServerFunction$.MODULE$.HOST_KEY_NAME();
    }

    public static String PORT_KEY_NAME() {
        return HttpServerFunction$.MODULE$.PORT_KEY_NAME();
    }

    public static String STATUS_CODE_KEY_NAME() {
        return HttpServerFunction$.MODULE$.STATUS_CODE_KEY_NAME();
    }

    public static String METHOD_KEY_NAME() {
        return HttpServerFunction$.MODULE$.METHOD_KEY_NAME();
    }

    public static String PATH_KEY_NAME() {
        return HttpServerFunction$.MODULE$.PATH_KEY_NAME();
    }

    public static String QUERY_PARAMS_KEY_NAME() {
        return HttpServerFunction$.MODULE$.QUERY_PARAMS_KEY_NAME();
    }

    public static String HEADERS_KEY_NAME() {
        return HttpServerFunction$.MODULE$.HEADERS_KEY_NAME();
    }

    public static String BODY_KEY_NAME() {
        return HttpServerFunction$.MODULE$.BODY_KEY_NAME();
    }

    public ObjectValue toSeqObjectValue(Seq<Tuple2<String, String>> headers) {
        return ObjectValue$.MODULE$.apply((Seq)headers.map((Function1 & Serializable & scala.Serializable)entry -> new KeyValuePair((Value)KeyValue$.MODULE$.apply((String)entry._1()), (Value)StringValue$.MODULE$.apply((String)entry._2())), Seq$.MODULE$.canBuildFrom()));
    }

    public ObjectValue toRequestObjectValue(HttpRequest request) {
        return ObjectValue$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyValuePair[]{new KeyValuePair((Value)KeyValue$.MODULE$.apply(HttpServerFunction$.MODULE$.BODY_KEY_NAME()), (Value)HttpBodyValue$.MODULE$.apply(request)), new KeyValuePair((Value)KeyValue$.MODULE$.apply(HttpServerFunction$.MODULE$.METHOD_KEY_NAME()), (Value)StringValue$.MODULE$.apply(request.method())), new KeyValuePair((Value)KeyValue$.MODULE$.apply(HttpServerFunction$.MODULE$.PATH_KEY_NAME()), (Value)StringValue$.MODULE$.apply(request.path())), new KeyValuePair((Value)KeyValue$.MODULE$.apply(HttpServerFunction$.MODULE$.QUERY_PARAMS_KEY_NAME()), (Value)this.toSeqObjectValue(request.queryParams())), new KeyValuePair((Value)KeyValue$.MODULE$.apply(HttpServerFunction$.MODULE$.HEADERS_KEY_NAME()), (Value)this.toSeqObjectValue(request.headers()))})));
    }

    public HttpResponse toHttpResponse(Value<?> value, EvaluationContext ctx) {
        ObjectSeq httpResponseObject = (ObjectSeq)ObjectType$.MODULE$.coerce(value, ctx).evaluate(ctx);
        Map headers = (Map)ObjectValueUtils$.MODULE$.selectStringMap(httpResponseObject, HttpServerFunction$.MODULE$.HEADERS_KEY_NAME(), ctx).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
        Option bodyStream = ObjectValueUtils$.MODULE$.select(httpResponseObject, HttpServerFunction$.MODULE$.BODY_KEY_NAME(), ctx).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            InputStream inputStream;
            Value value = x0$1;
            if (value instanceof HttpBodyValue) {
                HttpBodyValue httpBodyValue = (HttpBodyValue)value;
                inputStream = httpBodyValue.httpRequest().body();
            } else if (value.valueType(ctx).isInstanceOf((Type)BinaryType$.MODULE$, ctx)) {
                inputStream = (InputStream)BinaryType$.MODULE$.coerce(value, ctx).evaluate(ctx);
            } else {
                InputStream inputStream2;
                Option option = headers.get((Object)HttpServerFunction$.MODULE$.CONTENT_TYPE_HEADER());
                if (option instanceof Some) {
                    InputStream inputStream3;
                    Some some = (Some)option;
                    String contentType = (String)some.value();
                    Option option2 = DataFormatManager$.MODULE$.byContentType(contentType);
                    if (option2 instanceof Some) {
                        InputStream inputStream4;
                        Some some2 = (Some)option2;
                        DataFormat dataFormat = (DataFormat)some2.value();
                        Writer writer = dataFormat.writer((Option)None$.MODULE$, dataFormat.writer$default$2());
                        ctx.registerCloseable((AutoCloseable)writer);
                        writer.startDocument((LocationCapable)value);
                        writer.writeValue(value, ctx);
                        writer.endDocument((LocationCapable)value);
                        Object object = writer.result();
                        if (object instanceof AutoPersistedOutputStream) {
                            AutoPersistedOutputStream autoPersistedOutputStream = (AutoPersistedOutputStream)object;
                            inputStream4 = (InputStream)autoPersistedOutputStream.getInputStream();
                        } else if (object instanceof Object) {
                            Object object2 = object;
                            inputStream4 = new ByteArrayInputStream(String.valueOf(object2).getBytes());
                        } else {
                            throw new MatchError(object);
                        }
                        inputStream3 = inputStream4;
                    } else if (None$.MODULE$.equals(option2)) {
                        inputStream3 = (InputStream)BinaryType$.MODULE$.coerce(value, ctx).evaluate(ctx);
                    } else {
                        throw new MatchError((Object)option2);
                    }
                    inputStream2 = inputStream3;
                } else if (None$.MODULE$.equals(option)) {
                    inputStream2 = (InputStream)BinaryType$.MODULE$.coerce(value, ctx).evaluate(ctx);
                } else {
                    throw new MatchError((Object)option);
                }
                inputStream = inputStream2;
            }
            return inputStream;
        });
        return new HttpResponse((InputStream)bodyStream.orNull(Predef$.MODULE$.$conforms()), (Map<String, String>)headers, BoxesRunTime.unboxToInt((Object)ObjectValueUtils$.MODULE$.selectInt(httpResponseObject, HttpServerFunction$.MODULE$.STATUS_CODE_KEY_NAME(), ctx).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 200)));
    }

    public Value<?> call(EvaluationContext context, Value<?> value1, Value<?> value2) {
        String host;
        ObjectSeq configObject;
        int port;
        EvaluationContext ctx2 = context;
        Value config = ObjectType$.MODULE$.coerce(value1, ctx2);
        FunctionValue callBack = (FunctionValue)FunctionType$.MODULE$.coerce(value2, ctx2);
        ServiceManager manager = context.serviceManager();
        HttpServerService httpServerService = (HttpServerService)manager.lookupCustomService(HttpServerService.class, (Function0 & Serializable & scala.Serializable)() -> new UndertowHttpServerService());
        HttpServerStatus httpServerStatus = httpServerService.server(new HttpConfig(port = BoxesRunTime.unboxToInt((Object)ObjectValueUtils$.MODULE$.selectInt(configObject = (ObjectSeq)config.materialize(ctx2).evaluate(ctx2), HttpServerFunction$.MODULE$.PORT_KEY_NAME(), ctx2).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 8081)), host = (String)ObjectValueUtils$.MODULE$.selectString(configObject, HttpServerFunction$.MODULE$.HOST_KEY_NAME(), ctx2).getOrElse((Function0 & Serializable & scala.Serializable)() -> "localhost")), (Function1<HttpRequest, HttpResponse>)(Function1 & Serializable & scala.Serializable)request -> {
            ObjectValue requestValue = this.toRequestObjectValue((HttpRequest)request);
            Value callbackResult = callBack.call((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Value[]{requestValue}), ctx2);
            return this.toHttpResponse(callbackResult, ctx2);
        });
        HttpServerStatus httpServerStatus2 = httpServerStatus;
        if (httpServerStatus2 instanceof RunningStatus) {
            RunningStatus runningStatus = (RunningStatus)httpServerStatus2;
            String host2 = runningStatus.host();
            int port2 = runningStatus.port();
            manager.loggingService().logInfo(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Http Server started at ", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{host2, BoxesRunTime.boxToInteger((int)port2)})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (httpServerStatus2 instanceof FailedStatus) {
            FailedStatus failedStatus = (FailedStatus)httpServerStatus2;
            String errorMessage = failedStatus.errorMessage();
            manager.loggingService().logError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to start http server. Reason ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{errorMessage})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)httpServerStatus2);
        }
        Seq resultKeys = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        resultKeys = (Seq)resultKeys.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("running"), (Value)BooleanValue$.MODULE$.apply(httpServerStatus.running(), BooleanValue$.MODULE$.apply$default$2(), BooleanValue$.MODULE$.apply$default$3())), Seq$.MODULE$.canBuildFrom());
        resultKeys = (Seq)resultKeys.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("host"), (Value)StringValue$.MODULE$.apply(host)), Seq$.MODULE$.canBuildFrom());
        resultKeys = (Seq)resultKeys.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("port"), (Value)NumberValue$.MODULE$.apply(Number$.MODULE$.apply(port))), Seq$.MODULE$.canBuildFrom());
        resultKeys = (Seq)resultKeys.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("stop"), (Value)new BridgeFunctionValue((Function2 & Serializable & scala.Serializable)(ctx, args) -> {
            boolean stopped = httpServerStatus.stop();
            if (stopped) {
                manager.loggingService().logInfo(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Stopped server"})).s((Seq)Nil$.MODULE$));
            } else {
                manager.loggingService().logError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while stopping server"})).s((Seq)Nil$.MODULE$));
            }
            return BooleanValue$.MODULE$.apply(stopped, BooleanValue$.MODULE$.apply$default$2(), BooleanValue$.MODULE$.apply$default$3());
        }, BridgeFunctionValue$.MODULE$.$lessinit$greater$default$2())), Seq$.MODULE$.canBuildFrom());
        ctx2.registerCloseable((AutoCloseable)httpServerStatus);
        return ObjectValue$.MODULE$.apply(resultKeys, (LocationCapable)UnknownLocationCapable$.MODULE$);
    }
}

