/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.http.undertow;

import io.undertow.UndertowLogger;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.channels.StreamSinkChannel;

public class ByteWriteChannelListener
implements ChannelListener<StreamSinkChannel> {
    private final ByteBuffer buffer;

    public ByteWriteChannelListener(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public void setup(StreamSinkChannel channel) {
        try {
            int c;
            do {
                c = channel.write(this.buffer);
            } while (this.buffer.hasRemaining() && c > 0);
            if (this.buffer.hasRemaining()) {
                channel.getWriteSetter().set((ChannelListener)this);
                channel.resumeWrites();
            } else {
                this.writeDone(channel);
            }
        }
        catch (IOException e) {
            this.handleError(channel, e);
        }
    }

    protected void handleError(StreamSinkChannel channel, IOException e) {
        UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
        IoUtils.safeClose((Closeable)channel);
    }

    public void handleEvent(StreamSinkChannel channel) {
        try {
            int c;
            do {
                c = channel.write(this.buffer);
            } while (this.buffer.hasRemaining() && c > 0);
            if (this.buffer.hasRemaining()) {
                channel.resumeWrites();
                return;
            }
            this.writeDone(channel);
        }
        catch (IOException e) {
            this.handleError(channel, e);
        }
    }

    public boolean hasRemaining() {
        return this.buffer.hasRemaining();
    }

    protected void writeDone(final StreamSinkChannel channel) {
        try {
            channel.shutdownWrites();
            if (!channel.flush()) {
                channel.getWriteSetter().set(ChannelListeners.flushingChannelListener((ChannelListener)new ChannelListener<StreamSinkChannel>(){

                    public void handleEvent(StreamSinkChannel o) {
                        IoUtils.safeClose((Closeable)channel);
                    }
                }, (ChannelExceptionHandler)ChannelListeners.closingChannelExceptionHandler()));
                channel.resumeWrites();
            }
        }
        catch (IOException e) {
            this.handleError(channel, e);
        }
    }
}

