import dw::http::Types

fun formatHeader(header: String): String =
  lower(header)
    replace /\b([a-z])/
    with upper($[0])


fun normalizeHeaders(headers: Null): {_?: String} =
  {}

fun normalizeHeaders(headers: {_?: String}): {_?: String} =
  headers mapObject {(formatHeader($$)): $}


fun generateBody(config: { body?: Any, headers?: Types::HttpHeaders, writerOptions?: Dictionary<Any> }): {
  body?: Binary,
  headers: Types::HttpHeaders
} =
  using(headers = normalizeHeaders(config.headers))
    if(config.body? == false)
      { headers: headers }
    else
      using(
        contentType = headers['Content-Type'] default (
          config.body match {
            case is Binary -> 'application/octet-stream'
            case is dw::module::Multipart::Multipart -> 'multipart/form-data; boundary=$(config.writerOptions.boundary default dw::module::Multipart::generateBoundary())'
            case is String -> 'text/plain'
            else -> 'application/json'
          }
        ),
        writerOptions = (config.writerOptions default {}) dw::core::Objects::mergeWith {
          (boundary: (contentType scan /boundary=(.*)/)[0][1]) if contentType startsWith 'multipart/form-data'
        },
        body = (config.body match {
                 case is Binary -> config.body
                 else -> write(config.body, contentType, writerOptions)
               }) as Binary
      ) {
          headers:
            dw::core::Objects::mergeWith(headers, {
              'Content-Type': contentType,
              ('Content-Length': sizeOf(body)) if body is Binary
            }),
          body: body
        }

fun safeRead(mime: String, payload: String | Binary, readerOptions: Object): Any =
  mime match {
    case matches /.*\/octet-stream/ -> payload as Binary
    case matches /.*\/x-binary/ -> payload as Binary
    else ->
      dw::Runtime::try(
        () -> read(payload, mime, readerOptions)
      ).result
  }