import dw::core::Objects
import mergeWith from dw::core::Objects
import * from dw::http::Types
import * from dw::http::BodyUtils

fun nativeRequest(req: ClientHttpRequest): HttpResponse =
  native("http::HttpRequestFunction")

type CustomOptions = OptionalHttpRequestOptions & {
  readerOptions?: Object,
  writerOptions?: Object
}

fun request(method: String, url: String, config = {}): HttpResponse =
  using(nativeRequestConfig =
    config
      Objects::mergeWith generateBody(config)
      Objects::mergeWith {
        method: method,
        url: url
      }
  )
  using (result = nativeRequest(nativeRequestConfig as HttpRequest))
  using (responseHeaders = normalizeHeaders(result.response.headers))
    (result
      - 'response')
      ++ {
        response:
          Objects::mergeWith(
            result.response,
            if(responseHeaders.'Content-Type'? and result.response.payload?) (
              using(mime = (responseHeaders.'Content-Type' splitBy ";")[0])
                {
                  body: safeRead(mime, result.response.payload, config.readerOptions default {}),
                  mime: mime,
                  contentType: responseHeaders.'Content-Type'
                }
            ) else {}
          ) as HttpResponseResponse
      }