/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.http.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.mule.weave.v2.io.ByteArraySeekableStream;
import org.mule.weave.v2.module.http.HttpHeader$;
import org.mule.weave.v2.module.http.client.DigestAuth$;
import org.mule.weave.v2.module.http.client.HttpConstants$;
import org.mule.weave.v2.module.http.client.TLSSniSocketFactory;
import org.mule.weave.v2.module.http.client.WwwAuthenticate;
import org.mule.weave.v2.module.http.service.HttpClientOptions;
import org.mule.weave.v2.module.http.service.HttpClientRequest;
import org.mule.weave.v2.module.http.service.HttpClientRequest$;
import org.mule.weave.v2.module.http.service.HttpClientResponse;
import org.mule.weave.v2.module.http.service.HttpClientResult;
import org.mule.weave.v2.module.http.service.HttpClientResult$;
import org.mule.weave.v2.module.http.service.SSLOptions;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.GenSeqLike;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.TreeMap;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015h\u0001B\u0001\u0003\u0001E\u00111\u0002\u0013;uaJ+\u0017/^3ti*\u00111\u0001B\u0001\u0007G2LWM\u001c;\u000b\u0005\u00151\u0011\u0001\u00025uiBT!a\u0002\u0005\u0002\r5|G-\u001e7f\u0015\tI!\"\u0001\u0002we)\u00111\u0002D\u0001\u0006o\u0016\fg/\u001a\u0006\u0003\u001b9\tA!\\;mK*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001%A\u00111CF\u0007\u0002))\tQ#A\u0003tG\u0006d\u0017-\u0003\u0002\u0018)\t1\u0011I\\=SK\u001aD\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006IAG\u0001\b_B$\u0018n\u001c8t!\tYb$D\u0001\u001d\u0015\tiB!A\u0004tKJ4\u0018nY3\n\u0005}a\"!\u0005%uiB\u001cE.[3oi>\u0003H/[8og\")\u0011\u0005\u0001C\u0001E\u00051A(\u001b8jiz\"\"aI\u0013\u0011\u0005\u0011\u0002Q\"\u0001\u0002\t\u000be\u0001\u0003\u0019\u0001\u000e\t\u000f\u001d\u0002\u0001\u0019!C\u0001Q\u00051A/[7feN,\u0012!\u000b\t\u0004UI*dBA\u00161\u001d\tas&D\u0001.\u0015\tq\u0003#\u0001\u0004=e>|GOP\u0005\u0002+%\u0011\u0011\u0007F\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0019DGA\u0002TKFT!!\r\u000b\u0011\tM1\u0004\bQ\u0005\u0003oQ\u0011a\u0001V;qY\u0016\u0014\u0004CA\u001d>\u001d\tQ4\b\u0005\u0002-)%\u0011A\bF\u0001\u0007!J,G-\u001a4\n\u0005yz$AB*ue&twM\u0003\u0002=)A\u0011\u0011IR\u0007\u0002\u0005*\u00111\tR\u0001\u0005Y\u0006twMC\u0001F\u0003\u0011Q\u0017M^1\n\u0005\u001d\u0013%A\u0002(v[\n,'\u000fC\u0004J\u0001\u0001\u0007I\u0011\u0001&\u0002\u0015QLW.\u001a:t?\u0012*\u0017\u000f\u0006\u0002L\u001dB\u00111\u0003T\u0005\u0003\u001bR\u0011A!\u00168ji\"9q\nSA\u0001\u0002\u0004I\u0013a\u0001=%c!1\u0011\u000b\u0001Q!\n%\nq\u0001^5nKJ\u001c\b\u0005C\u0004T\u0001\u0001\u0007I\u0011\u0001+\u0002\u0015M$\u0018M\u001d;US6,'/F\u0001V!\t\u0019b+\u0003\u0002X)\t!Aj\u001c8h\u0011\u001dI\u0006\u00011A\u0005\u0002i\u000bab\u001d;beR$\u0016.\\3s?\u0012*\u0017\u000f\u0006\u0002L7\"9q\nWA\u0001\u0002\u0004)\u0006BB/\u0001A\u0003&Q+A\u0006ti\u0006\u0014H\u000fV5nKJ\u0004\u0003bB0\u0001\u0001\u0004%\t\u0001V\u0001\u0010G\",7m\u001b9pS:$H+[7fe\"9\u0011\r\u0001a\u0001\n\u0003\u0011\u0017aE2iK\u000e\\\u0007o\\5oiRKW.\u001a:`I\u0015\fHCA&d\u0011\u001dy\u0005-!AA\u0002UCa!\u001a\u0001!B\u0013)\u0016\u0001E2iK\u000e\\\u0007o\\5oiRKW.\u001a:!\u0011\u00159\u0007\u0001\"\u0001i\u00035\u0011XmZ5ti\u0016\u0014H+[7feR\u00111*\u001b\u0005\u0006U\u001a\u0004\r\u0001O\u0001\u0005]\u0006lW\rC\u0003m\u0001\u0011%Q.\u0001\u0006ve2\u0014U/\u001b7eKJ$\"A\u001c;\u0011\u0005=\u0014X\"\u00019\u000b\u0005E$\u0015a\u00018fi&\u00111\u000f\u001d\u0002\u0004+Jc\u0005\"B;l\u0001\u0004Q\u0012a\u0001:fc\")q\u000f\u0001C\u0005q\u0006Y1m\u001c8oK\u000e$h)\u001e8d)\rY\u0015P\u001f\u0005\u0006kZ\u0004\rA\u0007\u0005\u0006wZ\u0004\r\u0001`\u0001\u0005G>tg\u000e\u0005\u0002p{&\u0011a\u0010\u001d\u0002\u0012\u0011R$\b/\u0016*M\u0007>tg.Z2uS>t\u0007bBA\u0001\u0001\u0011\u0005\u00111A\u0001\u000bO\u0016$XK\u0015'GS2,Gc\u0001\u001d\u0002\u0006!1\u0011qA@A\u00029\f1!\u001e:m\u0011\u001d\tY\u0001\u0001C\u0001\u0003\u001b\tA\u0002Z8D_:tWm\u0019;j_:$B!a\u0004\u0002\u0016A\u00191$!\u0005\n\u0007\u0005MAD\u0001\tIiR\u00048\t\\5f]R\u0014Vm];mi\"Q\u0011qCA\u0005!\u0003\u0005\r!!\u0007\u0002\u0015U\u0014H\u000eV8GKR\u001c\u0007\u000e\u0005\u0003\u0014\u00037q\u0017bAA\u000f)\t1q\n\u001d;j_:Dq!!\t\u0001\t\u0013\t\u0019#\u0001\u0006u_J+7\u000f]8og\u0016$b!!\n\u0002,\u00055\u0002cA\u000e\u0002(%\u0019\u0011\u0011\u0006\u000f\u0003%!#H\u000f]\"mS\u0016tGOU3ta>t7/\u001a\u0005\u0007w\u0006}\u0001\u0019\u0001?\t\u0011\u0005=\u0012q\u0004a\u0001\u0003c\t1\"\u001b8qkR\u001cFO]3b[B!\u00111GA\u001d\u001b\t\t)DC\u0002\u00028\u0011\u000b!![8\n\t\u0005m\u0012Q\u0007\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW\u000eC\u0004\u0002@\u0001!I!!\u0011\u0002%\u001d,GOU3ta>t7/\u001a%fC\u0012,'o\u001d\u000b\u0005\u0003\u0007\ny\u0005\u0005\u0004:\u0003\u000bB\u0014\u0011J\u0005\u0004\u0003\u000fz$aA'baB!!&a\u00139\u0013\r\ti\u0005\u000e\u0002\u000b\u0013:$W\r_3e'\u0016\f\bBB>\u0002>\u0001\u0007A\u0010C\u0004\u0002T\u0001!I!!\u0016\u0002\u001b\u001d,Go\u0015;biV\u001cH+\u001a=u)\u0011\t9&!\u0017\u0011\tM\tY\u0002\u000f\u0005\u0007w\u0006E\u0003\u0019\u0001?\t\u0013\u0005u\u0003A1A\u0005\u0002\u0005}\u0013AE8gM&\u001c\u0017\r\u001c%uiBlU\r\u001e5pIN,\"!!\u0019\u0011\r\u0005\r\u0014QNA9\u001b\t\t)G\u0003\u0003\u0002h\u0005%\u0014!C5n[V$\u0018M\u00197f\u0015\r\tY\u0007F\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA8\u0003K\u00121aU3u!\r\t\u00151O\u0005\u0003}\tC\u0001\"a\u001e\u0001A\u0003%\u0011\u0011M\u0001\u0014_\u001a4\u0017nY1m\u0011R$\b/T3uQ>$7\u000f\t\u0005\u000b\u0003w\u0002\u0001R1A\u0005\n\u0005u\u0014aC7fi\"|GMR5fY\u0012,\"!a \u0011\t\u0005\u0005\u0015qQ\u0007\u0003\u0003\u0007S1!!\"C\u0003\u001d\u0011XM\u001a7fGRLA!!#\u0002\u0004\n)a)[3mI\"9\u0011Q\u0012\u0001\u0005\u0002\u0005=\u0015AB7fi\"|G\rF\u0003L\u0003#\u000b)\nC\u0004\u0002\u0014\u0006-\u0005\u0019\u0001\u001d\u0002\u00155,G\u000f[8e\u001fJLw\rC\u0004\u0002\u0018\u0006-\u0005\u0019\u0001?\u0002\u0003\rDq!a'\u0001\t\u0003\ti*\u0001\u0007d_:4\u0017nZ;sKN\u001bF\nF\u0003L\u0003?\u000b\t\u000bC\u0004\u0002\u0018\u0006e\u0005\u0019\u0001?\t\u0011\u0005\r\u0016\u0011\u0014a\u0001\u0003K\u000b1a]:m!\rY\u0012qU\u0005\u0004\u0003Sc\"AC*T\u0019>\u0003H/[8og\"9\u0011Q\u0016\u0001\u0005\u0002\u0005=\u0016AD1mY><XK\\:bM\u0016\u001c6\u000b\u0014\u000b\u0005\u0003c\u000b\t\r\u0005\u0003\u00024\u0006uVBAA[\u0015\u0011\t\u0019+a.\u000b\u0007E\fIL\u0003\u0002\u0002<\u0006)!.\u0019<bq&!\u0011qXA[\u0005A\u00196\u000bT*pG.,GOR1di>\u0014\u0018\u0010\u0003\u0005\u0002D\u0006-\u0006\u0019AAc\u0003%AG\u000f\u001e9t\u0007>tg\u000e\u0005\u0003\u00024\u0006\u001d\u0017\u0002BAe\u0003k\u0013!\u0003\u0013;uaN,&\u000bT\"p]:,7\r^5p]\"I\u0011Q\u001a\u0001\u0012\u0002\u0013\u0005\u0011qZ\u0001\u0017I>\u001cuN\u001c8fGRLwN\u001c\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u001b\u0016\u0005\u00033\t\u0019n\u000b\u0002\u0002VB!\u0011q[Aq\u001b\t\tIN\u0003\u0003\u0002\\\u0006u\u0017!C;oG\",7m[3e\u0015\r\ty\u000eF\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAr\u00033\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class HttpRequest {
    private Field methodField;
    private final HttpClientOptions options;
    private Seq<Tuple2<String, Number>> timers;
    private long startTimer;
    private long checkpointTimer;
    private final Set<String> officalHttpMethods;
    private volatile boolean bitmap$0;

    public Seq<Tuple2<String, Number>> timers() {
        return this.timers;
    }

    public void timers_$eq(Seq<Tuple2<String, Number>> x$1) {
        this.timers = x$1;
    }

    public long startTimer() {
        return this.startTimer;
    }

    public void startTimer_$eq(long x$1) {
        this.startTimer = x$1;
    }

    public long checkpointTimer() {
        return this.checkpointTimer;
    }

    public void checkpointTimer_$eq(long x$1) {
        this.checkpointTimer = x$1;
    }

    public void registerTimer(String name) {
        long now = System.nanoTime();
        Double time = Predef$.MODULE$.double2Double((double)(now - this.checkpointTimer()) / 1000000.0);
        this.checkpointTimer_$eq(now);
        this.timers_$eq((Seq<Tuple2<String, Number>>)((Seq)this.timers().$colon$plus((Object)new Tuple2((Object)name, (Object)time), Seq$.MODULE$.canBuildFrom())));
    }

    private URL urlBuilder(HttpClientOptions req) {
        return new URI(req.url()).toURL();
    }

    private void connectFunc(HttpClientOptions req, HttpURLConnection conn) {
        if (req.body().isDefined() && req.body().get() != null) {
            conn.setDoOutput(true);
            conn.connect();
            this.registerTimer("connect");
            InputStream in = (InputStream)req.body().get();
            OutputStream out = conn.getOutputStream();
            byte[] ba = new byte[4096];
            this.readOnce$1(in, out, ba);
        } else {
            conn.connect();
            this.registerTimer("connect");
        }
        this.registerTimer("send");
    }

    public String getURLFile(URL url) {
        String urlPath = url.getFile();
        if (urlPath != null && urlPath.length() != 0) {
            if (urlPath.charAt(0) == '?') {
                urlPath = "/" + urlPath;
            }
        } else {
            urlPath = "/";
        }
        if (urlPath.indexOf(10) != -1) {
            throw new MalformedURLException("Illegal character in URL");
        }
        return urlPath;
    }

    public HttpClientResult doConnection(Option<URL> urlToFetch) {
        HttpClientResult result = new HttpClientResult(false, this.options, HttpClientResult$.MODULE$.apply$default$3(), HttpClientResult$.MODULE$.apply$default$4(), HttpClientResult$.MODULE$.apply$default$5(), HttpClientResult$.MODULE$.apply$default$6(), HttpClientResult$.MODULE$.apply$default$7());
        ObjectRef targetUrl = ObjectRef.create(null);
        try {
            BoxedUnit boxedUnit;
            try {
                Try try_;
                targetUrl.elem = (URL)urlToFetch.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.urlBuilder($this.options));
                InetAddress address = InetAddress.getByName(((URL)targetUrl.elem).getHost());
                this.registerTimer("dns");
                URLConnection uRLConnection = (URLConnection)this.options.proxyConfig().map((Function1 & Serializable & scala.Serializable)x -> ((URL)targetUrl$1.elem).openConnection((Proxy)x)).getOrElse((Function0 & Serializable & scala.Serializable)() -> ((URL)targetUrl$1.elem).openConnection());
                if (uRLConnection instanceof HttpURLConnection) {
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    this.method(this.options.method(), httpURLConnection);
                    httpURLConnection.setUseCaches(false);
                    httpURLConnection.setDefaultUseCaches(false);
                    HttpClientRequest req = new HttpClientRequest(httpURLConnection.getRequestMethod(), ((URL)targetUrl.elem).toString(), this.getURLFile((URL)targetUrl.elem), HttpClientRequest$.MODULE$.apply$default$4(), HttpClientRequest$.MODULE$.apply$default$5(), HttpClientRequest$.MODULE$.apply$default$6(), HttpClientRequest$.MODULE$.apply$default$7(), HttpClientRequest$.MODULE$.apply$default$8());
                    result.request_$eq((Option<HttpClientRequest>)new Some((Object)req));
                    boolean isSSL = ((URL)targetUrl.elem).toString().startsWith("https:");
                    req.port_$eq(((URL)targetUrl.elem).getPort() == -1 ? (isSSL ? 443 : 80) : ((URL)targetUrl.elem).getPort());
                    InetSocketAddress inetAddress = new InetSocketAddress(address, req.port());
                    req.ip_$eq(inetAddress.getAddress().getHostAddress());
                    this.options.headers().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        HttpRequest.$anonfun$doConnection$4(httpURLConnection, x0$1);
                        return BoxedUnit.UNIT;
                    });
                    if (!this.options.headers().contains((Object)HttpHeader$.MODULE$.ACCEPT_ENCODING_HEADER()) && this.options.allowCompression()) {
                        httpURLConnection.setRequestProperty(HttpHeader$.MODULE$.ACCEPT_ENCODING_HEADER(), "gzip,deflate");
                    }
                    String hostHeader = ((URL)targetUrl.elem).getHost();
                    if (!this.options.headers().contains((Object)HttpHeader$.MODULE$.HOST_HEADER())) {
                        hostHeader = ((URL)targetUrl.elem).getHost();
                        if (req.port() != 80) {
                            hostHeader = hostHeader + ":" + req.port();
                        }
                        httpURLConnection.setRequestProperty(HttpHeader$.MODULE$.HOST_HEADER(), hostHeader);
                    }
                    if (!this.options.headers().contains((Object)HttpHeader$.MODULE$.CONNECTION_HEADER())) {
                        httpURLConnection.setRequestProperty(HttpHeader$.MODULE$.CONNECTION_HEADER(), "close");
                    }
                    if (!this.options.headers().contains((Object)HttpHeader$.MODULE$.USER_AGENT_HEADER())) {
                        httpURLConnection.setRequestProperty(HttpHeader$.MODULE$.USER_AGENT_HEADER(), "DataWeave/2.0");
                    }
                    if (!this.options.headers().contains((Object)HttpHeader$.MODULE$.ACCEPT_HEADER())) {
                        httpURLConnection.setRequestProperty(HttpHeader$.MODULE$.ACCEPT_HEADER(), "text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2");
                    }
                    this.configureSSL(httpURLConnection, this.options.ssl());
                    httpURLConnection.setConnectTimeout(this.options.connectionTimeout().intValue());
                    httpURLConnection.setReadTimeout(this.options.readTimeout().intValue());
                    httpURLConnection.setInstanceFollowRedirects(false);
                    Map<String, List<String>> properties = httpURLConnection.getRequestProperties();
                    scala.collection.mutable.Map mutableHeaders = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                    properties.forEach((name, values) -> {
                        if (values == null || values.size() == 0 || values.size() == 1 && values.get(0) == null) {
                            req.path_$eq(name.substring(httpURLConnection.getRequestMethod().length() + 1, name.length() - 9));
                            req.httpVersion_$eq(name.substring(name.length() - 8));
                        } else {
                            ObjectRef newValue = ObjectRef.create((Object)((Seq)mutableHeaders.getOrElse(name, (Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$))));
                            values.forEach(value -> {
                                newValue$1.elem = (Seq)((Seq)newValue$1.elem).$colon$plus(value, Seq$.MODULE$.canBuildFrom());
                            });
                            mutableHeaders.update(name, (Object)((Seq)newValue.elem));
                        }
                    });
                    if (!mutableHeaders.contains((Object)HttpHeader$.MODULE$.HOST_HEADER())) {
                        Seq newValue = (Seq)mutableHeaders.getOrElse((Object)HttpHeader$.MODULE$.HOST_HEADER(), (Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                        newValue = (Seq)newValue.$colon$plus((Object)hostHeader, Seq$.MODULE$.canBuildFrom());
                        mutableHeaders.update((Object)HttpHeader$.MODULE$.HOST_HEADER(), (Object)newValue);
                    }
                    this.options.headers().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        HttpRequest.$anonfun$doConnection$10(mutableHeaders, x0$2);
                        return BoxedUnit.UNIT;
                    });
                    req.headers_$eq((scala.collection.immutable.Map<String, Seq<String>>)mutableHeaders.toMap(Predef$.MODULE$.$conforms()));
                    req.payload_$eq(this.options.body());
                    try {
                        this.connectFunc(this.options, httpURLConnection);
                        result.response_$eq((Option<HttpClientResponse>)new Some((Object)this.toResponse(httpURLConnection, httpURLConnection.getInputStream())));
                        try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> httpURLConnection.disconnect());
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (!(throwable2 instanceof IOException) || httpURLConnection.getResponseCode() <= 0) {
                            throw throwable;
                        }
                        result.response_$eq((Option<HttpClientResponse>)new Some((Object)this.toResponse(httpURLConnection, httpURLConnection.getErrorStream())));
                        Try try_2 = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> httpURLConnection.disconnect());
                        try_ = try_2;
                    }
                } else {
                    throw new MatchError((Object)uRLConnection);
                }
                Try try_3 = try_;
                boxedUnit = try_3;
            }
            catch (ConnectException e) {
                result.err_$eq(true);
                result.message_$eq((Option<String>)new Some((Object)"Connection refused"));
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (URISyntaxException e) {
                result.err_$eq(true);
                result.message_$eq((Option<String>)new Some((Object)("Invalid URI, " + e.getMessage())));
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (UnknownHostException e) {
                result.err_$eq(true);
                if (e.getMessage().contains(((URL)targetUrl.elem).getHost())) {
                    result.message_$eq((Option<String>)new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot resolve host: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((URL)targetUrl.elem).getHost()}))));
                } else {
                    result.message_$eq((Option<String>)new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot resolve host: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.getMessage()}))));
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (SSLHandshakeException e) {
                result.err_$eq(true);
                result.message_$eq((Option<String>)new Some((Object)e.getMessage()));
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (SocketTimeoutException e) {
                result.err_$eq(true);
                result.message_$eq((Option<String>)new Some((Object)e.getMessage()));
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable e) {
                result.err_$eq(true);
                result.message_$eq((Option<String>)new Some((Object)e.toString()));
                boxedUnit = BoxedUnit.UNIT;
            }
        }
        finally {
            long now = System.nanoTime();
            Double time = Predef$.MODULE$.double2Double((double)(now - this.startTimer()) / 1000000.0);
            this.timers_$eq((Seq<Tuple2<String, Number>>)((Seq)this.timers().$colon$plus((Object)new Tuple2((Object)"total", (Object)time), Seq$.MODULE$.canBuildFrom())));
            result.timers_$eq((Option<scala.collection.immutable.Map<String, Number>>)new Some((Object)this.timers().toMap(Predef$.MODULE$.$conforms())));
        }
        return result;
    }

    public Option<URL> doConnection$default$1() {
        return None$.MODULE$;
    }

    private HttpClientResponse toResponse(HttpURLConnection conn, InputStream inputStream) {
        int responseCode = conn.getResponseCode();
        this.registerTimer("wait");
        scala.collection.immutable.Map<String, IndexedSeq<String>> headers = this.getResponseHeaders(conn);
        Option<String> statusText = this.getStatusText(conn);
        Option encoding = headers.get((Object)"Content-Encoding").flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.headOption());
        String AuthHeaderName = "Authorization";
        None$ redirection = responseCode == 401 && !this.options.headers().exists((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)HttpRequest.$anonfun$toResponse$2(AuthHeaderName, p))) ? this.options.digestCreds().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)HttpRequest.$anonfun$toResponse$5(check$ifrefutable$1))).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> {
            Tuple2 tuple2 = x$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String username = (String)tuple2._1();
            String password = (String)tuple2._2();
            Option option = headers.get((Object)"WWW-Authenticate").flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.headOption()).flatMap((Function1 & Serializable & scala.Serializable)headerValue -> DigestAuth$.MODULE$.getAuthDetails((String)headerValue)).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)HttpRequest.$anonfun$toResponse$9(check$ifrefutable$2))).withFilter((Function1 & Serializable & scala.Serializable)authParams -> BoxesRunTime.boxToBoolean((boolean)HttpRequest.$anonfun$toResponse$10(authParams))).map((Function1 & Serializable & scala.Serializable)authParams -> {
                URL url = this.urlBuilder($this.options);
                return new Tuple2(authParams, (Object)url);
            }).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> {
                URL url;
                WwwAuthenticate authParams;
                block3: {
                    Tuple2 tuple2;
                    block2: {
                        tuple2 = x$3;
                        if (tuple2 == null) break block2;
                        authParams = (WwwAuthenticate)tuple2._1();
                        url = (URL)tuple2._2();
                        if (authParams != null) break block3;
                    }
                    throw new MatchError((Object)tuple2);
                }
                WwwAuthenticate wwwAuthenticate = authParams;
                Option option = DigestAuth$.MODULE$.createHeaderValue(username, password, $this.options.method(), HttpRequest.toUri$1(url), HttpConstants$.MODULE$.readBytes(inputStream), wwwAuthenticate.params(), DigestAuth$.MODULE$.createHeaderValue$default$7()).map((Function1 & Serializable & scala.Serializable)digestResult -> {
                    HttpClientOptions newOptions = $this.options.copy(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)headers), digestResult), $this.options.copy$default$2(), $this.options.copy$default$3(), $this.options.copy$default$4(), $this.options.copy$default$5(), $this.options.copy$default$6(), $this.options.copy$default$7(), $this.options.copy$default$8(), $this.options.copy$default$9(), $this.options.copy$default$10(), $this.options.copy$default$11());
                    HttpRequest httpResponse = new HttpRequest(newOptions);
                    return (HttpClientResponse)httpResponse.doConnection((Option<URL>)new Some((Object)url)).response().get();
                });
                return option;
            });
            return option;
        }) : None$.MODULE$;
        return (HttpClientResponse)redirection.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            None$ redirectedResult = conn.getInstanceFollowRedirects() && (responseCode == 301 || responseCode == 302) ? headers.get((Object)"Location").flatMap((Function1 & Serializable & scala.Serializable)x$5 -> x$5.headOption()).map((Function1 & Serializable & scala.Serializable)location -> (HttpClientResponse)this.doConnection((Option<URL>)new Some((Object)new URL((String)location))).response().get()) : None$.MODULE$;
            return (HttpClientResponse)redirectedResult.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                HttpClientResponse httpClientResponse;
                InputStream theStream;
                boolean shouldDecompress;
                boolean bl = shouldDecompress = $this.options.allowCompression() && inputStream != null;
                InputStream inputStream = shouldDecompress && encoding.exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.equalsIgnoreCase("gzip"))) ? new GZIPInputStream(inputStream) : (theStream = shouldDecompress && encoding.exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.equalsIgnoreCase("deflate"))) ? new InflaterInputStream(inputStream) : inputStream);
                if (theStream != null) {
                    byte[] bytes = HttpConstants$.MODULE$.readBytes(theStream);
                    this.registerTimer("receive");
                    theStream.close();
                    ByteArraySeekableStream stream = new ByteArraySeekableStream(bytes);
                    httpClientResponse = new HttpClientResponse(Predef$.MODULE$.int2Integer(responseCode), (scala.collection.immutable.Map<String, Seq<String>>)headers, (Option<InputStream>)new Some((Object)stream), statusText);
                } else {
                    this.registerTimer("receive");
                    httpClientResponse = new HttpClientResponse(Predef$.MODULE$.int2Integer(responseCode), (scala.collection.immutable.Map<String, Seq<String>>)headers, (Option<InputStream>)None$.MODULE$, statusText);
                }
                return httpClientResponse;
            });
        });
    }

    private scala.collection.immutable.Map<String, IndexedSeq<String>> getResponseHeaders(HttpURLConnection conn) {
        return new TreeMap(package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$8 -> x$8.toLowerCase(), (Ordering)Ordering.String$.MODULE$)).$plus$plus((GenTraversableOnce)((TraversableLike)((TraversableLike)((Stream)package$.MODULE$.Stream().from(0).map((Function1 & Serializable & scala.Serializable)i -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))), (Object)conn.getHeaderField(BoxesRunTime.unboxToInt((Object)i))), Stream$.MODULE$.canBuildFrom())).takeWhile((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)HttpRequest.$anonfun$getResponseHeaders$3(x$9))).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int i = tuple2._1$mcI$sp();
            String value = (String)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Option$.MODULE$.apply((Object)conn.getHeaderFieldKey(i)).getOrElse((Function0 & Serializable & scala.Serializable)() -> "-\n")), (Object)value);
            return tuple22;
        }, Stream$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)HttpRequest.$anonfun$getResponseHeaders$6(x)))).groupBy((Function1 & Serializable & scala.Serializable)x$10 -> (String)x$10._1()).mapValues((Function1 & Serializable & scala.Serializable)x$11 -> ((TraversableOnce)x$11.map((Function1 & Serializable & scala.Serializable)x$12 -> (String)x$12._2(), Stream$.MODULE$.canBuildFrom())).toIndexedSeq()));
    }

    private Option<String> getStatusText(HttpURLConnection conn) {
        return ((LinearSeqOptimized)((Stream)package$.MODULE$.Stream().from(0).map((Function1 & Serializable & scala.Serializable)i -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))), (Object)conn.getHeaderField(BoxesRunTime.unboxToInt((Object)i))), Stream$.MODULE$.canBuildFrom())).takeWhile((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)HttpRequest.$anonfun$getStatusText$2(x$13))).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int i = tuple2._1$mcI$sp();
            String value = (String)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Option$.MODULE$.apply((Object)conn.getHeaderFieldKey(i)).getOrElse((Function0 & Serializable & scala.Serializable)() -> "-\n")), (Object)value);
            return tuple22;
        }, Stream$.MODULE$.canBuildFrom())).find((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)HttpRequest.$anonfun$getStatusText$5(x))).map((Function1 & Serializable & scala.Serializable)x -> (String)x._2());
    }

    public Set<String> officalHttpMethods() {
        return this.officalHttpMethods;
    }

    /*
     * WARNING - void declaration
     */
    private Field methodField$lzycompute() {
        HttpRequest httpRequest = this;
        synchronized (httpRequest) {
            if (!this.bitmap$0) {
                void var2_2;
                Field m = HttpURLConnection.class.getDeclaredField("method");
                m.setAccessible(true);
                this.methodField = var2_2;
                this.bitmap$0 = true;
            }
        }
        return this.methodField;
    }

    private Field methodField() {
        return !this.bitmap$0 ? this.methodField$lzycompute() : this.methodField;
    }

    public void method(String methodOrig, HttpURLConnection c) {
        String method = methodOrig.toUpperCase();
        if (this.officalHttpMethods().contains((Object)method)) {
            c.setRequestMethod(method);
        } else {
            HttpURLConnection httpURLConnection = c;
            if (httpURLConnection instanceof HttpsURLConnection) {
                HttpsURLConnection httpsURLConnection = (HttpsURLConnection)httpURLConnection;
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])httpsURLConnection.getClass().getDeclaredFields())).find((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)HttpRequest.$anonfun$method$1(x$14))).foreach((Function1 & Serializable & scala.Serializable)del -> {
                    HttpRequest.$anonfun$method$2(this, method, httpsURLConnection, del);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                this.methodField().set(httpURLConnection, method);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public void configureSSL(HttpURLConnection c, SSLOptions ssl) {
        HttpURLConnection httpURLConnection = c;
        if (httpURLConnection instanceof HttpsURLConnection) {
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)httpURLConnection;
            SSLSocketFactory sslFactory = ssl.allowSelfSignedCertificate() ? this.allowUnsafeSSL(httpsURLConnection) : (SSLSocketFactory)SSLSocketFactory.getDefault();
            httpsURLConnection.setSSLSocketFactory(new TLSSniSocketFactory(this, sslFactory){
                private final /* synthetic */ HttpRequest $outer;

                public void handshakeCompleted(HandshakeCompletedEvent a) {
                    this.$outer.registerTimer("ssl");
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    super(sslFactory$1);
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public SSLSocketFactory allowUnsafeSSL(HttpsURLConnection httpsConn) {
        HostnameVerifier hv = new HostnameVerifier(null){

            public boolean verify(String urlHostName, SSLSession session) {
                return true;
            }
        };
        httpsConn.setHostnameVerifier(hv);
        TrustManager[] trustAllCerts = (TrustManager[])((Object[])new TrustManager[]{new X509TrustManager(null){

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }});
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        return sc.getSocketFactory();
    }

    private final void readOnce$1(InputStream in$1, OutputStream out$1, byte[] ba$1) {
        int len;
        do {
            if ((len = in$1.read(ba$1)) <= 0) continue;
            out$1.write(ba$1, 0, len);
        } while (len >= 0);
    }

    public static final /* synthetic */ void $anonfun$doConnection$4(HttpURLConnection x2$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String name = (String)tuple2._1();
        Seq values = (Seq)tuple2._2();
        values.foreach((Function1 & Serializable & scala.Serializable)value -> {
            x2$1.setRequestProperty(name, value);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$doConnection$10(scala.collection.mutable.Map mutableHeaders$1, Tuple2 x0$2) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String name = (String)tuple2._1();
            Seq values = (Seq)tuple2._2();
            if (!mutableHeaders$1.contains((Object)name)) {
                Seq newValue = (Seq)mutableHeaders$1.getOrElse((Object)name, (Function0 & Serializable & scala.Serializable)() -> values);
                mutableHeaders$1.update((Object)name, (Object)newValue);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$toResponse$2(String AuthHeaderName$1, Tuple2 p) {
        Object object = p._1();
        String string = AuthHeaderName$1;
        return !(object != null ? !object.equals(string) : string != null) && ((GenSeqLike)p._2()).startsWith((GenSeq)Predef$.MODULE$.wrapString(DigestAuth$.MODULE$.DigestPrefix()));
    }

    private static final String toUri$1(URL url) {
        return url.getPath() + Option$.MODULE$.apply((Object)url.getQuery()).map((Function1 & Serializable & scala.Serializable)q -> "?" + q).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
    }

    public static final /* synthetic */ boolean $anonfun$toResponse$5(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$toResponse$9(WwwAuthenticate check$ifrefutable$2) {
        WwwAuthenticate wwwAuthenticate = check$ifrefutable$2;
        boolean bl = wwwAuthenticate != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$toResponse$10(WwwAuthenticate authParams) {
        return authParams.authType().equalsIgnoreCase(DigestAuth$.MODULE$.DigestPrefix());
    }

    public static final /* synthetic */ boolean $anonfun$getResponseHeaders$3(Tuple2 x$9) {
        return x$9._2() != null;
    }

    public static final /* synthetic */ boolean $anonfun$getResponseHeaders$6(Tuple2 x) {
        Object object = x._1();
        String string = "-\n";
        return object == null ? string != null : !object.equals(string);
    }

    public static final /* synthetic */ boolean $anonfun$getStatusText$2(Tuple2 x$13) {
        return x$13._2() != null;
    }

    public static final /* synthetic */ boolean $anonfun$getStatusText$5(Tuple2 x) {
        Object object = x._1();
        String string = "-\n";
        return !(object != null ? !object.equals(string) : string != null);
    }

    public static final /* synthetic */ boolean $anonfun$method$1(Field x$14) {
        String string = x$14.getName();
        String string2 = "delegate";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$method$2(HttpRequest $this, String method$1, HttpsURLConnection x2$2, Field del) {
        del.setAccessible(true);
        $this.methodField().set(del.get(x2$2), method$1);
    }

    public HttpRequest(HttpClientOptions options) {
        this.options = options;
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
        this.timers = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.startTimer = System.nanoTime();
        this.checkpointTimer = this.startTimer();
        this.officalHttpMethods = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GET", "POST", "HEAD", "OPTIONS", "PUT", "DELETE", "TRACE"}));
    }
}

