/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.http.client;

import com.sun.org.apache.xml.internal.security.utils.Base64;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URLDecoder;
import java.net.URLEncoder;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class HttpConstants$ {
    public static HttpConstants$ MODULE$;
    private final Regex CharsetRegex;
    private final Function2<HttpURLConnection, Object, BoxedUnit> setFixedLengthStreamingMode;
    private final String utf8;

    static {
        new HttpConstants$();
    }

    public Regex CharsetRegex() {
        return this.CharsetRegex;
    }

    public Function2<HttpURLConnection, Object, BoxedUnit> setFixedLengthStreamingMode() {
        return this.setFixedLengthStreamingMode;
    }

    public String urlEncode(String name, String charset) {
        return URLEncoder.encode(name, charset);
    }

    public String urlDecode(String name, String charset) {
        return URLDecoder.decode(name, charset);
    }

    public String base64(byte[] bytes) {
        return new String(Base64.encode(bytes));
    }

    public String base64(String in) {
        return this.base64(in.getBytes(this.utf8()));
    }

    public String basicAuthValue(String user, String password) {
        return new StringBuilder(6).append("Basic ").append(this.base64(new StringBuilder(1).append(user).append(":").append(password).toString())).toString();
    }

    public String toQs(Seq<Tuple2<String, String>> params, String charset) {
        return ((TraversableOnce)params.map((Function1 & Serializable & scala.Serializable)p -> new StringBuilder(1).append(MODULE$.urlEncode((String)p._1(), charset)).append("=").append(MODULE$.urlEncode((String)p._2(), charset)).toString(), Seq$.MODULE$.canBuildFrom())).mkString("&");
    }

    public String appendQs(String url, Seq<Tuple2<String, String>> params, String charset) {
        return new StringBuilder(0).append(url).append((Object)(params.isEmpty() ? "" : new StringBuilder(0).append(url.contains("?") ? "&" : "?").append(this.toQs(params, charset)).toString())).toString();
    }

    public String normalizeParams(Seq<Tuple2<String, String>> params) {
        return ((TraversableOnce)this.percentEncode(params).sortWith((Function2 & Serializable & scala.Serializable)(x$16, x$17) -> BoxesRunTime.boxToBoolean((boolean)HttpConstants$.$anonfun$normalizeParams$1(x$16, x$17)))).mkString("&");
    }

    public Seq<String> percentEncode(Seq<Tuple2<String, String>> params) {
        return (Seq)params.map((Function1 & Serializable & scala.Serializable)p -> new StringBuilder(1).append(MODULE$.percentEncode((String)p._1())).append("=").append(MODULE$.percentEncode((String)p._2())).toString(), Seq$.MODULE$.canBuildFrom());
    }

    public String percentEncode(String s) {
        return s == null ? "" : this.urlEncode(s, this.utf8()).replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
    }

    public byte[] readBytes(InputStream in) {
        byte[] byArray;
        if (in == null) {
            byArray = (byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte());
        } else {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] ba = new byte[4096];
            this.readOnce$2(in, bos, ba);
            byArray = bos.toByteArray();
        }
        return byArray;
    }

    public Proxy proxy(String host, int port, Proxy.Type proxyType) {
        return new Proxy(proxyType, new InetSocketAddress(host, port));
    }

    public Proxy.Type proxy$default$3() {
        return Proxy.Type.HTTP;
    }

    public String utf8() {
        return this.utf8;
    }

    private static final Tuple2 liftedTree1$1(Class connClass$1) {
        Tuple2 tuple2;
        try {
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToBoolean((boolean)true)), (Object)connClass$1.getDeclaredMethod("setFixedLengthStreamingMode", Long.TYPE));
        }
        catch (NoSuchMethodException e) {
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToBoolean((boolean)false)), (Object)connClass$1.getDeclaredMethod("setFixedLengthStreamingMode", Integer.TYPE));
        }
        return tuple2;
    }

    public static final /* synthetic */ void $anonfun$setFixedLengthStreamingMode$1(boolean isLong$1, Method theMethod$1, HttpURLConnection conn, long length) {
        if (isLong$1) {
            theMethod$1.invoke((Object)conn, Predef$.MODULE$.long2Long(length));
        } else {
            if (length > Integer.MAX_VALUE) {
                throw new RuntimeException("Failing attempt to upload file greater than 2GB on java version < 1.7");
            }
            theMethod$1.invoke((Object)conn, Predef$.MODULE$.int2Integer((int)length));
        }
    }

    public static final /* synthetic */ boolean $anonfun$normalizeParams$1(String x$16, String x$17) {
        return new StringOps(Predef$.MODULE$.augmentString(x$16)).$less((Object)x$17);
    }

    private final void readOnce$2(InputStream in$2, ByteArrayOutputStream bos$1, byte[] ba$2) {
        int len;
        do {
            if ((len = in$2.read(ba$2)) <= 0) continue;
            bos$1.write(ba$2, 0, len);
        } while (len >= 0);
    }

    private HttpConstants$() {
        MODULE$ = this;
        this.CharsetRegex = new Regex("(?i)\\bcharset=\\s*\"?([^\\s;\"]*)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        Class<HttpURLConnection> connClass = HttpURLConnection.class;
        Tuple2 tuple2 = HttpConstants$.liftedTree1$1(connClass);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        boolean isLong = tuple2._1$mcZ$sp();
        Method theMethod = (Method)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)isLong), (Object)theMethod);
        Tuple2 tuple23 = tuple22;
        boolean isLong2 = tuple23._1$mcZ$sp();
        Method theMethod2 = (Method)tuple23._2();
        this.setFixedLengthStreamingMode = (Function2 & Serializable & scala.Serializable)(conn, length) -> {
            HttpConstants$.$anonfun$setFixedLengthStreamingMode$1(isLong2, theMethod2, conn, BoxesRunTime.unboxToLong((Object)length));
            return BoxedUnit.UNIT;
        };
        this.utf8 = "UTF-8";
    }
}

