/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.http.undertow;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.UndertowLogger;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.resource.PathResourceManager;
import io.undertow.server.handlers.resource.ResourceManager;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Paths;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.channels.StreamSinkChannel;

public class ByteWriteChannelListener
implements ChannelListener<StreamSinkChannel> {
    private final ByteBuffer buffer;

    public ByteWriteChannelListener(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public void setup(StreamSinkChannel channel) {
        try {
            int c;
            do {
                c = channel.write(this.buffer);
            } while (this.buffer.hasRemaining() && c > 0);
            if (this.buffer.hasRemaining()) {
                channel.getWriteSetter().set((ChannelListener)this);
                channel.resumeWrites();
            } else {
                this.writeDone(channel);
            }
        }
        catch (IOException e) {
            this.handleError(channel, e);
        }
    }

    protected void handleError(StreamSinkChannel channel, IOException e) {
        UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
        IoUtils.safeClose((Closeable)channel);
    }

    public void handleEvent(StreamSinkChannel channel) {
        try {
            int c;
            do {
                c = channel.write(this.buffer);
            } while (this.buffer.hasRemaining() && c > 0);
            if (this.buffer.hasRemaining()) {
                channel.resumeWrites();
                return;
            }
            this.writeDone(channel);
        }
        catch (IOException e) {
            this.handleError(channel, e);
        }
    }

    public boolean hasRemaining() {
        return this.buffer.hasRemaining();
    }

    protected void writeDone(StreamSinkChannel channel) {
        try {
            channel.shutdownWrites();
            if (!channel.flush()) {
                ChannelListener listener = ChannelListeners.flushingChannelListener(o -> IoUtils.safeClose((Closeable)channel), (ChannelExceptionHandler)ChannelListeners.closingChannelExceptionHandler());
                channel.getWriteSetter().set(listener);
                channel.resumeWrites();
            }
        }
        catch (IOException e) {
            this.handleError(channel, e);
        }
    }

    public static void main(String[] args) {
        Undertow server = Undertow.builder().addHttpListener(8080, "localhost").setHandler((HttpHandler)Handlers.resource((ResourceManager)new PathResourceManager(Paths.get(System.getProperty("user.home"), new String[0]), 100L)).setDirectoryListingEnabled(true)).build();
        server.start();
    }
}

