/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.http.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import org.mule.weave.v2.core.io.ByteArraySeekableStream;
import org.mule.weave.v2.module.http.HttpHeader$;
import org.mule.weave.v2.module.http.client.DigestAuth$;
import org.mule.weave.v2.module.http.client.HttpConstants$;
import org.mule.weave.v2.module.http.client.TLSSniSocketFactory;
import org.mule.weave.v2.module.http.client.WwwAuthenticate;
import org.mule.weave.v2.module.http.service.HttpClientOptions;
import org.mule.weave.v2.module.http.service.HttpClientRequest;
import org.mule.weave.v2.module.http.service.HttpClientRequest$;
import org.mule.weave.v2.module.http.service.HttpClientResponse;
import org.mule.weave.v2.module.http.service.HttpClientResult;
import org.mule.weave.v2.module.http.service.HttpClientResult$;
import org.mule.weave.v2.module.http.service.SSLOptions;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.GenSeqLike;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.TreeMap;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015h\u0001B\u000e\u001d\u0001-B\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\u0006s\u0001!\tA\u000f\u0005\b}\u0001\u0001\r\u0011\"\u0001@\u0011\u001dy\u0006\u00011A\u0005\u0002\u0001DaA\u001a\u0001!B\u0013\u0001\u0005bB4\u0001\u0001\u0004%\t\u0001\u001b\u0005\bY\u0002\u0001\r\u0011\"\u0001n\u0011\u0019y\u0007\u0001)Q\u0005S\"9\u0001\u000f\u0001a\u0001\n\u0003A\u0007bB9\u0001\u0001\u0004%\tA\u001d\u0005\u0007i\u0002\u0001\u000b\u0015B5\t\u000bU\u0004A\u0011\u0001<\t\u000be\u0004A\u0011\u0002>\t\u000f\u0005\u001d\u0001\u0001\"\u0003\u0002\n!9\u0011q\u0003\u0001\u0005\u0002\u0005e\u0001bBA\u0010\u0001\u0011\u0005\u0011\u0011\u0005\u0005\n\u0003g\u0001\u0011\u0013!C\u0001\u0003kAq!a\u0013\u0001\t\u0013\ti\u0005C\u0004\u0002h\u0001!I!!\u001b\t\u000f\u0005e\u0004\u0001\"\u0003\u0002|!I\u0011\u0011\u0011\u0001C\u0002\u0013\u0005\u00111\u0011\u0005\t\u00033\u0003\u0001\u0015!\u0003\u0002\u0006\"Q\u00111\u0014\u0001\t\u0006\u0004%I!!(\t\u000f\u0005-\u0006\u0001\"\u0001\u0002.\"9\u0011q\u0017\u0001\u0005\u0002\u0005e\u0006bBAd\u0001\u0011\u0005\u0011\u0011\u001a\u0002\f\u0011R$\bOU3rk\u0016\u001cHO\u0003\u0002\u001e=\u000511\r\\5f]RT!a\b\u0011\u0002\t!$H\u000f\u001d\u0006\u0003C\t\na!\\8ek2,'BA\u0012%\u0003\t1(G\u0003\u0002&M\u0005)q/Z1wK*\u0011q\u0005K\u0001\u0005[VdWMC\u0001*\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0006\u0005\u0002.a5\taFC\u00010\u0003\u0015\u00198-\u00197b\u0013\t\tdF\u0001\u0004B]f\u0014VMZ\u0001\b_B$\u0018n\u001c8t!\t!t'D\u00016\u0015\t1d$A\u0004tKJ4\u0018nY3\n\u0005a*$!\u0005%uiB\u001cE.[3oi>\u0003H/[8og\u00061A(\u001b8jiz\"\"aO\u001f\u0011\u0005q\u0002Q\"\u0001\u000f\t\u000bI\u0012\u0001\u0019A\u001a\u0002\rQLW.\u001a:t+\u0005\u0001\u0005cA!J\u0019:\u0011!i\u0012\b\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0003\u000b*\na\u0001\u0010:p_Rt\u0014\"A\u0018\n\u0005!s\u0013a\u00029bG.\fw-Z\u0005\u0003\u0015.\u00131aU3r\u0015\tAe\u0006\u0005\u0003.\u001b>;\u0016B\u0001(/\u0005\u0019!V\u000f\u001d7feA\u0011\u0001\u000b\u0016\b\u0003#J\u0003\"a\u0011\u0018\n\u0005Ms\u0013A\u0002)sK\u0012,g-\u0003\u0002V-\n11\u000b\u001e:j]\u001eT!a\u0015\u0018\u0011\u0005akV\"A-\u000b\u0005i[\u0016\u0001\u00027b]\u001eT\u0011\u0001X\u0001\u0005U\u00064\u0018-\u0003\u0002_3\n1a*^7cKJ\f!\u0002^5nKJ\u001cx\fJ3r)\t\tG\r\u0005\u0002.E&\u00111M\f\u0002\u0005+:LG\u000fC\u0004f\t\u0005\u0005\t\u0019\u0001!\u0002\u0007a$\u0013'A\u0004uS6,'o\u001d\u0011\u0002\u0015M$\u0018M\u001d;US6,'/F\u0001j!\ti#.\u0003\u0002l]\t!Aj\u001c8h\u00039\u0019H/\u0019:u)&lWM]0%KF$\"!\u00198\t\u000f\u0015<\u0011\u0011!a\u0001S\u0006Y1\u000f^1siRKW.\u001a:!\u0003=\u0019\u0007.Z2la>Lg\u000e\u001e+j[\u0016\u0014\u0018aE2iK\u000e\\\u0007o\\5oiRKW.\u001a:`I\u0015\fHCA1t\u0011\u001d)'\"!AA\u0002%\f\u0001c\u00195fG.\u0004x.\u001b8u)&lWM\u001d\u0011\u0002\u001bI,w-[:uKJ$\u0016.\\3s)\t\tw\u000fC\u0003y\u0019\u0001\u0007q*\u0001\u0003oC6,\u0017AC;sY\n+\u0018\u000e\u001c3feR\u001910a\u0001\u0011\u0005q|X\"A?\u000b\u0005y\\\u0016a\u00018fi&\u0019\u0011\u0011A?\u0003\u0007U\u0013F\n\u0003\u0004\u0002\u00065\u0001\raM\u0001\u0004e\u0016\f\u0018aC2p]:,7\r\u001e$v]\u000e$R!YA\u0006\u0003\u001bAa!!\u0002\u000f\u0001\u0004\u0019\u0004bBA\b\u001d\u0001\u0007\u0011\u0011C\u0001\u0005G>tg\u000eE\u0002}\u0003'I1!!\u0006~\u0005EAE\u000f\u001e9V%2\u001buN\u001c8fGRLwN\\\u0001\u000bO\u0016$XK\u0015'GS2,GcA(\u0002\u001c!1\u0011QD\bA\u0002m\f1!\u001e:m\u00031!wnQ8o]\u0016\u001cG/[8o)\u0011\t\u0019#!\u000b\u0011\u0007Q\n)#C\u0002\u0002(U\u0012\u0001\u0003\u0013;ua\u000ec\u0017.\u001a8u%\u0016\u001cX\u000f\u001c;\t\u0013\u0005-\u0002\u0003%AA\u0002\u00055\u0012AC;sYR{g)\u001a;dQB!Q&a\f|\u0013\r\t\tD\f\u0002\u0007\u001fB$\u0018n\u001c8\u0002-\u0011|7i\u001c8oK\u000e$\u0018n\u001c8%I\u00164\u0017-\u001e7uIE*\"!a\u000e+\t\u00055\u0012\u0011H\u0016\u0003\u0003w\u0001B!!\u0010\u0002H5\u0011\u0011q\b\u0006\u0005\u0003\u0003\n\u0019%A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\t\u0018\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002J\u0005}\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006QAo\u001c*fgB|gn]3\u0015\r\u0005=\u0013QKA,!\r!\u0014\u0011K\u0005\u0004\u0003'*$A\u0005%uiB\u001cE.[3oiJ+7\u000f]8og\u0016Dq!a\u0004\u0013\u0001\u0004\t\t\u0002C\u0004\u0002ZI\u0001\r!a\u0017\u0002\u0017%t\u0007/\u001e;TiJ,\u0017-\u001c\t\u0005\u0003;\n\u0019'\u0004\u0002\u0002`)\u0019\u0011\u0011M.\u0002\u0005%|\u0017\u0002BA3\u0003?\u00121\"\u00138qkR\u001cFO]3b[\u0006\u0011r-\u001a;SKN\u0004xN\\:f\u0011\u0016\fG-\u001a:t)\u0011\tY'a\u001e\u0011\rA\u000bigTA9\u0013\r\tyG\u0016\u0002\u0004\u001b\u0006\u0004\b\u0003B!\u0002t=K1!!\u001eL\u0005)Ie\u000eZ3yK\u0012\u001cV-\u001d\u0005\b\u0003\u001f\u0019\u0002\u0019AA\t\u000359W\r^*uCR,8\u000fV3yiR!\u0011QPA@!\u0011i\u0013qF(\t\u000f\u0005=A\u00031\u0001\u0002\u0012\u0005\u0011rN\u001a4jG\u0006d\u0007\n\u001e;q\u001b\u0016$\bn\u001c3t+\t\t)\t\u0005\u0004\u0002\b\u0006E\u0015QS\u0007\u0003\u0003\u0013SA!a#\u0002\u000e\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0003\u001fs\u0013AC2pY2,7\r^5p]&!\u00111SAE\u0005\r\u0019V\r\u001e\t\u00041\u0006]\u0015BA+Z\u0003MygMZ5dC2DE\u000f\u001e9NKRDw\u000eZ:!\u0003-iW\r\u001e5pI\u001aKW\r\u001c3\u0016\u0005\u0005}\u0005\u0003BAQ\u0003Ok!!a)\u000b\u0007\u0005\u0015\u0016,A\u0004sK\u001adWm\u0019;\n\t\u0005%\u00161\u0015\u0002\u0006\r&,G\u000eZ\u0001\u0007[\u0016$\bn\u001c3\u0015\u000b\u0005\fy+a-\t\r\u0005E\u0006\u00041\u0001P\u0003)iW\r\u001e5pI>\u0013\u0018n\u001a\u0005\b\u0003kC\u0002\u0019AA\t\u0003\u0005\u0019\u0017\u0001D2p]\u001aLw-\u001e:f'NcE#B1\u0002<\u0006u\u0006bBA[3\u0001\u0007\u0011\u0011\u0003\u0005\b\u0003\u007fK\u0002\u0019AAa\u0003\r\u00198\u000f\u001c\t\u0004i\u0005\r\u0017bAAck\tQ1k\u0015'PaRLwN\\:\u0002\u001d\u0005dGn\\<V]N\fg-Z*T\u0019R!\u00111ZAn!\u0011\ti-a6\u000e\u0005\u0005='\u0002BA`\u0003#T1A`Aj\u0015\t\t).A\u0003kCZ\f\u00070\u0003\u0003\u0002Z\u0006='\u0001E*T\u0019N{7m[3u\r\u0006\u001cGo\u001c:z\u0011\u001d\tiN\u0007a\u0001\u0003?\f\u0011\u0002\u001b;uaN\u001cuN\u001c8\u0011\t\u00055\u0017\u0011]\u0005\u0005\u0003G\fyM\u0001\nIiR\u00048/\u0016*M\u0007>tg.Z2uS>t\u0007")
public class HttpRequest {
    private Field methodField;
    private final HttpClientOptions options;
    private Seq<Tuple2<String, Number>> timers;
    private long startTimer;
    private long checkpointTimer;
    private final Set<String> officalHttpMethods;
    private volatile boolean bitmap$0;

    public Seq<Tuple2<String, Number>> timers() {
        return this.timers;
    }

    public void timers_$eq(Seq<Tuple2<String, Number>> x$1) {
        this.timers = x$1;
    }

    public long startTimer() {
        return this.startTimer;
    }

    public void startTimer_$eq(long x$1) {
        this.startTimer = x$1;
    }

    public long checkpointTimer() {
        return this.checkpointTimer;
    }

    public void checkpointTimer_$eq(long x$1) {
        this.checkpointTimer = x$1;
    }

    public void registerTimer(String name) {
        long now = System.nanoTime();
        Double time = Predef$.MODULE$.double2Double((double)(now - this.checkpointTimer()) / 1000000.0);
        this.checkpointTimer_$eq(now);
        this.timers_$eq((Seq<Tuple2<String, Number>>)((Seq)this.timers().$colon$plus((Object)new Tuple2((Object)name, (Object)time), Seq$.MODULE$.canBuildFrom())));
    }

    private URL urlBuilder(HttpClientOptions req) {
        return new URI(req.url()).toURL();
    }

    private void connectFunc(HttpClientOptions req, HttpURLConnection conn) {
        if (req.body().isDefined() && req.body().get() != null) {
            conn.setDoOutput(true);
            conn.connect();
            this.registerTimer("connect");
            InputStream in = (InputStream)req.body().get();
            OutputStream out = conn.getOutputStream();
            byte[] ba = new byte[4096];
            this.readOnce$1(in, ba, out);
        } else {
            conn.connect();
            this.registerTimer("connect");
        }
        this.registerTimer("send");
    }

    public String getURLFile(URL url) {
        String urlPath = url.getFile();
        if (urlPath != null && urlPath.length() != 0) {
            if (urlPath.charAt(0) == '?') {
                urlPath = new StringBuilder(1).append("/").append(urlPath).toString();
            }
        } else {
            urlPath = "/";
        }
        if (urlPath.indexOf(10) != -1) {
            throw new MalformedURLException("Illegal character in URL");
        }
        return urlPath;
    }

    public HttpClientResult doConnection(Option<URL> urlToFetch) {
        HttpClientResult result = new HttpClientResult(false, this.options, HttpClientResult$.MODULE$.apply$default$3(), HttpClientResult$.MODULE$.apply$default$4(), HttpClientResult$.MODULE$.apply$default$5(), HttpClientResult$.MODULE$.apply$default$6(), HttpClientResult$.MODULE$.apply$default$7());
        ObjectRef targetUrl = ObjectRef.create(null);
        try {
            BoxedUnit boxedUnit;
            try {
                Try try_;
                targetUrl.elem = (URL)urlToFetch.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.urlBuilder($this.options));
                InetAddress address = InetAddress.getByName(((URL)targetUrl.elem).getHost());
                this.registerTimer("dns");
                URLConnection uRLConnection = (URLConnection)this.options.proxyConfig().map((Function1 & Serializable & scala.Serializable)x -> ((URL)targetUrl$1.elem).openConnection((Proxy)x)).getOrElse((Function0 & Serializable & scala.Serializable)() -> ((URL)targetUrl$1.elem).openConnection());
                if (uRLConnection instanceof HttpURLConnection) {
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    this.method(this.options.method(), httpURLConnection);
                    httpURLConnection.setUseCaches(false);
                    httpURLConnection.setDefaultUseCaches(false);
                    HttpClientRequest req = new HttpClientRequest(httpURLConnection.getRequestMethod(), ((URL)targetUrl.elem).toString(), this.getURLFile((URL)targetUrl.elem), HttpClientRequest$.MODULE$.apply$default$4(), HttpClientRequest$.MODULE$.apply$default$5(), HttpClientRequest$.MODULE$.apply$default$6(), HttpClientRequest$.MODULE$.apply$default$7(), HttpClientRequest$.MODULE$.apply$default$8());
                    result.request_$eq((Option<HttpClientRequest>)new Some((Object)req));
                    boolean isSSL = ((URL)targetUrl.elem).toString().startsWith("https:");
                    req.port_$eq(((URL)targetUrl.elem).getPort() == -1 ? (isSSL ? 443 : 80) : ((URL)targetUrl.elem).getPort());
                    InetSocketAddress inetAddress = new InetSocketAddress(address, req.port());
                    req.ip_$eq(inetAddress.getAddress().getHostAddress());
                    this.options.headers().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        HttpRequest.$anonfun$doConnection$4(httpURLConnection, x0$1);
                        return BoxedUnit.UNIT;
                    });
                    if (!this.options.headers().contains((Object)HttpHeader$.MODULE$.ACCEPT_ENCODING_HEADER()) && this.options.allowCompression()) {
                        httpURLConnection.setRequestProperty(HttpHeader$.MODULE$.ACCEPT_ENCODING_HEADER(), "gzip,deflate");
                    }
                    String hostHeader = ((URL)targetUrl.elem).getHost();
                    if (!this.options.headers().contains((Object)HttpHeader$.MODULE$.HOST_HEADER())) {
                        hostHeader = ((URL)targetUrl.elem).getHost();
                        if (req.port() != 80) {
                            hostHeader = new StringBuilder(1).append(hostHeader).append(":").append(req.port()).toString();
                        }
                        httpURLConnection.setRequestProperty(HttpHeader$.MODULE$.HOST_HEADER(), hostHeader);
                    }
                    if (!this.options.headers().contains((Object)HttpHeader$.MODULE$.CONNECTION_HEADER())) {
                        httpURLConnection.setRequestProperty(HttpHeader$.MODULE$.CONNECTION_HEADER(), "close");
                    }
                    if (!this.options.headers().contains((Object)HttpHeader$.MODULE$.USER_AGENT_HEADER())) {
                        httpURLConnection.setRequestProperty(HttpHeader$.MODULE$.USER_AGENT_HEADER(), "DataWeave/2.0");
                    }
                    if (!this.options.headers().contains((Object)HttpHeader$.MODULE$.ACCEPT_HEADER())) {
                        httpURLConnection.setRequestProperty(HttpHeader$.MODULE$.ACCEPT_HEADER(), "text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2");
                    }
                    this.configureSSL(httpURLConnection, this.options.ssl());
                    httpURLConnection.setConnectTimeout(this.options.connectionTimeout().intValue());
                    httpURLConnection.setReadTimeout(this.options.readTimeout().intValue());
                    httpURLConnection.setInstanceFollowRedirects(false);
                    Map<String, List<String>> properties = httpURLConnection.getRequestProperties();
                    scala.collection.mutable.Map mutableHeaders = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                    properties.forEach((name, values) -> {
                        if (values == null || values.size() == 0 || values.size() == 1 && values.get(0) == null) {
                            req.path_$eq(name.substring(httpURLConnection.getRequestMethod().length() + 1, name.length() - 9));
                            req.httpVersion_$eq(name.substring(name.length() - 8));
                        } else {
                            ObjectRef newValue = ObjectRef.create((Object)((Seq)mutableHeaders.getOrElse(name, (Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$)));
                            values.forEach(value -> {
                                newValue$1.elem = (Seq)((Seq)newValue$1.elem).$colon$plus(value, Seq$.MODULE$.canBuildFrom());
                            });
                            mutableHeaders.update(name, (Object)((Seq)newValue.elem));
                        }
                    });
                    if (!mutableHeaders.contains((Object)HttpHeader$.MODULE$.HOST_HEADER())) {
                        Seq newValue = (Seq)mutableHeaders.getOrElse((Object)HttpHeader$.MODULE$.HOST_HEADER(), (Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
                        newValue = (Seq)newValue.$colon$plus((Object)hostHeader, Seq$.MODULE$.canBuildFrom());
                        mutableHeaders.update((Object)HttpHeader$.MODULE$.HOST_HEADER(), (Object)newValue);
                    }
                    this.options.headers().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        HttpRequest.$anonfun$doConnection$10(mutableHeaders, x0$2);
                        return BoxedUnit.UNIT;
                    });
                    req.headers_$eq((scala.collection.immutable.Map<String, Seq<String>>)mutableHeaders.toMap(Predef$.MODULE$.$conforms()));
                    req.payload_$eq(this.options.body());
                    try {
                        this.connectFunc(this.options, httpURLConnection);
                        result.response_$eq((Option<HttpClientResponse>)new Some((Object)this.toResponse(httpURLConnection, httpURLConnection.getInputStream())));
                        try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> httpURLConnection.disconnect());
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (!(throwable2 instanceof IOException) || httpURLConnection.getResponseCode() <= 0) {
                            throw throwable;
                        }
                        result.response_$eq((Option<HttpClientResponse>)new Some((Object)this.toResponse(httpURLConnection, httpURLConnection.getErrorStream())));
                        Try try_2 = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> httpURLConnection.disconnect());
                        try_ = try_2;
                    }
                } else {
                    throw new MatchError((Object)uRLConnection);
                }
                Try try_3 = try_;
                boxedUnit = try_3;
            }
            catch (ConnectException e) {
                result.err_$eq(true);
                result.message_$eq((Option<String>)new Some((Object)"Connection refused"));
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (URISyntaxException e) {
                result.err_$eq(true);
                result.message_$eq((Option<String>)new Some((Object)new StringBuilder(13).append("Invalid URI, ").append(e.getMessage()).toString()));
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (UnknownHostException e) {
                result.err_$eq(true);
                if (e.getMessage().contains(((URL)targetUrl.elem).getHost())) {
                    result.message_$eq((Option<String>)new Some((Object)new StringBuilder(21).append("Cannot resolve host: ").append(((URL)targetUrl.elem).getHost()).toString()));
                } else {
                    result.message_$eq((Option<String>)new Some((Object)new StringBuilder(21).append("Cannot resolve host: ").append(e.getMessage()).toString()));
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (SSLHandshakeException e) {
                result.err_$eq(true);
                result.message_$eq((Option<String>)new Some((Object)e.getMessage()));
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (SocketTimeoutException e) {
                result.err_$eq(true);
                result.message_$eq((Option<String>)new Some((Object)e.getMessage()));
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable e) {
                result.err_$eq(true);
                result.message_$eq((Option<String>)new Some((Object)e.toString()));
                boxedUnit = BoxedUnit.UNIT;
            }
        }
        finally {
            long now = System.nanoTime();
            Double time = Predef$.MODULE$.double2Double((double)(now - this.startTimer()) / 1000000.0);
            this.timers_$eq((Seq<Tuple2<String, Number>>)((Seq)this.timers().$colon$plus((Object)new Tuple2((Object)"total", (Object)time), Seq$.MODULE$.canBuildFrom())));
            result.timers_$eq((Option<scala.collection.immutable.Map<String, Number>>)new Some((Object)this.timers().toMap(Predef$.MODULE$.$conforms())));
        }
        return result;
    }

    public Option<URL> doConnection$default$1() {
        return None$.MODULE$;
    }

    private HttpClientResponse toResponse(HttpURLConnection conn, InputStream inputStream) {
        int responseCode = conn.getResponseCode();
        this.registerTimer("wait");
        scala.collection.immutable.Map<String, IndexedSeq<String>> headers = this.getResponseHeaders(conn);
        Option<String> statusText = this.getStatusText(conn);
        Option encoding = headers.get((Object)"Content-Encoding").flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.headOption());
        String AuthHeaderName = "Authorization";
        None$ redirection = responseCode == 401 && !this.options.headers().exists((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)HttpRequest.$anonfun$toResponse$2(AuthHeaderName, p))) ? this.options.digestCreds().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)HttpRequest.$anonfun$toResponse$5(check$ifrefutable$1))).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> {
            Tuple2 tuple2 = x$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String username = (String)tuple2._1();
            String password = (String)tuple2._2();
            Option option = headers.get((Object)"WWW-Authenticate").flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.headOption()).flatMap((Function1 & Serializable & scala.Serializable)headerValue -> DigestAuth$.MODULE$.getAuthDetails((String)headerValue)).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)HttpRequest.$anonfun$toResponse$9(check$ifrefutable$2))).withFilter((Function1 & Serializable & scala.Serializable)authParams -> BoxesRunTime.boxToBoolean((boolean)HttpRequest.$anonfun$toResponse$10(authParams))).map((Function1 & Serializable & scala.Serializable)authParams -> {
                URL url = this.urlBuilder($this.options);
                return new Tuple2(authParams, (Object)url);
            }).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> {
                URL url;
                WwwAuthenticate authParams;
                block3: {
                    Tuple2 tuple2;
                    block2: {
                        tuple2 = x$3;
                        if (tuple2 == null) break block2;
                        authParams = (WwwAuthenticate)tuple2._1();
                        url = (URL)tuple2._2();
                        if (authParams != null) break block3;
                    }
                    throw new MatchError((Object)tuple2);
                }
                WwwAuthenticate wwwAuthenticate = authParams;
                Option option = DigestAuth$.MODULE$.createHeaderValue(username, password, $this.options.method(), HttpRequest.toUri$1(url), HttpConstants$.MODULE$.readBytes(inputStream), wwwAuthenticate.params(), DigestAuth$.MODULE$.createHeaderValue$default$7()).map((Function1 & Serializable & scala.Serializable)digestResult -> {
                    HttpClientOptions newOptions = $this.options.copy(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)headers), digestResult), $this.options.copy$default$2(), $this.options.copy$default$3(), $this.options.copy$default$4(), $this.options.copy$default$5(), $this.options.copy$default$6(), $this.options.copy$default$7(), $this.options.copy$default$8(), $this.options.copy$default$9(), $this.options.copy$default$10(), $this.options.copy$default$11());
                    HttpRequest httpResponse = new HttpRequest(newOptions);
                    return (HttpClientResponse)httpResponse.doConnection((Option<URL>)new Some((Object)url)).response().get();
                });
                return option;
            });
            return option;
        }) : None$.MODULE$;
        return (HttpClientResponse)redirection.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            None$ redirectedResult = conn.getInstanceFollowRedirects() && (responseCode == 301 || responseCode == 302) ? headers.get((Object)"Location").flatMap((Function1 & Serializable & scala.Serializable)x$5 -> x$5.headOption()).map((Function1 & Serializable & scala.Serializable)location -> (HttpClientResponse)this.doConnection((Option<URL>)new Some((Object)new URL((String)location))).response().get()) : None$.MODULE$;
            return (HttpClientResponse)redirectedResult.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                HttpClientResponse httpClientResponse;
                InputStream theStream;
                boolean shouldDecompress;
                boolean bl = shouldDecompress = $this.options.allowCompression() && inputStream != null;
                InputStream inputStream = shouldDecompress && encoding.exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.equalsIgnoreCase("gzip"))) ? new GZIPInputStream(inputStream) : (theStream = shouldDecompress && encoding.exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.equalsIgnoreCase("deflate"))) ? new InflaterInputStream(inputStream) : inputStream);
                if (theStream != null) {
                    byte[] bytes = HttpConstants$.MODULE$.readBytes(theStream);
                    this.registerTimer("receive");
                    theStream.close();
                    ByteArraySeekableStream stream = new ByteArraySeekableStream(bytes);
                    httpClientResponse = new HttpClientResponse(Predef$.MODULE$.int2Integer(responseCode), (scala.collection.immutable.Map<String, Seq<String>>)headers, (Option<InputStream>)new Some((Object)stream), statusText);
                } else {
                    this.registerTimer("receive");
                    httpClientResponse = new HttpClientResponse(Predef$.MODULE$.int2Integer(responseCode), (scala.collection.immutable.Map<String, Seq<String>>)headers, (Option<InputStream>)None$.MODULE$, statusText);
                }
                return httpClientResponse;
            });
        });
    }

    private scala.collection.immutable.Map<String, IndexedSeq<String>> getResponseHeaders(HttpURLConnection conn) {
        return new TreeMap(package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$8 -> x$8.toLowerCase(), (Ordering)Ordering.String$.MODULE$)).$plus$plus((GenTraversableOnce)((TraversableLike)((TraversableLike)((Stream)package$.MODULE$.Stream().from(0).map((Function1 & Serializable & scala.Serializable)i -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))), (Object)conn.getHeaderField(BoxesRunTime.unboxToInt((Object)i))), Stream$.MODULE$.canBuildFrom())).takeWhile((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)HttpRequest.$anonfun$getResponseHeaders$3(x$9))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int i = tuple2._1$mcI$sp();
            String value = (String)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Option$.MODULE$.apply((Object)conn.getHeaderFieldKey(i)).getOrElse((Function0 & Serializable & scala.Serializable)() -> "-\n")), (Object)value);
            return tuple22;
        }, Stream$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)HttpRequest.$anonfun$getResponseHeaders$6(x)))).groupBy((Function1 & Serializable & scala.Serializable)x$10 -> (String)x$10._1()).mapValues((Function1 & Serializable & scala.Serializable)x$11 -> ((TraversableOnce)x$11.map((Function1 & Serializable & scala.Serializable)x$12 -> (String)x$12._2(), Stream$.MODULE$.canBuildFrom())).toIndexedSeq()));
    }

    private Option<String> getStatusText(HttpURLConnection conn) {
        return ((LinearSeqOptimized)((Stream)package$.MODULE$.Stream().from(0).map((Function1 & Serializable & scala.Serializable)i -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))), (Object)conn.getHeaderField(BoxesRunTime.unboxToInt((Object)i))), Stream$.MODULE$.canBuildFrom())).takeWhile((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)HttpRequest.$anonfun$getStatusText$2(x$13))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int i = tuple2._1$mcI$sp();
            String value = (String)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Option$.MODULE$.apply((Object)conn.getHeaderFieldKey(i)).getOrElse((Function0 & Serializable & scala.Serializable)() -> "-\n")), (Object)value);
            return tuple22;
        }, Stream$.MODULE$.canBuildFrom())).find((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)HttpRequest.$anonfun$getStatusText$5(x))).map((Function1 & Serializable & scala.Serializable)x -> (String)x._2());
    }

    public Set<String> officalHttpMethods() {
        return this.officalHttpMethods;
    }

    /*
     * WARNING - void declaration
     */
    private Field methodField$lzycompute() {
        HttpRequest httpRequest = this;
        synchronized (httpRequest) {
            if (!this.bitmap$0) {
                void var2_2;
                Field m = HttpURLConnection.class.getDeclaredField("method");
                m.setAccessible(true);
                this.methodField = var2_2;
                this.bitmap$0 = true;
            }
        }
        return this.methodField;
    }

    private Field methodField() {
        return !this.bitmap$0 ? this.methodField$lzycompute() : this.methodField;
    }

    public void method(String methodOrig, HttpURLConnection c) {
        String method = methodOrig.toUpperCase();
        if (this.officalHttpMethods().contains((Object)method)) {
            c.setRequestMethod(method);
        } else {
            HttpURLConnection httpURLConnection = c;
            if (httpURLConnection instanceof HttpsURLConnection) {
                HttpsURLConnection httpsURLConnection = (HttpsURLConnection)httpURLConnection;
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])httpsURLConnection.getClass().getDeclaredFields())).find((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)HttpRequest.$anonfun$method$1(x$14))).foreach((Function1 & Serializable & scala.Serializable)del -> {
                    HttpRequest.$anonfun$method$2(this, httpsURLConnection, method, del);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                this.methodField().set(httpURLConnection, method);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public void configureSSL(HttpURLConnection c, SSLOptions ssl) {
        HttpURLConnection httpURLConnection = c;
        if (httpURLConnection instanceof HttpsURLConnection) {
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)httpURLConnection;
            SSLSocketFactory sslFactory = ssl.allowSelfSignedCertificate() ? this.allowUnsafeSSL(httpsURLConnection) : (SSLSocketFactory)SSLSocketFactory.getDefault();
            httpsURLConnection.setSSLSocketFactory(new TLSSniSocketFactory(this, sslFactory){
                private final /* synthetic */ HttpRequest $outer;

                public void handshakeCompleted(HandshakeCompletedEvent a) {
                    this.$outer.registerTimer("ssl");
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    super(sslFactory$1);
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public SSLSocketFactory allowUnsafeSSL(HttpsURLConnection httpsConn) {
        HostnameVerifier hv = new HostnameVerifier(null){

            public boolean verify(String urlHostName, SSLSession session) {
                return true;
            }
        };
        httpsConn.setHostnameVerifier(hv);
        X509TrustManager trustManager = new X509TrustManager(null){

            public X509Certificate[] getAcceptedIssuers() {
                return (X509Certificate[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(X509Certificate.class));
            }

            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        };
        X509ExtendedTrustManager extendedTrustManager = new X509ExtendedTrustManager(null){

            public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) {
            }

            public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) {
            }

            public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) {
            }

            public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) {
            }

            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            public X509Certificate[] getAcceptedIssuers() {
                return (X509Certificate[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(X509Certificate.class));
            }
        };
        TrustManager[] trustAllCerts = (TrustManager[])((Object[])new TrustManager[]{trustManager, extendedTrustManager});
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        return sc.getSocketFactory();
    }

    private final void readOnce$1(InputStream in$1, byte[] ba$1, OutputStream out$1) {
        int len;
        do {
            if ((len = in$1.read(ba$1)) <= 0) continue;
            out$1.write(ba$1, 0, len);
        } while (len >= 0);
    }

    public static final /* synthetic */ void $anonfun$doConnection$4(HttpURLConnection x2$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String name = (String)tuple2._1();
        Seq values = (Seq)tuple2._2();
        values.foreach((Function1 & Serializable & scala.Serializable)value -> {
            x2$1.setRequestProperty(name, value);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$doConnection$10(scala.collection.mutable.Map mutableHeaders$1, Tuple2 x0$2) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String name = (String)tuple2._1();
            Seq values = (Seq)tuple2._2();
            if (!mutableHeaders$1.contains((Object)name)) {
                Seq newValue = (Seq)mutableHeaders$1.getOrElse((Object)name, (Function0 & Serializable & scala.Serializable)() -> values);
                mutableHeaders$1.update((Object)name, (Object)newValue);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$toResponse$2(String AuthHeaderName$1, Tuple2 p) {
        Object object = p._1();
        String string = AuthHeaderName$1;
        return !(object != null ? !object.equals(string) : string != null) && ((GenSeqLike)p._2()).startsWith((GenSeq)Predef$.MODULE$.wrapString(DigestAuth$.MODULE$.DigestPrefix()));
    }

    private static final String toUri$1(URL url) {
        return new StringBuilder(0).append(url.getPath()).append(Option$.MODULE$.apply((Object)url.getQuery()).map((Function1 & Serializable & scala.Serializable)q -> new StringBuilder(1).append("?").append((String)q).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString();
    }

    public static final /* synthetic */ boolean $anonfun$toResponse$5(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$toResponse$9(WwwAuthenticate check$ifrefutable$2) {
        WwwAuthenticate wwwAuthenticate = check$ifrefutable$2;
        boolean bl = wwwAuthenticate != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$toResponse$10(WwwAuthenticate authParams) {
        return authParams.authType().equalsIgnoreCase(DigestAuth$.MODULE$.DigestPrefix());
    }

    public static final /* synthetic */ boolean $anonfun$getResponseHeaders$3(Tuple2 x$9) {
        return x$9._2() != null;
    }

    public static final /* synthetic */ boolean $anonfun$getResponseHeaders$6(Tuple2 x) {
        Object object = x._1();
        String string = "-\n";
        return object == null ? string != null : !object.equals(string);
    }

    public static final /* synthetic */ boolean $anonfun$getStatusText$2(Tuple2 x$13) {
        return x$13._2() != null;
    }

    public static final /* synthetic */ boolean $anonfun$getStatusText$5(Tuple2 x) {
        Object object = x._1();
        String string = "-\n";
        return !(object != null ? !object.equals(string) : string != null);
    }

    public static final /* synthetic */ boolean $anonfun$method$1(Field x$14) {
        String string = x$14.getName();
        String string2 = "delegate";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$method$2(HttpRequest $this, HttpsURLConnection x2$2, String method$1, Field del) {
        del.setAccessible(true);
        $this.methodField().set(del.get(x2$2), method$1);
    }

    public HttpRequest(HttpClientOptions options) {
        this.options = options;
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
        this.timers = (Seq)Nil$.MODULE$;
        this.startTimer = System.nanoTime();
        this.checkpointTimer = this.startTimer();
        this.officalHttpMethods = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GET", "POST", "HEAD", "OPTIONS", "PUT", "DELETE", "TRACE"}));
    }
}

