package org.mule.weave.v2.module.commons.java.writer.converter

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.schema.Schema
import org.mule.weave.v2.model.values.math.Number

class ShortDataConverter extends DataConverter[Short] {
  override def convert(source: Any, schema: Option[Schema])(implicit ctx: EvaluationContext): Option[Short] = {
    source match {
      case l: Long                  => Option(l.toShort)
      case i: Int                   => Option(i.toShort)
      case d: Double                => Option(d.toShort)
      case s: Short                 => Option(s)
      case d: Float                 => Option(d.toShort)
      case n: Number                => Option(n.toShort)
      case bd: java.math.BigDecimal => Option(bd.shortValue())
      case bi: java.math.BigInteger => Option(bi.shortValue())
      case str: String              => Option(str.toShort)
      case _                        => None
    }

  }
}
