package org.mule.weave.v2.module.pojo.reader

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.module.pojo.exception.InvalidPropertyNameException
import org.mule.weave.v2.parser.location.LocationCapable

import java.lang.reflect.Field
import scala.util.Try

class LegacyPropertyDefinition(val name: String, val clazz: Class[_]) extends PropertyDefinition {

  @volatile
  private var _fieldInitialized: Boolean = false
  private var _field: Option[Field] = _

  private def field(implicit ctx: EvaluationContext): Option[Field] = {
    if (!_fieldInitialized) {
      synchronized {
        if (!_fieldInitialized) {
          _field = trySetAccessible(searchField(name, clazz))
          _fieldInitialized = true
        }
      }
    }
    _field
  }

  private def searchField(name: String, inClass: Class[_]): Option[Field] = {
    if (inClass == null) {
      None
    } else {
      Try(Some(inClass.getDeclaredField(name))).getOrElse(searchField(name, inClass.getSuperclass))
    }
  }

  override protected def doRead(instance: Any, location: LocationCapable)(implicit ctx: EvaluationContext): Any = {
    readMethod match {
      case Some(method) =>
        method.invoke(instance)
      case _ =>
        field match {
          case Some(f) =>
            f.get(instance)
          case _ =>
            throw new InvalidPropertyNameException(location.location(), name, clazz)
        }
    }
  }

  override protected def doWrite(instance: Any, value: AnyRef, location: LocationCapable)(implicit ctx: EvaluationContext): Boolean = {
    writeMethod match {
      case Some(method) =>
        method.invoke(instance, value)
        true
      case _ =>
        field match {
          case Some(field) =>
            field.set(instance, value)
            true
          case _ =>
            false
        }
    }
  }

  override protected def doResolveClassType(implicit ctx: EvaluationContext): Class[_] = {
    writeMethod match {
      case Some(m) =>
        m.getParameterTypes.apply(0)
      case _ =>
        readMethod match {
          case Some(m) =>
            m.getReturnType
          case _ =>
            field match {
              case Some(field) =>
                field.getType
              case _ =>
                throw new IllegalStateException("No read or write handler for " + name)
            }
        }
    }
  }
}
