package org.mule.weave.v2.module.javaplain.writer

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.module.commons.java.JavaClassLoaderHelper
import org.mule.weave.v2.module.javaplain.exception.ClassLoadForbiddenException
import org.mule.weave.v2.parser.location.LocationCapable

object JavaPlainClassLoaderHelper extends JavaClassLoaderHelper {
  override def doLoadClass(className: String, loader: Option[ClassLoader], location: LocationCapable)(implicit ctx: EvaluationContext): Class[_] = throw ClassLoadForbiddenException(location.location(), className)
}
