package org.mule.weave.v2.editor.quickfix

import org.mule.weave.v2.WeaveEditorSupport
import org.mule.weave.v2.completion.Template
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.functions.FunctionCallNode
import org.mule.weave.v2.utils.WeaveTypeHelper

class CreateFunctionDeclarationQuickFix(val editorSupport: WeaveEditorSupport, val fc: FunctionCallNode, val functionName: String) extends TemplateBasedQuickFixAction {

  override protected def createTemplate(): Template = {
    val maybeTypeGraph = editorSupport.reverseTypeGraph()
    val template = Template().add(s"fun ${functionName}(")
    fc.args.args.zipWithIndex.foreach((argWithIndex) => {
      val maybeMaybeArgType = maybeTypeGraph.flatMap((typeGraph) => {
        val astNode = argWithIndex._1
        val maybeNode = typeGraph.findNode(astNode)
        maybeNode.flatMap(_.resultType().flatMap(wt => Some(wt.baseType())))
      })

      if (argWithIndex._2 > 0) {
        template.add(", ")
      }
      template.placeHolder(s"param${argWithIndex._2}")
      if (maybeMaybeArgType.isDefined) {
        template.add(": ").placeHolder(maybeMaybeArgType.get.toString(false, true))
      }
    })
    template.add(")")
    if (maybeTypeGraph.isDefined) {
      val maybeNode = maybeTypeGraph.get.findNode(fc)
      val expectedType = maybeNode.flatMap(_.collectExpectedType())
      if (expectedType.isDefined) {
        if (WeaveTypeHelper.isSimpleType(expectedType.get)) {
          template.add(": " + expectedType.get.baseType().toString)
        }
      }
    }
    template.add(" = ")
    template.placeHolder("???")
    template.newLine()
    template
  }

  override val element: AstNode = fc
}
