package org.mule.weave.v2.grammar

import org.mule.weave.v2.grammar.location.PositionTracking
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.header.directives.DirectiveNode
import org.mule.weave.v2.parser.ast.module._
import org.parboiled2._

trait ModuleGrammar extends WhiteSpaceHandling with PositionTracking with StringBuilding with Tokens with Identifiers with Expressions with Schemas with Directives {
  this: org.mule.weave.v2.grammar.ModuleGrammar with Grammar =>

  //
  def module: Rule1[ModuleNode] = rule {
    moduleDefinition ~ ws ~ EOI
  }

  def moduleDefinition: Rule1[ModuleNode] = namedRule("module") {
    pushPosition ~ (&(setSyntaxVersion) ~ ws ~ directives ~ ws ~> createModule) ~ injectPosition
  }

  val createModule = (elements: Seq[DirectiveNode]) => {
    val node = ModuleNode(resourceName, elements)
    if (attachDocumentation) {
      assignCommentNodes(node)
    }
    node
  }
}
