package org.mule.weave.v2.grammar

import org.mule.weave.v2.grammar.literals.Literals
import org.mule.weave.v2.grammar.location.PositionTracking
import org.mule.weave.v2.grammar.structure.Attributes
import org.mule.weave.v2.grammar.structure.Namespaces
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.structure.NameNode
import org.mule.weave.v2.parser.ast.updates.ArrayIndexUpdateSelectorNode
import org.mule.weave.v2.parser.ast.updates.AttributeNameUpdateSelectorNode
import org.mule.weave.v2.parser.ast.updates.UpdateExpressionNode
import org.mule.weave.v2.parser.ast.updates.UpdateExpressionsNode
import org.mule.weave.v2.parser.ast.updates.UpdateSelectorNode
import org.mule.weave.v2.parser.ast.updates.FieldNameUpdateSelectorNode
import org.mule.weave.v2.parser.ast.updates.MultiFieldNameUpdateSelectorNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.parboiled2.Rule1

import scala.annotation.switch

trait Updaters extends PositionTracking with Tokens with Variables with Selectors with Literals with Namespaces with Attributes {
  this: Updaters with Grammar =>

  private val createFieldNameSelectorNode = (nameIdentifier: AstNode, child: Option[AstNode]) => FieldNameUpdateSelectorNode(nameIdentifier, child)

  private val createAttributeNameSelectorNode = (nameIdentifier: AstNode, child: Option[AstNode]) => AttributeNameUpdateSelectorNode(nameIdentifier, child)

  private val createMultiFieldNameSelectorNode = (nameIdentifier: AstNode, child: Option[AstNode]) => MultiFieldNameUpdateSelectorNode(nameIdentifier, child)

  private val createIndexSelectorNode = (nameIdentifier: AstNode, child: Option[AstNode]) => ArrayIndexUpdateSelectorNode(nameIdentifier, child)

  private val createUpdateExpressions = (expressions: Seq[UpdateExpressionNode]) => UpdateExpressionsNode(expressions)

  private val createUpdateExpression = (nameId: NameIdentifier, indexId: NameIdentifier, selector: AstNode, forceCreate: Option[Boolean], condition: Option[AstNode], expr: AstNode) => UpdateExpressionNode(nameId, indexId, selector, forceCreate.getOrElse(false), condition, expr)

  def updateExpressions: Rule1[UpdateExpressionsNode] = rule {
    pushPosition ~ (curlyBracketsStart ~ oneOrMore(updateExpr).separatedBy(fws) ~!~ (curlyBracketsEnd | fail("'}' for the Update expression.")) ~> createUpdateExpressions) ~ injectPosition
  }

  private def updateExpr: Rule1[UpdateExpressionNode] = namedRule("update") {
    pushPosition ~ ((caseKeyword ~!~ (updateArg ~ ws ~!~ (updateSelectorExpression | missingSelectorExpression("Missing Update Selector Expression. i.e {a: 1} update {\n case aValue at .a -> aValue + 1\n}")) ~ optional(ch('!') ~ push(true))) ~ ws ~!~ optional(ifKeyword ~ ws ~ parenStart ~ (expr | missingExpression(MISSING_IF_CONDITION_EXPRESSION_MESSAGE)) ~ parenEnd) ~ ((lambdaMark ~!~ (expr | missingExpression("Missing Update Expression i.e `{a: 1} update {\n case aValue at .a -> aValue + 1\n}`"))) | missingToken("Missing Case Update Expression i.e `{a: 1} update {\n case aValue at .a -> aValue + 1\n}`", "->"))) ~> createUpdateExpression) ~ injectPosition
  }

  def updateArg = rule {
    ((nameIdentifierNode ~ push(NameIdentifier.$$) ~!~ atKeyword) | (parenStart ~ nameIdentifierNode ~ commaSep ~ nameIdentifierNode ~ parenEnd ~!~ atKeyword) | (push(NameIdentifier.$) ~ push(NameIdentifier.$$)))
  }

  private def updateSelectorExpression: Rule1[AstNode] = rule {
    (run {
      (cursorChar: @switch) match {
        case '.' => propertyUpdateSelector
        case '[' => arrayIndexSelector
        case _   => MISMATCH
      }
    })
  }

  def arrayIndexSelector = rule {
    pushPosition ~ (squareBracketOpen ~!~ expr ~ (squareBracketEnd | fail("']' for the Index selector expression.")) ~!~ optional(updateSelectorExpression)) ~> createIndexSelectorNode ~ injectPosition
  }

  private def propertyUpdateSelector: Rule1[UpdateSelectorNode] = rule {
    pushPosition ~ (dot ~!~ (attributeNameUpdaterSelector | multiFieldNameUpdaterSelector | fieldNameUpdaterSelector)) ~ injectPosition
  }

  private def fieldNameUpdaterSelector = rule {
    fieldName ~!~ optional(updateSelectorExpression) ~> createFieldNameSelectorNode
  }

  private def multiFieldNameUpdaterSelector = rule {
    starToken ~!~ fieldName ~!~ optional(updateSelectorExpression) ~> createMultiFieldNameSelectorNode
  }

  private def attributeNameUpdaterSelector = rule {
    atToken ~!~ (fieldName) ~!~ optional(updateSelectorExpression) ~> createAttributeNameSelectorNode
  }
}
