package org.mule.weave.v2.inspector

import org.mule.weave.v2.codegen.CodeGenerator
import org.mule.weave.v2.editor.QuickFixAction
import org.mule.weave.v2.editor.WeaveTextDocument
import org.mule.weave.v2.parser.UsingDefaultWithLiteralValue
import org.mule.weave.v2.parser.UsingDefaultWithNullValue
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.LiteralValueAstNode
import org.mule.weave.v2.parser.ast.conditional.DefaultNode
import org.mule.weave.v2.parser.ast.structure.NullNode
import org.mule.weave.v2.parser.phase.AstNodeResultAware
import org.mule.weave.v2.parser.phase.ParsingContext
import org.mule.weave.v2.parser.phase.ScopeNavigatorResultAware

object UnnecessaryDefaultInspector extends CodeInspector[AstNodeResultAware[_] with ScopeNavigatorResultAware] {
  override def inspect(node: AstNode, scopeData: AstNodeResultAware[_] with ScopeNavigatorResultAware, parsingContext: ParsingContext): Unit = {
    node match {
      case defaultNode @ DefaultNode(lhs: LiteralValueAstNode, _, _) => {
        lhs match {
          case _: NullNode => {
            //null default a.b
            parsingContext.messageCollector.warning(UsingDefaultWithNullValue(defaultNode), defaultNode.location())
          }
          case _ => {
            //"value" default a.b
            parsingContext.messageCollector.warning(UsingDefaultWithLiteralValue(defaultNode), defaultNode.location())
          }
        }

      }
      case _ =>
    }
  }
}

class ReplaceDefaultWithValueFixAction(defaultValue: DefaultNode) extends QuickFixAction {
  override def run(document: WeaveTextDocument): Unit = {
    val startIndex = defaultValue.location().startPosition.index
    document.delete(startIndex, defaultValue.location().endPosition.index)
    document.insert(CodeGenerator.generate(defaultValue.lhs), startIndex)
  }
}

class ReplaceDefaultWithDefaultValueFixAction(defaultValue: DefaultNode) extends QuickFixAction {
  override def run(document: WeaveTextDocument): Unit = {
    val startIndex = defaultValue.location().startPosition.index
    document.delete(startIndex, defaultValue.location().endPosition.index)
    document.insert(CodeGenerator.generate(defaultValue.rhs), startIndex)
  }
}
