package org.mule.weave.v2.parser.ast.functions

import org.mule.weave.v2.api.tooling.ast.DWAstNodeKind
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.Children
import org.mule.weave.v2.parser.ast.ContainerAstNode
import org.mule.weave.v2.parser.ast.ExpressionAstNode
import org.mule.weave.v2.parser.ast.MutableAstNode
import org.mule.weave.v2.parser.ast.annotation.AnnotationNode
import org.mule.weave.v2.parser.ast.types.TypeParametersApplicationListNode

case class FunctionCallNode(var function: AstNode, var args: FunctionCallParametersNode = FunctionCallParametersNode(), var typeParameters: Option[TypeParametersApplicationListNode] = None, var codeAnnotations: Seq[AnnotationNode] = Seq()) extends ExpressionAstNode with MutableAstNode {

  override def children(): Seq[AstNode] = Children(function, args).++=(typeParameters).++=(codeAnnotations).result()

  override protected def doClone(): AstNode = copy(function.cloneAst(), args.cloneAst(), typeParameters.map(x => x.cloneAst()), codeAnnotations.map(_.cloneAst()))

  /**
    * Sets the annotations to this node
    *
    * @param annotations The list of annotations
    */
  override def setAnnotations(annotations: Seq[AnnotationNode]): Unit = {
    this.codeAnnotations = annotations
  }

  /**
    * Replace the child node that is equals to the given node with the new one
    *
    * @param toBeReplaced The node to be replaced
    * @param withNode     The replacement
    */
  override def update(toBeReplaced: AstNode, withNode: AstNode): Unit = {
    if (function eq toBeReplaced) {
      function = withNode
    } else if (args eq toBeReplaced) {
      args = withNode.asInstanceOf[FunctionCallParametersNode]
    } else if (typeParameters.exists(_ eq withNode)) {
      typeParameters = Some(withNode.asInstanceOf[TypeParametersApplicationListNode])
    }
  }

  override def getKind(): String = DWAstNodeKind.FUNCTION_CALL_NODE
}

case class FunctionCallParametersNode(var args: Seq[AstNode] = Seq()) extends ContainerAstNode with MutableAstNode {
  override def children(): Seq[AstNode] = args

  override def cloneAst(): FunctionCallParametersNode = super.cloneAst().asInstanceOf[FunctionCallParametersNode]

  override protected def doClone(): AstNode = copy(args.map(_.cloneAst()))

  override def update(toBeReplaced: AstNode, withNode: AstNode): Unit = {
    args = args.map {
      case e if e eq toBeReplaced => withNode
      case other                  => other
    }
  }

  override def getKind(): String = DWAstNodeKind.FUNCTION_CALL_PARAMETERS_NODE
}
