package org.mule.weave.v2.sdk.selectors

import org.mule.weave.v2.ts.AnyType
import org.mule.weave.v2.ts.ObjectType
import org.mule.weave.v2.ts.TypeHelper.hasPatternProperty
import org.mule.weave.v2.ts.TypeHelper.unify
import org.mule.weave.v2.ts.TypeNode
import org.mule.weave.v2.ts.UnionType
import org.mule.weave.v2.ts.WeaveType
import org.mule.weave.v2.ts.WeaveTypeResolutionContext

object ObjectIndexSelectorCustomTypeResolver extends BaseValueSelectorCustomTypeResolver {

  override def select(leftType: WeaveType, selector: WeaveType, ctx: WeaveTypeResolutionContext, node: TypeNode, insideArray: Boolean): SelectionResult = {
    leftType match {
      case ObjectType(properties, close, _) => {
        if (properties.isEmpty && close) {
          NoMatch(close)
        } else if (close || hasPatternProperty(properties)) {
          ///We can only determine something if we know what kind of values this object has. And that can only be applied if the value is close
          // or it has a wildecard that limits the possible values, like a dictionary
          val weaveType = unify(properties.map(_.value))
          weaveType match {
            case _: UnionType => Matched(AnyType())
            case _ => {
              val selectedValue = weaveType.markOptional()
              Matched(selectedValue)
            }
          }
        } else {
          NoMatch(closed = false)
        }
      }
      case _ => Unknown
    }
  }
}
