package org.mule.weave.v2.utils

import java.io.File

import org.mule.weave.v2.parser.MappingParser
import org.mule.weave.v2.parser.ast.structure.DocumentNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.parser.phase.ParsingResult
import org.mule.weave.v2.parser.phase.PhaseResult
import org.mule.weave.v2.sdk.ParsingContextFactory
import org.mule.weave.v2.sdk.WeaveResourceFactory

object ParserUtils {

  def parseMappingFile(file: File): PhaseResult[ParsingResult[DocumentNode]] = {
    MappingParser.parse(MappingParser.parsingPhase(), WeaveResourceFactory.fromFile(file), ParsingContextFactory.createParsingContext(NameIdentifier(baseName(file))))
  }

  def parseMapping(content: String): PhaseResult[ParsingResult[DocumentNode]] = {
    MappingParser.parse(MappingParser.parsingPhase(), WeaveResourceFactory.fromContent(content), ParsingContextFactory.createParsingContext(NameIdentifier.anonymous))
  }

  def baseName(x: File): String = {
    x.getName.substring(0, x.getName.lastIndexOf("."))
  }

}
