package org.mule.weave.v2.utils

import java.util.concurrent.locks.ReentrantLock
import java.util.concurrent.locks.ReentrantReadWriteLock

class JVMReadWriteLock extends ReadWriteLock {

  private val parentLock: ReentrantReadWriteLock = new ReentrantReadWriteLock()
  private val readLock: ReentrantReadWriteLock.ReadLock = parentLock.readLock()
  private val writeLock: ReentrantReadWriteLock.WriteLock = parentLock.writeLock()

  override def readLock[T](provider: => T): T = {
    readLock.lock()
    try {
      provider
    } finally {
      readLock.unlock()
    }
  }

  override def writeLock[T](provider: => T): T = {
    writeLock.lock()
    try {
      provider
    } finally {
      writeLock.unlock()
    }
  }
}

class JVMLock extends Lock {
  val reentrantLock = new ReentrantLock()

  override def lock[T](provider: => T): T = {
    reentrantLock.lock()
    try {
      provider
    } finally {
      reentrantLock.unlock()
    }
  }
}

object LockFactory {
  def createReadWriteLock(): ReadWriteLock = new JVMReadWriteLock
  def createLock(): Lock = new JVMLock
}

