package org.mule.weave.v2.editor.quickfix

import org.mule.weave.v2.WeaveEditorSupport
import org.mule.weave.v2.completion.Template
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.structure.NamespaceNode

class DeclareNamespaceDeclarationAction(val editorSupport: WeaveEditorSupport, prefix: String, uri: String, location: AstNode) extends TemplateBasedQuickFixAction {

  override protected def createTemplate(): Template = {
    val template = Template().add(s"ns ${prefix} ").add(uri)
    template.newLine()
    template
  }

  override val element: AstNode = location
}