package org.mule.weave.v2.inspector

import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.scope.ScopesNavigator

object ReferenceUtils {

  /**
    * Checks if the specified variable links to the given target. The variable needs to be the ASTNode that was taken from the original Parsing AST
    * @param variable The variable to validate
    * @param target The FQN of the target
    * @param scopesNavigator The scope navigator that was generated for the Parsing AST
    * @return True if they are linked
    */
  def isReferencingTo(variable: NameIdentifier, target: NameIdentifier, scopesNavigator: ScopesNavigator): Boolean = {
    scopesNavigator.resolveVariable(variable) match {
      case Some(ref) => {
        ref.fqnReferenceName == target
      }
      case None => false
    }
  }

}
