package org.mule.weave.v2.ts.resolvers

import org.mule.weave.v2.ts.ArrayType
import org.mule.weave.v2.ts.Edge
import org.mule.weave.v2.ts.EdgeLabels
import org.mule.weave.v2.ts.FunctionType
import org.mule.weave.v2.ts.ReferenceType
import org.mule.weave.v2.ts.TypeNode
import org.mule.weave.v2.ts.WeaveType
import org.mule.weave.v2.ts.WeaveTypeResolutionContext
import org.mule.weave.v2.ts.WeaveTypeResolver

object DeconstructArrayPatternTypeResolver extends WeaveTypeResolver {
  override def resolveReturnType(node: TypeNode, ctx: WeaveTypeResolutionContext): Option[WeaveType] = {
    val caseExpression: Edge = node.incomingEdges(EdgeLabels.PATTERN_EXPRESSION).head
    val matchExpression: Edge = node.incomingEdges(EdgeLabels.MATCH_EXPRESSION).head
    val functionType: FunctionType = matchExpression.incomingType().asInstanceOf[FunctionType]
    val caseType: WeaveType = caseExpression.incomingType()

    resolveReturnType(node, ctx, functionType, caseType)
  }

  private def resolveReturnType(node: TypeNode, ctx: WeaveTypeResolutionContext, functionType: FunctionType, caseType: WeaveType): Option[WeaveType] = {
    caseType match {
      case ArrayType(arrayType) => {
        FunctionCallNodeResolver.resolveReturnType(functionType, Seq(arrayType, caseType), Seq(), node, ctx)
      }
      case rt: ReferenceType => resolveReturnType(node, ctx, functionType, rt.resolveType())
      case _                 => None
    }
  }
}
