package org.mule.weave.v2.utils
import java.util.regex.Matcher
import java.util.regex.Pattern

object AsciiDocMigrator {
  //WE CAN NOT USE NAMED GROUPS AS IT IS NOT SUPPORTED BY SCALAJS :(
  val TABLE: Pattern = Pattern.compile("(\\[.*\\])\\R\\|===\\R([\\S\\s]+?(?=\\R\\|===))\\R\\|===")
  val HEADER: Pattern = Pattern.compile("(?m)^([=]+)(.*)")
  val UN_ORDER_LIST: Pattern = Pattern.compile("(?m)^([*]+)(.*)")
  val CODE_BLOCK: Pattern = Pattern.compile("\\[source,\\s*(\\w*).*\\]\\R----")

  def replaceWith(ret: String, pattern: Pattern, replacement: Matcher => String): String = {
    val headerMatcher: Matcher = pattern.matcher(ret)
    val result = new StringBuilder
    var cursor = 0
    while (headerMatcher.find()) {
      val startHeader = headerMatcher.start()
      val endHeader = headerMatcher.end()
      result.append(ret.substring(cursor, startHeader))
      cursor = endHeader
      val newValue = replacement(headerMatcher)
      result.append(newValue)
    }
    result.append(ret.substring(cursor, ret.length))
    result.toString()
  }

  def toMarkDown(asciidoc: String): String = {

    //code block
    var ret: String = asciidoc

    ret = replaceWith(ret, UN_ORDER_LIST, (matcher) => {
      val level = matcher.group(1)
      ("  " * (level.length - 1)) + "-" + matcher.group(2)
    })

    ret = replaceWith(ret, CODE_BLOCK, (matcher) => {
      val language = matcher.group(1)
      s"```${language.toLowerCase}"
    })

    ret = ret.replaceAll("----", "```")

    ret = replaceWith(ret, HEADER, (matcher) => {
      val header = matcher.group(1)
      ("#" * header.length) + matcher.group(2)
    })

    //block image
    ret = ret.replaceAll("image::(.*)(\\[.*\\])", "!$2($1)")

    //image
    ret = ret.replaceAll("image:(.*)(\\[.*\\])", "!$2(/images/$1)")

    //relative link
    ret = ret.replaceAll("xref:(.*)(\\[.*\\])", "$2($1)")

    //relative link
    ret = ret.replaceAll("link:(.*)(\\[.*\\])", "$2($1)")

    //link with label
    ret = ret.replaceAll("http(.*)(\\[.*\\])", "$2(http$1)")

    //title
    ret = ret.replaceAll("(?m)^\\.([^\\s]+)", "#### $1")

    //ordered lists -> unordered
    //I don't know how to count them in a scope with just regex
    ret = ret.replaceAll("(?m)^\\.\\s(.*)", "* $1")

    //Replace $ escaping characters
    ret = ret.replaceAll("&#36;", "\\$")

    val matcher = TABLE.matcher(ret)
    while (matcher.find()) {
      val bodyMatch = matcher.group(2)
      val lines = bodyMatch.linesIterator
      var i = 0
      var newTable = ""
      while (lines.hasNext) {
        val line = lines.next()
        if (i == 0) {
          val parts = line.split('|')
          var headerSeparator = ""
          parts.foreach((part) => {
            headerSeparator += "-" * part.length + "|"
          })
          newTable = line + s"|${System.lineSeparator()}" + headerSeparator + s"${System.lineSeparator()}"
        } else {
          if (i > 1) {
            if (line.startsWith("|")) {
              newTable = newTable + s"|${System.lineSeparator()}"
            } else {
              newTable = newTable + "<br>"
            }
          }
          newTable = newTable + line
        }

        i = i + 1
      }

      newTable = newTable + s"|${System.lineSeparator()}"

      val allMatch = matcher.group(0)
      ret = ret.replace(allMatch, newTable)
    }

    ret
  }

}
