package org.mule.weave.v2.utils

import org.mule.weave.v2.codegen.StringCodeWriter
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.parser.phase.DependencyGraph

import scala.collection.mutable

object DependencyGraphDotEmitter {

  def print(dependencyGraph: DependencyGraph): String = {

    val ids: mutable.HashMap[String, String] = mutable.HashMap()

    val writer: StringCodeWriter = new StringCodeWriter()
    writer.println(s"digraph ${"DependencyGraph".replaceAll("\"", "\'")} {")
    writer.indent()
    writer.println("  node [fixedsize=shape fontsize=10]")

    val modules = mutable.Set[NameIdentifier]()

    dependencyGraph
      .modules()
      .foreach((module) => {
        modules.+=(module)

        dependencyGraph
          .getDependants(module)
          .foreach((dependant) => {
            modules.+=(dependant)
          })
      })

    modules.foreach((module) => {
      val idStr = id(module)
      ids.put(module.fullQualifiedName(), idStr)
      writer.println(s" $idStr [label=" + "\"" + module.fullQualifiedName().replaceAll("\"", "\'") + "\"" + "];")
    })

    dependencyGraph
      .modules()
      .foreach((module) => {
        dependencyGraph
          .getDependants(module)
          .foreach((dependant) => {
            writer.println(s"   ${ids(module.fullQualifiedName())} -> ${ids(dependant.fullQualifiedName())}")
          })
      })

    writer.printIndent()
    writer.dedent()
    writer.println()
    writer.println("}")
    writer.codeContent()
  }

  def id(node: NameIdentifier): String = {
    Math.abs(System.identityHashCode(node)).toString
  }

}
