package org.mule.weave.v2.editor

import org.mule.weave.v2.parser.location.WeaveLocation

case class SymbolInformation(name: String, kind: Int, location: WeaveLocation, containerName: Option[String] = None)

object SymbolKind {
  val File = 1
  val Module = 2
  val Namespace = 3
  val Package = 4
  val Class = 5
  val Method = 6
  val Property = 7
  val Field = 8
  val Constructor = 9
  val Enum = 10
  val Interface = 11
  val Function = 12
  val Variable = 13
  val Constant = 14
  val String = 15
  val Number = 16
  val Boolean = 17
  val Array = 18
}