package org.mule.weave.v2.parser.ast.module

import org.mule.weave.v2.api.tooling.ast.DWAstNodeKind
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.DirectivesCapableNode
import org.mule.weave.v2.parser.ast.header.directives.DirectiveNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier

case class ModuleNode(var name: NameIdentifier, var elements: Seq[DirectiveNode]) extends AstNode with DirectivesCapableNode {
  override def children(): Seq[AstNode] = elements

  override def directives: Seq[DirectiveNode] = elements
  override protected def doClone(): AstNode = {
    copy(name.cloneAst(), elements.map(_.cloneAst()))
  }

  override def getKind(): String = DWAstNodeKind.MODULE_NODE
}
