package org.mule.weave.v2.parser.ast.updates

import org.mule.weave.v2.api.tooling.ast.DWAstNodeKind
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.Children
import org.mule.weave.v2.parser.ast.ExpressionAstNode
import org.mule.weave.v2.parser.ast.annotation.AnnotationNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier

case class UpdateNode(expression: AstNode, matchers: UpdateExpressionsNode, var codeAnnotations: Seq[AnnotationNode] = Seq()) extends ExpressionAstNode {

  override def children(): Seq[AstNode] = Children(expression, matchers).++=(codeAnnotations).result()

  override protected def doClone(): AstNode = UpdateNode(expression.cloneAst(), matchers.cloneAst(), codeAnnotations.map(_.cloneAst()))

  /**
    * Sets the annotations to this node
    *
    * @param annotations The list of annotations
    */
  override def setAnnotations(annotations: Seq[AnnotationNode]): Unit = {
    this.codeAnnotations = annotations
  }

  override def getKind(): String = DWAstNodeKind.UPDATE_NODE
}

case class UpdateExpressionsNode(expressions: Seq[UpdateExpressionNode]) extends AstNode {

  override def children(): Seq[AstNode] = expressions

  override protected def doClone(): AstNode = {
    UpdateExpressionsNode(expressions.map(_.cloneAst()))
  }

  override def cloneAst(): UpdateExpressionsNode = super.cloneAst().asInstanceOf[UpdateExpressionsNode]

  override def getKind(): String = DWAstNodeKind.UPDATE_EXPRESSIONS_NODE
}

case class UpdateExpressionNode(name: NameIdentifier, indexId: NameIdentifier, selector: AstNode, forceCreate: Boolean, condition: Option[AstNode], updateExpression: AstNode) extends AstNode {

  override def children(): Seq[AstNode] = Children(selector, indexId, updateExpression, name).+=(condition).result()

  override def cloneAst(): UpdateExpressionNode = super.cloneAst().asInstanceOf[UpdateExpressionNode]

  override protected def doClone(): AstNode = UpdateExpressionNode(name.cloneAst(), indexId.cloneAst(), selector.cloneAst(), forceCreate, condition.map(_.cloneAst()), updateExpression.cloneAst())

  override def getKind(): String = DWAstNodeKind.UPDATE_EXPRESSION_NODE
}

sealed trait UpdateSelectorNode extends AstNode {
  override def cloneAst(): UpdateSelectorNode = super.cloneAst().asInstanceOf[UpdateSelectorNode]

  def child: Option[AstNode]

  def selector: AstNode
}

case class FieldNameUpdateSelectorNode(selector: AstNode, child: Option[AstNode]) extends UpdateSelectorNode {

  override def children(): Seq[AstNode] = Children(selector).+=(child).result()

  override protected def doClone(): AstNode = {
    FieldNameUpdateSelectorNode(selector.cloneAst(), child.map(_.cloneAst()))
  }

  override def getKind(): String = DWAstNodeKind.FIELD_NAME_UPDATE_SELECTOR_NODE
}

case class MultiFieldNameUpdateSelectorNode(selector: AstNode, child: Option[AstNode]) extends UpdateSelectorNode {

  override def children(): Seq[AstNode] = Children(selector).+=(child).result()

  override protected def doClone(): AstNode = {
    MultiFieldNameUpdateSelectorNode(selector.cloneAst(), child.map(_.cloneAst()))
  }

  override def getKind(): String = DWAstNodeKind.MULTI_FIELD_NAME_UPDATE_SELECTOR_NODE
}

case class AttributeNameUpdateSelectorNode(selector: AstNode, child: Option[AstNode]) extends UpdateSelectorNode {

  override def children(): Seq[AstNode] = Children(selector).+=(child).result()

  override protected def doClone(): AstNode = {
    AttributeNameUpdateSelectorNode(selector.cloneAst(), child.map(_.cloneAst()))
  }

  override def getKind(): String = DWAstNodeKind.ATTRIBUTE_NAME_UPDATE_SELECTOR_NODE
}

case class ArrayIndexUpdateSelectorNode(selector: AstNode, child: Option[AstNode]) extends UpdateSelectorNode {

  override def children(): Seq[AstNode] = Children(selector).+=(child).result()

  override protected def doClone(): AstNode = {
    ArrayIndexUpdateSelectorNode(selector.cloneAst(), child.map(_.cloneAst()))
  }

  override def getKind(): String = DWAstNodeKind.ARRAY_INDEX_UPDATE_SELECTOR_NODE
}