package org.mule.weave.v2.parser.phase

import java.io.PrintWriter
import java.io.StringWriter

import org.mule.weave.v2.parser.Message
import org.mule.weave.v2.parser.MessageKind
import org.mule.weave.v2.parser.TypePhaseCategory
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.exception.LocatableException
import org.mule.weave.v2.parser.location.{ UnknownLocation, WeaveLocation }
import org.mule.weave.v2.ts.TypeGraph
import org.mule.weave.v2.ts.WeaveTypeResolutionContext

class ReverseTypeCheckingPhase[T <: AstNode]() extends CompilationPhase[TypeCheckingResult[T], TypeCheckingResult[T]] {

  override def doCall(input: TypeCheckingResult[T], ctx: ParsingContext): PhaseResult[TypeCheckingResult[T]] = {

    val dataGraph: TypeGraph = input.typeGraph
    try {
      val context: WeaveTypeResolutionContext = new WeaveTypeResolutionContext(dataGraph)
      context.newReverseExecutorWithContext(input.scope, dataGraph, ctx).run()
      SuccessResult(new TypeCheckingResult(input.input, input.astNode, input.scope, dataGraph), ctx)
    } catch {
      case lm: LocatableException => {
        ctx.messageCollector.error(Message(MessageKind.UNEXPECTED_EXCEPTION_MESSAGE_KIND, lm.getMessage, TypePhaseCategory), lm.location.asInstanceOf[WeaveLocation])
        FailureResult(ctx)
      }
      case lm: Throwable =>
        val stackTrace = new StringWriter()
        lm.printStackTrace(new PrintWriter(stackTrace))
        ctx.messageCollector.error(Message(MessageKind.UNEXPECTED_EXCEPTION_MESSAGE_KIND, "Exception while running reverse type check " + lm.getClass.getName + " :\n" + stackTrace.toString, TypePhaseCategory), UnknownLocation)
        FailureResult(ctx)
    }
  }

}

