package org.mule.weave.v2.ts

import org.mule.weave.v2.parser.InvalidReferenceMessage
import org.mule.weave.v2.parser.MaxTypeGraphExecution
import org.mule.weave.v2.parser.Message
import org.mule.weave.v2.parser.MessageCollector
import org.mule.weave.v2.parser.TypeCoercedMessage
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.AstNodeHelper
import org.mule.weave.v2.parser.ast.CommentNode
import org.mule.weave.v2.parser.ast.annotation.AnnotationCapableNode
import org.mule.weave.v2.parser.ast.annotation.AnnotationNode
import org.mule.weave.v2.parser.ast.conditional.IfNode
import org.mule.weave.v2.parser.ast.conditional.UnlessNode
import org.mule.weave.v2.parser.ast.functions._
import org.mule.weave.v2.parser.ast.header.directives.ErrorDirectiveNode
import org.mule.weave.v2.parser.ast.header.directives._
import org.mule.weave.v2.parser.ast.logical.AndNode
import org.mule.weave.v2.parser.ast.logical.OrNode
import org.mule.weave.v2.parser.ast.module.ModuleNode
import org.mule.weave.v2.parser.ast.operators.OpNode
import org.mule.weave.v2.parser.ast.patterns._
import org.mule.weave.v2.parser.ast.structure._
import org.mule.weave.v2.parser.ast.types.DynamicReturnTypeNode
import org.mule.weave.v2.parser.ast.types.TypeReferenceNode
import org.mule.weave.v2.parser.ast.types.WeaveTypeNode
import org.mule.weave.v2.parser.ast.updates.UpdateExpressionNode
import org.mule.weave.v2.parser.ast.updates.UpdateNode
import org.mule.weave.v2.parser.ast.updates.UpdateSelectorNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.parser.ast.variables.VariableReferenceNode
import org.mule.weave.v2.parser.exception.ParseException
import org.mule.weave.v2.parser.location.UnknownLocation
import org.mule.weave.v2.parser.location.WeaveLocation
import org.mule.weave.v2.parser.phase.ParsingContext
import org.mule.weave.v2.parser.phase.PhaseResult
import org.mule.weave.v2.parser.phase.TypeCheckingResult
import org.mule.weave.v2.parser.phase.listener.ParsingNotificationManager
import org.mule.weave.v2.scope.Reference
import org.mule.weave.v2.scope.ScopesNavigator
import org.mule.weave.v2.ts.WeaveTypeCloneHelper.copyLocation
import org.mule.weave.v2.ts.WeaveTypeTraverse.equalsWith
import org.mule.weave.v2.ts.resolvers.LiteralTypeResolver
import org.mule.weave.v2.ts.resolvers.PassThroughTypeResolver
import org.mule.weave.v2.ts.resolvers.PassThroughWithDocs
import org.mule.weave.v2.ts.resolvers.RetyperResolver
import org.mule.weave.v2.ts.resolvers.UnknownTypeResolver
import org.mule.weave.v2.utils.{ ConcurrentIdentityHashMap, IdentityHashMap }

import scala.collection._
import scala.collection.mutable.ArrayBuffer

/**
  * Represents a type propagation graph
  *
  * @param nodes       The nodes in the graph
  * @param parentGraph The parent graph
  */
class TypeGraph(val nodes: mutable.Seq[TypeNode], val parentGraph: Option[TypeGraph]) {

  private val _subGraphs: ArrayBuffer[(FunctionNode, ArrayBuffer[(Seq[WeaveType], TypeGraph)])] = ArrayBuffer()

  private lazy val nodesIndex: ConcurrentIdentityHashMap[AstNode, TypeNode] = {
    val identityHashMap = new ConcurrentIdentityHashMap[AstNode, TypeNode]()
    var i = 0;
    while (i < nodes.length) {
      identityHashMap.put(nodes(i).astNode, nodes(i))
      i = i + 1;

    }
    identityHashMap
  }

  //Set Parent to the children
  nodes.foreach(_.withParent(this))

  def rootGraph(): TypeGraph = {
    parentGraph.map(_.rootGraph()).getOrElse(this)
  }

  private def subGraphs(): Seq[TypeGraph] = {
    _subGraphs.flatMap((functionNodePair) => {
      functionNodePair._2.map((typeGraphPair) => {
        typeGraphPair._2
      })
    })
  }

  def subGraphsWithLabel(): Seq[(TypeGraph, String)] = {
    _subGraphs.flatMap((functionNodePair) => {
      functionNodePair._2.map((typeGraphPair) => {
        (typeGraphPair._2, typeGraphPair._1.mkString(","))
      })
    })
  }

  def removeFunctionSubGraph(functionNode: FunctionNode, parameterTypes: Seq[WeaveType]): Unit = {
    getFunctionSubGraphs(functionNode) match {
      case Some(x) => {
        x.find((graph) => matches(graph._1, parameterTypes)).map((function) => x.-=(function))
      }
      case None =>
    }
  }

  def getFunctionSubGraph(functionNode: FunctionNode, parameterTypes: Seq[WeaveType]): Option[TypeGraph] = {
    getFunctionSubGraphs(functionNode) match {
      case Some(x) => {
        x.find((graph) => matches(graph._1, parameterTypes)).map(_._2)
      }
      case None => None
    }
  }

  def getFunctionSubGraphs(functionNode: FunctionNode): Option[ArrayBuffer[(Seq[WeaveType], TypeGraph)]] = {
    _subGraphs.find(_._1 eq functionNode).map(_._2)
  }

  def addFunctionSubGraph(functionNode: FunctionNode, parameterTypes: Seq[WeaveType], graph: TypeGraph): Unit = {
    getFunctionSubGraphs(functionNode) match {
      case Some(x) => {
        x.+=((parameterTypes, graph))
      }
      case None => {
        val tuple = (functionNode, ArrayBuffer((parameterTypes, graph)))
        _subGraphs.+=(tuple)
      }
    }
  }

  private def matches(expected: Seq[WeaveType], actual: Seq[WeaveType]): Boolean = {
    if (expected.size == actual.size) {
      expected.zip(actual).forall((t) => equalsWith(t._1, t._2))
    } else {
      false
    }
  }

  def findLocalNode(astNode: AstNode): Option[TypeNode] = {
    val maybeNode = nodesIndex
      .get(astNode)
      .orElse({
        parentGraph
          .flatMap((typeGraph) => {
            typeGraph.findLocalNode(astNode)
          })
      })

    maybeNode
  }

  def findNode(astNode: AstNode): Option[TypeNode] = {

    findLocalNode(astNode) match {
      case None => {
        var ret: Option[TypeNode] = None
        var i = 0
        val sg = subGraphs()
        val subGraphsCount = sg.length
        while (i < subGraphsCount && ret.isEmpty) {
          val foundNode = sg(i).findNode(astNode)
          if (foundNode.isDefined) {
            ret = foundNode
          }
          i += 1
        }
        ret
      }
      case found => found
    }

  }

  def dispose(): Unit = {
    nodes.foreach(_.dispose())
    _subGraphs.foreach(_._2.foreach(_._2.dispose()))
  }
}

object TypeGraph {
  def apply(parsingContext: ParsingContext, scopesNavigator: ScopesNavigator, documentNode: AstNode, inputs: Map[String, Option[WeaveType]] = Map(), expectedOutput: Option[WeaveType] = None, parentGraph: Option[TypeGraph] = None): TypeGraph = {
    new TypeGraphBuilder(parsingContext, scopesNavigator, parentGraph, inputs, expectedOutput).build(documentNode)
  }

  def apply(parsingContext: ParsingContext, parentGraph: TypeGraph, scopesNavigator: ScopesNavigator, functionNode: FunctionNode, invocationParameters: Seq[WeaveType], returnType: Option[WeaveType], resolver: ReferenceResolver): TypeGraph = {
    new TypeGraphBuilder(parsingContext, scopesNavigator, Some(parentGraph), expectedOutput = returnType).build(functionNode, invocationParameters, resolver.cleanResolver())
  }
}
