package org.mule.weave.v2.ts.resolvers

import org.mule.weave.v2.sdk.SystemFunctionDefinitions
import org.mule.weave.v2.ts.Edge
import org.mule.weave.v2.ts.EdgeLabels
import org.mule.weave.v2.ts.TypeNode
import org.mule.weave.v2.ts.WeaveType
import org.mule.weave.v2.ts.WeaveTypeResolutionContext
import org.mule.weave.v2.ts.WeaveTypeResolver
import org.mule.weave.v2.ts.resolvers.FunctionCallNodeResolver.calculateExpectedTypeByParameter

import scala.collection.Seq

object ArrayIndexUpdateSelectorResolver extends WeaveTypeResolver {
  override def resolveReturnType(node: TypeNode, ctx: WeaveTypeResolutionContext): Option[WeaveType] = {
    val nameToSelect: WeaveType = node.incomingType(EdgeLabels.PROPERTY_SELECTOR).get
    val selectOver: WeaveType = node.incomingType(EdgeLabels.VALUE).get
    FunctionCallNodeResolver.resolveReturnType(SystemFunctionDefinitions.indexSelectorOps, Seq(selectOver, nameToSelect), Seq(), node, ctx)
  }

  override def resolveExpectedType(node: TypeNode, incomingExpectedType: Option[WeaveType], ctx: WeaveTypeResolutionContext): Seq[(Edge, WeaveType)] = {
    val paramsTypes: Seq[WeaveType] = calculateExpectedTypeByParameter(SystemFunctionDefinitions.indexSelectorOps, incomingExpectedType, ctx)
    node.incomingEdges().zip(paramsTypes)
  }
}
