package org.mule.weave.v2.utils

/**
  * A synchronized wrapper around IdentityHashMap
  */
final class SynchronizedIdentityHashMap[K <: AnyRef, V]() {

  private val internalMap = new IdentityHashMap[K, V]()

  def get(key: K): Option[V] = {
    this.synchronized({
      internalMap.get(key)
    })
  }

  def put(key: K, value: V): Option[V] = {
    this.synchronized({
      internalMap.put(key, value)
    })
  }

  def getOrElseUpdate(key: K, value: => V): V = {
    this.synchronized({
      internalMap.getOrElseUpdate(key, value)
    })
  }

  def find(predicate: ((K, V)) => Boolean): Option[(K, V)] = {
    this.synchronized({
      internalMap.find(predicate)
    })
  }

  def contains(key: K): Boolean = {
    this.synchronized({
      internalMap.contains(key)
    })
  }
}

object SynchronizedIdentityHashMap {
  def apply[A <: AnyRef, B]() = new SynchronizedIdentityHashMap[A, B]()
}
