/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.editor.composer;

import java.io.Serializable;
import org.mule.weave.v2.codegen.CodeGenerator$;
import org.mule.weave.v2.editor.ValidationMessage;
import org.mule.weave.v2.editor.ValidationMessage$;
import org.mule.weave.v2.editor.composer.ComposerExpression;
import org.mule.weave.v2.editor.composer.ComposerExpressionNode;
import org.mule.weave.v2.editor.composer.ComposerExpressionToken;
import org.mule.weave.v2.editor.composer.ComposerExpressionTokenKind$;
import org.mule.weave.v2.editor.composer.ComposerValidationMessages;
import org.mule.weave.v2.parser.MappingParser$;
import org.mule.weave.v2.parser.Message;
import org.mule.weave.v2.parser.MessageCollector;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.ast.structure.DocumentNode;
import org.mule.weave.v2.parser.ast.structure.StringInterpolationNode;
import org.mule.weave.v2.parser.ast.structure.StringNode;
import org.mule.weave.v2.parser.location.WeaveLocation;
import org.mule.weave.v2.parser.phase.ParsingContext;
import org.mule.weave.v2.parser.phase.ParsingResult;
import org.mule.weave.v2.parser.phase.PhaseResult;
import org.mule.weave.v2.sdk.WeaveResource$;
import org.mule.weave.v2.utils.StringEscapeHelper$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001a4Aa\u0002\u0005\u0001+!)A\u0004\u0001C\u0001;!)\u0001\u0005\u0001C\u0001C!)\u0011\t\u0001C\u0001\u0005\")\u0011\n\u0001C\u0001\u0015\")!\f\u0001C\u00057\")\u0001\u000e\u0001C\u0005S\nA2i\\7q_N,'/\u0012=qe\u0016\u001c8/[8o!\u0006\u00148/\u001a:\u000b\u0005%Q\u0011\u0001C2p[B|7/\u001a:\u000b\u0005-a\u0011AB3eSR|'O\u0003\u0002\u000e\u001d\u0005\u0011aO\r\u0006\u0003\u001fA\tQa^3bm\u0016T!!\u0005\n\u0002\t5,H.\u001a\u0006\u0002'\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0006\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005q\u0002CA\u0010\u0001\u001b\u0005A\u0011A\u0006;pW\u0016t\u0017N_3UKb$X\t\u001f9sKN\u001c\u0018n\u001c8\u0015\t\tBSg\u000e\t\u0004/\r*\u0013B\u0001\u0013\u0019\u0005\u0019y\u0005\u000f^5p]B\u0011qDJ\u0005\u0003O!\u0011!cQ8na>\u001cXM]#yaJ,7o]5p]\")\u0011F\u0001a\u0001U\u0005QQ\r\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005-\u0012dB\u0001\u00171!\ti\u0003$D\u0001/\u0015\tyC#\u0001\u0004=e>|GOP\u0005\u0003ca\ta\u0001\u0015:fI\u00164\u0017BA\u001a5\u0005\u0019\u0019FO]5oO*\u0011\u0011\u0007\u0007\u0005\u0006m\t\u0001\rAK\u0001\u0005]\u0006lW\rC\u00039\u0005\u0001\u0007\u0011(\u0001\bqCJ\u001c\u0018N\\4D_:$X\r\u001f;\u0011\u0005izT\"A\u001e\u000b\u0005qj\u0014!\u00029iCN,'B\u0001 \r\u0003\u0019\u0001\u0018M]:fe&\u0011\u0001i\u000f\u0002\u000f!\u0006\u00148/\u001b8h\u0007>tG/\u001a=u\u0003!1\u0018\r\\5eCR,G\u0003B\"G\u000f\"\u0003\"a\b#\n\u0005\u0015C!AG\"p[B|7/\u001a:WC2LG-\u0019;j_:lUm]:bO\u0016\u001c\b\"B\u0015\u0004\u0001\u0004Q\u0003\"\u0002\u001c\u0004\u0001\u0004Q\u0003\"\u0002\u001d\u0004\u0001\u0004I\u0014\u0001C4f]\u0016\u0014\u0018\r^3\u0015\u0007)Z\u0015\fC\u0003M\t\u0001\u0007Q*\u0001\u0005fY\u0016lWM\u001c;t!\rq5K\u0016\b\u0003\u001fFs!!\f)\n\u0003eI!A\u0015\r\u0002\u000fA\f7m[1hK&\u0011A+\u0016\u0002\u0004'\u0016\f(B\u0001*\u0019!\tyr+\u0003\u0002Y\u0011\t92i\\7q_N,'/\u0012=qe\u0016\u001c8/[8o)>\\WM\u001c\u0005\u0006q\u0011\u0001\r!O\u0001\u000eO\u0016tWM]1uK6{G-\u001a7\u0015\u0005q\u0003\u0007c\u0001(T;B\u0011qDX\u0005\u0003?\"\u0011acQ8na>\u001cXM]#yaJ,7o]5p]:{G-\u001a\u0005\u0006C\u0016\u0001\rAY\u0001\bCN$hj\u001c3f!\t\u0019g-D\u0001e\u0015\t)W(A\u0002bgRL!a\u001a3\u0003\u000f\u0005\u001bHOT8eK\u0006aBo\\\"p[B|7/\u001a:WC2LG-\u0019;j_:lUm]:bO\u0016\u001cHCA\"k\u0011\u0015Yg\u00011\u0001m\u0003\u00151\u0018\r\\;f!\rQTn\\\u0005\u0003]n\u00121\u0002\u00155bg\u0016\u0014Vm];miB\u0019!\b\u001d:\n\u0005E\\$!\u0004)beNLgn\u001a*fgVdG\u000f\u0005\u0002tm6\tAO\u0003\u0002vI\u0006I1\u000f\u001e:vGR,(/Z\u0005\u0003oR\u0014A\u0002R8dk6,g\u000e\u001e(pI\u0016\u0004")
public class ComposerExpressionParser {
    public Option<ComposerExpression> tokenizeTextExpression(String expression, String name, ParsingContext parsingContext) {
        None$ none$;
        PhaseResult<ParsingResult<DocumentNode>> value = MappingParser$.MODULE$.parse(MappingParser$.MODULE$.parsingPhase(), WeaveResource$.MODULE$.apply(name, expression), parsingContext);
        if (value.hasResult()) {
            ParsingResult<DocumentNode> theResult = value.getResult();
            none$ = new Some((Object)new ComposerExpression(this.generateModel(theResult.astNode().root())));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public ComposerValidationMessages validate(String expression, String name, ParsingContext parsingContext) {
        PhaseResult<ParsingResult<DocumentNode>> value = MappingParser$.MODULE$.parse(MappingParser$.MODULE$.typeCheckPhase(), WeaveResource$.MODULE$.apply(name, expression), parsingContext);
        return this.toComposerValidationMessages(value);
    }

    public String generate(Seq<ComposerExpressionToken> elements, ParsingContext parsingContext) {
        Seq astNodes;
        return elements.isEmpty() ? "" : ((astNodes = (Seq)elements.map((Function1 & Serializable & scala.Serializable)element -> {
            AstNode astNode;
            String string = element.kind();
            String string2 = ComposerExpressionTokenKind$.MODULE$.TEXT();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                StringNode node = new StringNode(StringEscapeHelper$.MODULE$.escapeString(element.text(), '\"', false));
                Object object = elements.size() == 1 ? node.withQuotation('\"') : BoxedUnit.UNIT;
                astNode = node;
            } else {
                String expressionText = element.text();
                PhaseResult<ParsingResult<DocumentNode>> value = MappingParser$.MODULE$.parse(MappingParser$.MODULE$.parsingPhase(), WeaveResource$.MODULE$.apply("expression", expressionText), parsingContext);
                astNode = value.getResult().astNode().root();
            }
            return astNode;
        }, Seq$.MODULE$.canBuildFrom())).size() > 1 ? CodeGenerator$.MODULE$.generate(new StringInterpolationNode((Seq<AstNode>)astNodes)) : CodeGenerator$.MODULE$.generate((AstNode)astNodes.head()));
    }

    private Seq<ComposerExpressionNode> generateModel(AstNode astNode) {
        Seq seq;
        AstNode astNode2 = astNode;
        if (astNode2 instanceof StringNode) {
            StringNode stringNode = (StringNode)astNode2;
            String expression = StringEscapeHelper$.MODULE$.unescapeString(stringNode.literalValue(), BoxesRunTime.unboxToChar((Object)stringNode.quotedBy().getOrElse((Function0)(JFunction0.mcC.sp & Serializable & scala.Serializable)() -> '\"')));
            ComposerExpressionToken part = new ComposerExpressionToken(ComposerExpressionTokenKind$.MODULE$.TEXT(), expression);
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ComposerExpressionNode[]{new ComposerExpressionNode(part, astNode)}));
        } else if (astNode2 instanceof StringInterpolationNode) {
            StringInterpolationNode stringInterpolationNode = (StringInterpolationNode)astNode2;
            seq = (Seq)stringInterpolationNode.elements().flatMap((Function1 & Serializable & scala.Serializable)nd -> this.generateModel((AstNode)nd), Seq$.MODULE$.canBuildFrom());
        } else {
            ComposerExpressionToken expressionPart = new ComposerExpressionToken(ComposerExpressionTokenKind$.MODULE$.PILL(), CodeGenerator$.MODULE$.generate(astNode2));
            ComposerExpressionNode composerNode = new ComposerExpressionNode(expressionPart, astNode);
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ComposerExpressionNode[]{composerNode}));
        }
        return seq;
    }

    private ComposerValidationMessages toComposerValidationMessages(PhaseResult<ParsingResult<DocumentNode>> value) {
        MessageCollector messageCollector = value.messages();
        Seq<Tuple2<WeaveLocation, Message>> errorMessages = messageCollector.errorMessages();
        Seq<Tuple2<WeaveLocation, Message>> warningMessages = messageCollector.warningMessages();
        Seq warningValidationMessages = (Seq)warningMessages.map((Function1 & Serializable & scala.Serializable)pair -> new ValidationMessage((WeaveLocation)pair._1(), (Message)pair._2(), ValidationMessage$.MODULE$.apply$default$3()), Seq$.MODULE$.canBuildFrom());
        Seq errorValidationMessages = (Seq)errorMessages.map((Function1 & Serializable & scala.Serializable)pair -> new ValidationMessage((WeaveLocation)pair._1(), (Message)pair._2(), ValidationMessage$.MODULE$.apply$default$3()), Seq$.MODULE$.canBuildFrom());
        ComposerValidationMessages composerValidationMessages = new ComposerValidationMessages((Seq<ValidationMessage>)warningValidationMessages, (Seq<ValidationMessage>)errorValidationMessages);
        return composerValidationMessages;
    }
}

