/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.formatting;

import java.io.Serializable;
import org.mule.weave.v2.editor.WeaveTextDocument;
import org.mule.weave.v2.formatting.FormattingOptions;
import org.mule.weave.v2.grammar.AdditionOpId$;
import org.mule.weave.v2.grammar.AsOpId$;
import org.mule.weave.v2.grammar.AttributeValueSelectorOpId$;
import org.mule.weave.v2.grammar.BinaryOpIdentifier;
import org.mule.weave.v2.grammar.DivisionOpId$;
import org.mule.weave.v2.grammar.DynamicSelectorOpId$;
import org.mule.weave.v2.grammar.EqOpId$;
import org.mule.weave.v2.grammar.FilterSelectorOpId$;
import org.mule.weave.v2.grammar.GreaterThanOpId$;
import org.mule.weave.v2.grammar.IsOpId$;
import org.mule.weave.v2.grammar.LeftShiftOpId$;
import org.mule.weave.v2.grammar.LessOrEqualThanOpId$;
import org.mule.weave.v2.grammar.LessThanOpId$;
import org.mule.weave.v2.grammar.MultiAttributeValueSelectorOpId$;
import org.mule.weave.v2.grammar.MultiValueSelectorOpId$;
import org.mule.weave.v2.grammar.MultiplicationOpId$;
import org.mule.weave.v2.grammar.NotEqOpId$;
import org.mule.weave.v2.grammar.ObjectKeyValueSelectorOpId$;
import org.mule.weave.v2.grammar.RangeSelectorOpId$;
import org.mule.weave.v2.grammar.RightShiftOpId$;
import org.mule.weave.v2.grammar.SchemaValueSelectorOpId$;
import org.mule.weave.v2.grammar.SimilarOpId$;
import org.mule.weave.v2.grammar.SubtractionOpId$;
import org.mule.weave.v2.grammar.ValueSelectorOpId$;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.ast.AstNodeHelper$;
import org.mule.weave.v2.parser.ast.ContainerAstNode;
import org.mule.weave.v2.parser.ast.WeaveLocationCapable;
import org.mule.weave.v2.parser.ast.annotation.AnnotationCapableNode;
import org.mule.weave.v2.parser.ast.annotation.AnnotationNode;
import org.mule.weave.v2.parser.ast.conditional.IfNode;
import org.mule.weave.v2.parser.ast.conditional.UnlessNode;
import org.mule.weave.v2.parser.ast.functions.DoBlockNode;
import org.mule.weave.v2.parser.ast.functions.FunctionCallNode;
import org.mule.weave.v2.parser.ast.functions.FunctionNode;
import org.mule.weave.v2.parser.ast.functions.FunctionParameter;
import org.mule.weave.v2.parser.ast.header.HeaderNode;
import org.mule.weave.v2.parser.ast.header.directives.AnnotationDirectiveNode;
import org.mule.weave.v2.parser.ast.header.directives.FunctionDirectiveNode;
import org.mule.weave.v2.parser.ast.header.directives.TypeDirective;
import org.mule.weave.v2.parser.ast.header.directives.VarDirective;
import org.mule.weave.v2.parser.ast.module.ModuleNode;
import org.mule.weave.v2.parser.ast.operators.BinaryOpNode;
import org.mule.weave.v2.parser.ast.patterns.PatternExpressionsNode;
import org.mule.weave.v2.parser.ast.structure.ArrayNode;
import org.mule.weave.v2.parser.ast.structure.AttributesNode;
import org.mule.weave.v2.parser.ast.structure.DocumentNode;
import org.mule.weave.v2.parser.ast.structure.KeyValuePairNode;
import org.mule.weave.v2.parser.ast.structure.NameValuePairNode;
import org.mule.weave.v2.parser.ast.structure.ObjectNode;
import org.mule.weave.v2.parser.ast.structure.schema.SchemaNode;
import org.mule.weave.v2.parser.ast.types.KeyTypeNode;
import org.mule.weave.v2.parser.ast.types.KeyValueTypeNode;
import org.mule.weave.v2.parser.ast.types.NameValueTypeNode;
import org.mule.weave.v2.parser.ast.types.ObjectTypeNode;
import org.mule.weave.v2.parser.ast.types.TypeParametersListNode;
import org.mule.weave.v2.parser.ast.types.TypeReferenceNode;
import org.mule.weave.v2.parser.location.Position;
import org.mule.weave.v2.parser.location.SimpleParserPosition;
import org.mule.weave.v2.parser.location.WeaveLocation;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;

@ScalaSignature(bytes="\u0006\u0001\teb\u0001\u0002\u001a4\u0001yB\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\u0006\u0015\u0002!\ta\u0013\u0005\b\u001d\u0002\u0011\r\u0011\"\u0001P\u0011\u0019A\u0006\u0001)A\u0005!\"9\u0011\f\u0001b\u0001\n\u0003y\u0005B\u0002.\u0001A\u0003%\u0001\u000bC\u0004\\\u0001\t\u0007I\u0011A(\t\rq\u0003\u0001\u0015!\u0003Q\u0011\u001di\u0006A1A\u0005\u0002=CaA\u0018\u0001!\u0002\u0013\u0001\u0006bB0\u0001\u0005\u0004%\ta\u0014\u0005\u0007A\u0002\u0001\u000b\u0011\u0002)\t\u000f\u0005\u0004!\u0019!C\u0001\u001f\"1!\r\u0001Q\u0001\nACqa\u0019\u0001C\u0002\u0013\u0005q\n\u0003\u0004e\u0001\u0001\u0006I\u0001\u0015\u0005\bK\u0002\u0011\r\u0011\"\u0001P\u0011\u00191\u0007\u0001)A\u0005!\"9q\r\u0001b\u0001\n\u0003y\u0005B\u00025\u0001A\u0003%\u0001\u000bC\u0004j\u0001\t\u0007I\u0011A(\t\r)\u0004\u0001\u0015!\u0003Q\u0011\u001dY\u0007A1A\u0005\u0002=Ca\u0001\u001c\u0001!\u0002\u0013\u0001\u0006bB7\u0001\u0005\u0004%\ta\u0014\u0005\u0007]\u0002\u0001\u000b\u0011\u0002)\t\u000f=\u0004!\u0019!C\u0001\u001f\"1\u0001\u000f\u0001Q\u0001\nACq!\u001d\u0001C\u0002\u0013\u0005!\u000f\u0003\u0004\u0000\u0001\u0001\u0006Ia\u001d\u0005\t\u0003\u0003\u0001!\u0019!C\u0001e\"9\u00111\u0001\u0001!\u0002\u0013\u0019\bbBA\u0003\u0001\u0011\u0005\u0011q\u0001\u0005\b\u0003c\u0001A\u0011AA\u001a\u0011\u001d\t)\u0001\u0001C\u0005\u0003\u007fAq!!\u0014\u0001\t\u0013\ty\u0005C\u0004\u0002h\u0001!I!!\u001b\t\u000f\u00055\u0004\u0001\"\u0001\u0002p!9\u0011q\u0014\u0001\u0005\n\u0005\u0005\u0006bBA\u0003\u0001\u0011%\u0011Q\u0016\u0005\b\u0003s\u0003A\u0011BA^\u0011\u001d\t\u0019\u000e\u0001C\u0005\u0003+Dq!!9\u0001\t\u0013\t\u0019\u000fC\u0004\u0002n\u0001!I!a;\t\u000f\u00055\u0004\u0001\"\u0003\u0002x\"9!\u0011\u0003\u0001\u0005\n\tM\u0001b\u0002B\u000e\u0001\u0011%!Q\u0004\u0005\b\u0005O\u0001A\u0011\u0001B\u0015\u0011\u001d\u0011Y\u0002\u0001C\u0005\u0005_\u0011\u0011CR8s[\u0006$H/\u001b8h'\u0016\u0014h/[2f\u0015\t!T'\u0001\u0006g_Jl\u0017\r\u001e;j]\u001eT!AN\u001c\u0002\u0005Y\u0014$B\u0001\u001d:\u0003\u00159X-\u0019<f\u0015\tQ4(\u0001\u0003nk2,'\"\u0001\u001f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001y\u0004C\u0001!D\u001b\u0005\t%\"\u0001\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\u000b%AB!osJ+g-A\u0004paRLwN\\:\u0011\u0005\u001dCU\"A\u001a\n\u0005%\u001b$!\u0005$pe6\fG\u000f^5oO>\u0003H/[8og\u00061A(\u001b8jiz\"\"\u0001T'\u0011\u0005\u001d\u0003\u0001\"B#\u0003\u0001\u00041\u0015a\u0004+Z!\u0016{6+\u0012)B%\u0006#\u0016j\u0014(\u0016\u0003A\u0003\"!\u0015,\u000e\u0003IS!a\u0015+\u0002\t1\fgn\u001a\u0006\u0002+\u0006!!.\u0019<b\u0013\t9&K\u0001\u0004TiJLgnZ\u0001\u0011)f\u0003ViX*F!\u0006\u0013\u0016\tV%P\u001d\u0002\nAcS#Z?Z\u000bE*V#`'\u0016\u0003\u0016IU!U\u0013>s\u0015!F&F3~3\u0016\tT+F?N+\u0005+\u0011*B)&{e\nI\u0001\u000e\u000bF{6+\u0012)B%\u0006#\u0016j\u0014(\u0002\u001d\u0015\u000bvlU#Q\u0003J\u000bE+S(OA\u0005\tB*Q'C\t\u0006{6+\u0012)B%\u0006#\u0016j\u0014(\u0002%1\u000bUJ\u0011#B?N+\u0005+\u0011*B)&{e\nI\u0001\u0011\u0007>kU*Q0T\u000bB\u000b%+\u0011+J\u001f:\u000b\u0011cQ(N\u001b\u0006{6+\u0012)B%\u0006#\u0016j\u0014(!\u0003Y\u0019EjT*F?B\u000b%+\u0012(`'\u0016\u0003\u0016IU!U\u0013>s\u0015aF\"M\u001fN+u\fU!S\u000b:{6+\u0012)B%\u0006#\u0016j\u0014(!\u0003Uy\u0005+\u0012(`!\u0006\u0013VIT0T\u000bB\u000b%+\u0011+J\u001f:\u000bac\u0014)F\u001d~\u0003\u0016IU#O?N+\u0005+\u0011*B)&{e\nI\u0001\u0017\u0003:su\nV!U\u0013>su\fR#D\u0019\u0006\u0013\u0016\tV%P\u001d\u00069\u0012I\u0014(P)\u0006#\u0016j\u0014(`\t\u0016\u001bE*\u0011*B)&{e\nI\u0001\u0011)f\u0003Vi\u0018#F\u00072\u000b%+\u0011+J\u001f:\u000b\u0011\u0003V-Q\u000b~#Ui\u0011'B%\u0006#\u0016j\u0014(!\u0003=1\u0016IU0E\u000b\u000ec\u0015IU!U\u0013>s\u0015\u0001\u0005,B%~#Ui\u0011'B%\u0006#\u0016j\u0014(!\u0003Q1UKT\"U\u0013>su\fR#D\u0019\u0006\u0013\u0016\tV%P\u001d\u0006)b)\u0016(D)&{ej\u0018#F\u00072\u000b%+\u0011+J\u001f:\u0003\u0013AD*U\u0003J#v\fV-Q\u000b~\u0013VIR\u0001\u0010'R\u000b%\u000bV0U3B+uLU#GA\u0005aQI\u0014#`)f\u0003Vi\u0018*F\r\u0006iQI\u0014#`)f\u0003Vi\u0018*F\r\u0002\n\u0011DU#R+&\u0013ViU0X\u0011&#Vi\u0015)B\u0007\u0016{v\nU0J\tV\t1\u000fE\u0002uofl\u0011!\u001e\u0006\u0003m\u0006\u000b!bY8mY\u0016\u001cG/[8o\u0013\tAXOA\u0002TKF\u0004\"A_?\u000e\u0003mT!\u0001`\u001b\u0002\u000f\u001d\u0014\u0018-\\7be&\u0011ap\u001f\u0002\u0013\u0005&t\u0017M]=Pa&#WM\u001c;jM&,'/\u0001\u000eS\u000bF+\u0016JU#T?^C\u0015\nV#T!\u0006\u001bUiX(Q?&#\u0005%A\bT\u000b2+5\tV%P\u001d~{\u0005kX%E\u0003A\u0019V\tT#D)&{ejX(Q?&#\u0005%\u0001\u0004g_Jl\u0017\r\u001e\u000b\u0007\u0003\u0013\ty!!\t\u0011\u0007\u0001\u000bY!C\u0002\u0002\u000e\u0005\u0013A!\u00168ji\"9\u0011\u0011C\u0011A\u0002\u0005M\u0011aA1tiB!\u0011QCA\u000f\u001b\t\t9B\u0003\u0003\u0002\u0012\u0005e!bAA\u000ek\u00051\u0001/\u0019:tKJLA!a\b\u0002\u0018\t9\u0011i\u001d;O_\u0012,\u0007bBA\u0012C\u0001\u0007\u0011QE\u0001\tI>\u001cW/\\3oiB!\u0011qEA\u0017\u001b\t\tICC\u0002\u0002,U\na!\u001a3ji>\u0014\u0018\u0002BA\u0018\u0003S\u0011\u0011cV3bm\u0016$V\r\u001f;E_\u000e,X.\u001a8u\u0003u\u0019\u0017\r\\2vY\u0006$XMQ5oCJLh)\u001e8di&|gn\u00144gg\u0016$H\u0003BA\u001b\u0003w\u00012\u0001QA\u001c\u0013\r\tI$\u0011\u0002\u0004\u0013:$\bbBA\u001fE\u0001\u0007\u00111C\u0001\tM&\u00148\u000f^!sORQ\u0011\u0011BA!\u0003\u0007\n)%!\u0013\t\u000f\u0005E1\u00051\u0001\u0002\u0014!9\u00111E\u0012A\u0002\u0005\u0015\u0002bBA$G\u0001\u0007\u0011QG\u0001\u0007_\u001a47/\u001a;\t\u000f\u0005-3\u00051\u0001\u00026\u0005a\u0001O]3wS>,8\u000fT5oK\u0006\t\u0012n]%oM&D()\u001b8bef\u001c\u0015\r\u001c7\u0015\t\u0005E\u0013q\u000b\t\u0004\u0001\u0006M\u0013bAA+\u0003\n9!i\\8mK\u0006t\u0007bBA-I\u0001\u0007\u00111L\u0001\u0004M\u000et\u0007\u0003BA/\u0003Gj!!a\u0018\u000b\t\u0005\u0005\u0014qC\u0001\nMVt7\r^5p]NLA!!\u001a\u0002`\t\u0001b)\u001e8di&|gnQ1mY:{G-Z\u0001\rS:$WM\u001c;PM\u001a\u001cX\r\u001e\u000b\u0005\u0003k\tY\u0007C\u0004\u0002H\u0015\u0002\r!!\u000e\u0002\u0015M,\u0007/\u0019:bi\u0016\u0014\u0015\u0010\u0006\u0005\u0002\n\u0005E\u00141RAO\u0011\u001d\t\u0019H\na\u0001\u0003k\nQA\\8eKN\u0004b!a\u001e\u0002\b\u0006Ma\u0002BA=\u0003\u0007sA!a\u001f\u0002\u00026\u0011\u0011Q\u0010\u0006\u0004\u0003\u007fj\u0014A\u0002\u001fs_>$h(C\u0001C\u0013\r\t))Q\u0001\ba\u0006\u001c7.Y4f\u0013\rA\u0018\u0011\u0012\u0006\u0004\u0003\u000b\u000b\u0005bBAGM\u0001\u0007\u0011qR\u0001\ng\u0016\u0004\u0018M]1u_J\u0004B!!%\u0002\u001a:!\u00111SAK!\r\tY(Q\u0005\u0004\u0003/\u000b\u0015A\u0002)sK\u0012,g-C\u0002X\u00037S1!a&B\u0011\u001d\t\u0019C\na\u0001\u0003K\t1\"\u001b8eK:$8\t\\8tKRA\u0011\u0011BAR\u0003K\u000bI\u000bC\u0004\u0002$\u001d\u0002\r!!\n\t\u000f\u0005\u001dv\u00051\u0001\u00026\u00051\u0011N\u001c3f]RDq!a+(\u0001\u0004\t\u0019\"A\u0004bgRtu\u000eZ3\u0015\u0015\u0005%\u0011qVAY\u0003g\u000b)\fC\u0004\u0002t!\u0002\r!!\u001e\t\u000f\u0005\r\u0002\u00061\u0001\u0002&!9\u0011q\u0015\u0015A\u0002\u0005U\u0002bBA\\Q\u0001\u0007\u0011QG\u0001\ngR\f'\u000f\u001e'j]\u0016\faBZ8s[\u0006$h)\u001e8di&|g\u000e\u0006\u0007\u0002\n\u0005u\u0016qYAe\u0003\u0017\fy\rC\u0004\u0002@&\u0002\r!!1\u0002\u0005\u0019t\u0007\u0003BA/\u0003\u0007LA!!2\u0002`\taa)\u001e8di&|gNT8eK\"9\u00111E\u0015A\u0002\u0005\u0015\u0002bBA$S\u0001\u0007\u0011Q\u0007\u0005\b\u0003\u001bL\u0003\u0019AA\u001b\u0003\u0011a\u0017N\\3\t\u000f\u0005E\u0017\u00061\u0001\u0002\u0010\u0006\u0011b-\u001e8di&|gnU3qCJ\fG/[8o\u0003Q1wN]2f\u001f:,7\u000b]1dK\n+Go^3f]RA\u0011\u0011BAl\u00037\fy\u000eC\u0004\u0002Z*\u0002\r!a\u0005\u0002\u00111,g\r\u001e(pI\u0016Dq!!8+\u0001\u0004\t\u0019\"A\u0005sS\u001eDGOT8eK\"9\u00111\u0005\u0016A\u0002\u0005\u0015\u0012a\u00054pe\u000e,gj\\*qC\u000e,')\u001a;xK\u0016tG\u0003CA\u0005\u0003K\f9/!;\t\u000f\u0005e7\u00061\u0001\u0002\u0014!9\u0011Q\\\u0016A\u0002\u0005M\u0001bBA\u0012W\u0001\u0007\u0011Q\u0005\u000b\u000b\u0003\u0013\ti/a<\u0002r\u0006U\bbBAmY\u0001\u0007\u00111\u0003\u0005\b\u0003;d\u0003\u0019AA\n\u0011\u001d\t\u0019\u0010\fa\u0001\u0003\u001f\u000b!#\u001a=qK\u000e$X\rZ*fa\u0006\u0014\u0018\r^5p]\"9\u00111\u0005\u0017A\u0002\u0005\u0015BCCA\u0005\u0003s\u0014IA!\u0004\u0003\u0010!9\u00111`\u0017A\u0002\u0005u\u0018\u0001\u00047fMRdunY1uS>t\u0007\u0003BA\u0000\u0005\u000bi!A!\u0001\u000b\t\t\r\u0011\u0011D\u0001\tY>\u001c\u0017\r^5p]&!!q\u0001B\u0001\u0005!\u0001vn]5uS>t\u0007b\u0002B\u0006[\u0001\u0007\u0011Q`\u0001\u000ee&<\u0007\u000e\u001e'pG\u0006$\u0018n\u001c8\t\u000f\u0005MX\u00061\u0001\u0002\u0010\"9\u00111E\u0017A\u0002\u0005\u0015\u0012aF3rk\u0006d7/S4o_J,w\u000b[5uKN\u0003\u0018mY3t)\u0019\t\tF!\u0006\u0003\u0018!9\u00111\u001f\u0018A\u0002\u0005=\u0005b\u0002B\r]\u0001\u0007\u0011qR\u0001\u000bg\u0016\u0004\u0018M]1uS>t\u0017aC1qa2L\u0018J\u001c3f]R$\u0002\"!\u0003\u0003 \t\u0005\"1\u0005\u0005\b\u0003#y\u0003\u0019AA\n\u0011\u001d\t\u0019c\fa\u0001\u0003KAqA!\n0\u0001\u0004\t)$\u0001\u0004d_2,XN\\\u0001\u0018G>,h\u000e^%oSRL\u0017\r\\,iSR,7\u000b]1dKN$B!!\u000e\u0003,!9!Q\u0006\u0019A\u0002\u0005=\u0015\u0001\u0002;fqR$\u0002\"!\u0003\u00032\tU\"q\u0007\u0005\b\u0005g\t\u0004\u0019AA\u007f\u00035\u0019H/\u0019:u!>\u001c\u0018\u000e^5p]\"9\u00111E\u0019A\u0002\u0005\u0015\u0002b\u0002B\u0013c\u0001\u0007\u0011Q\u0007")
public class FormattingService {
    private final FormattingOptions options;
    private final String TYPE_SEPARATION;
    private final String KEY_VALUE_SEPARATION;
    private final String EQ_SEPARATION;
    private final String LAMBDA_SEPARATION;
    private final String COMMA_SEPARATION;
    private final String CLOSE_PAREN_SEPARATION;
    private final String OPEN_PAREN_SEPARATION;
    private final String ANNOTATION_DECLARATION;
    private final String TYPE_DECLARATION;
    private final String VAR_DECLARATION;
    private final String FUNCTION_DECLARATION;
    private final String START_TYPE_REF;
    private final String END_TYPE_REF;
    private final Seq<BinaryOpIdentifier> REQUIRES_WHITESPACE_OP_ID;
    private final Seq<BinaryOpIdentifier> SELECTION_OP_ID;

    public String TYPE_SEPARATION() {
        return this.TYPE_SEPARATION;
    }

    public String KEY_VALUE_SEPARATION() {
        return this.KEY_VALUE_SEPARATION;
    }

    public String EQ_SEPARATION() {
        return this.EQ_SEPARATION;
    }

    public String LAMBDA_SEPARATION() {
        return this.LAMBDA_SEPARATION;
    }

    public String COMMA_SEPARATION() {
        return this.COMMA_SEPARATION;
    }

    public String CLOSE_PAREN_SEPARATION() {
        return this.CLOSE_PAREN_SEPARATION;
    }

    public String OPEN_PAREN_SEPARATION() {
        return this.OPEN_PAREN_SEPARATION;
    }

    public String ANNOTATION_DECLARATION() {
        return this.ANNOTATION_DECLARATION;
    }

    public String TYPE_DECLARATION() {
        return this.TYPE_DECLARATION;
    }

    public String VAR_DECLARATION() {
        return this.VAR_DECLARATION;
    }

    public String FUNCTION_DECLARATION() {
        return this.FUNCTION_DECLARATION;
    }

    public String START_TYPE_REF() {
        return this.START_TYPE_REF;
    }

    public String END_TYPE_REF() {
        return this.END_TYPE_REF;
    }

    public Seq<BinaryOpIdentifier> REQUIRES_WHITESPACE_OP_ID() {
        return this.REQUIRES_WHITESPACE_OP_ID;
    }

    public Seq<BinaryOpIdentifier> SELECTION_OP_ID() {
        return this.SELECTION_OP_ID;
    }

    public void format(AstNode ast, WeaveTextDocument document) {
        this.format(ast, document, 0, -1);
    }

    public int calculateBinaryFunctionOffset(AstNode firstArg) {
        FunctionCallNode functionCallNode;
        AstNode astNode = firstArg;
        int n = astNode instanceof FunctionCallNode && this.isInfixBinaryCall(functionCallNode = (FunctionCallNode)astNode) ? this.calculateBinaryFunctionOffset((AstNode)functionCallNode.args().args().head()) : astNode.location().endPosition().column();
        return n;
    }

    private void format(AstNode ast, WeaveTextDocument document, int offset, int previousLine) {
        block46: {
            AstNode astNode;
            int startLine;
            while (true) {
                FunctionCallNode functionCallNode;
                int n;
                if (AstNodeHelper$.MODULE$.isInjectedNode(ast)) {
                    this.format(ast.children(), document, offset, previousLine);
                    return;
                }
                AstNode astNode2 = ast;
                if (astNode2 instanceof AnnotationCapableNode) {
                    AnnotationCapableNode annotationCapableNode = (AnnotationCapableNode)astNode2;
                    Seq<AnnotationNode> annotations = annotationCapableNode.codeAnnotations();
                    n = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((SeqLike)annotations.filterNot((Function1 & Serializable & scala.Serializable)node -> BoxesRunTime.boxToBoolean((boolean)AstNodeHelper$.MODULE$.isInjectedNode(node)))).sortBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)FormattingService.$anonfun$format$2(x$1)), (Ordering)Ordering.Int$.MODULE$)).foldLeft((Object)BoxesRunTime.boxToInteger((int)previousLine), (Function2 & Serializable & scala.Serializable)(line, child) -> BoxesRunTime.boxToInteger((int)FormattingService.$anonfun$format$3(this, document, offset, BoxesRunTime.unboxToInt((Object)line), child))));
                } else {
                    n = previousLine;
                }
                int newPreviousLine = n;
                startLine = ast.location().startPosition().line();
                if (startLine > newPreviousLine) {
                    this.applyIndent(ast, document, offset);
                }
                boolean bl = false;
                BinaryOpNode binaryOpNode = null;
                astNode = ast;
                boolean bl2 = astNode instanceof DocumentNode ? true : astNode instanceof ModuleNode;
                if (bl2) {
                    this.format(ast.children(), document, offset, 0);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block46;
                }
                if (astNode instanceof FunctionNode) {
                    FunctionNode functionNode = (FunctionNode)astNode;
                    this.formatFunction(functionNode, document, offset, startLine, this.LAMBDA_SEPARATION());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block46;
                }
                if (astNode instanceof FunctionDirectiveNode) {
                    AstNode astNode3;
                    FunctionDirectiveNode functionDirectiveNode = (FunctionDirectiveNode)astNode;
                    if (functionDirectiveNode.codeAnnotations().isEmpty()) {
                        this.separateBy(functionDirectiveNode.location().startPosition(), functionDirectiveNode.variable().location().startPosition(), this.FUNCTION_DECLARATION(), document);
                    }
                    if (!((astNode3 = functionDirectiveNode.literal()) instanceof FunctionNode)) {
                        previousLine = functionDirectiveNode.variable().location().endPosition().line();
                        ast = astNode3;
                        continue;
                    }
                    FunctionNode functionNode = (FunctionNode)astNode3;
                    this.formatFunction(functionNode, document, offset, functionDirectiveNode.variable().location().endPosition().line(), this.EQ_SEPARATION());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                    break block46;
                }
                if (astNode instanceof FunctionParameter) {
                    BoxedUnit boxedUnit;
                    FunctionParameter functionParameter = (FunctionParameter)astNode;
                    if (functionParameter.wtype().isDefined()) {
                        this.separateBy(functionParameter.variable(), (AstNode)functionParameter.wtype().get(), this.TYPE_SEPARATION(), document);
                    }
                    if (functionParameter.defaultValue().isDefined()) {
                        Position leftPosition = (Position)functionParameter.wtype().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.location().endPosition()).getOrElse((Function0 & Serializable & scala.Serializable)() -> functionParameter.variable().location().endPosition());
                        this.separateBy(leftPosition, ((WeaveLocationCapable)functionParameter.defaultValue().get()).location().startPosition(), this.EQ_SEPARATION(), document);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit3 = boxedUnit;
                    break block46;
                }
                if (astNode instanceof VarDirective) {
                    VarDirective varDirective = (VarDirective)astNode;
                    if (varDirective.codeAnnotations().isEmpty()) {
                        this.separateBy(varDirective.location().startPosition(), varDirective.variable().location().startPosition(), this.VAR_DECLARATION(), document);
                    }
                    if (varDirective.wtype().isDefined()) {
                        this.separateBy(varDirective.variable(), (AstNode)varDirective.wtype().get(), this.TYPE_SEPARATION(), document);
                    }
                    this.separateBy(varDirective.variable(), varDirective.value(), this.EQ_SEPARATION(), document);
                    previousLine = varDirective.variable().location().startPosition().line();
                    offset = this.indentOffset(offset);
                    ast = varDirective.value();
                    continue;
                }
                if (astNode instanceof TypeDirective) {
                    Option<TypeParametersListNode> typeParametersListNode;
                    TypeDirective typeDirective = (TypeDirective)astNode;
                    if (typeDirective.codeAnnotations().isEmpty()) {
                        this.separateBy(typeDirective.location().startPosition(), typeDirective.variable().location().startPosition(), this.TYPE_DECLARATION(), document);
                    }
                    if ((typeParametersListNode = typeDirective.typeParametersListNode()).isDefined() && ((TypeParametersListNode)typeParametersListNode.get()).typeParameters().nonEmpty()) {
                        TypeParametersListNode typeParamList = (TypeParametersListNode)typeParametersListNode.get();
                        this.separateBy(typeDirective.variable().location().endPosition(), ((WeaveLocationCapable)typeParamList.typeParameters().head()).location().startPosition(), this.START_TYPE_REF(), document);
                        this.separateBy(typeParamList.typeParameters(), this.COMMA_SEPARATION(), document);
                        this.separateBy(((WeaveLocationCapable)typeParamList.typeParameters().last()).location().endPosition(), typeDirective.typeExpression().location().startPosition(), new StringBuilder(1).append(this.END_TYPE_REF()).append(" ").append(this.EQ_SEPARATION()).toString(), document);
                    } else {
                        this.separateBy(typeDirective.variable(), typeDirective.typeExpression(), this.EQ_SEPARATION(), document);
                    }
                    previousLine = typeDirective.variable().location().endPosition().line();
                    ast = typeDirective.typeExpression();
                    continue;
                }
                if (astNode instanceof SchemaNode) {
                    SchemaNode schemaNode = (SchemaNode)astNode;
                    this.separateBy(schemaNode.properties(), this.COMMA_SEPARATION(), document);
                    this.format(schemaNode.children(), document, offset, startLine);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block46;
                }
                if (astNode instanceof AnnotationDirectiveNode) {
                    AnnotationDirectiveNode annotationDirectiveNode = (AnnotationDirectiveNode)astNode;
                    this.separateBy(annotationDirectiveNode.location().startPosition(), annotationDirectiveNode.nameIdentifier().location().startPosition(), this.ANNOTATION_DECLARATION(), document);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block46;
                }
                if (astNode instanceof ObjectTypeNode) {
                    ObjectTypeNode objectTypeNode = (ObjectTypeNode)astNode;
                    this.format(objectTypeNode.children(), document, this.indentOffset(offset), startLine);
                    this.indentClose(document, offset, objectTypeNode);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block46;
                }
                if (astNode instanceof NameValueTypeNode) {
                    NameValueTypeNode nameValueTypeNode = (NameValueTypeNode)astNode;
                    this.separateBy(nameValueTypeNode.name(), nameValueTypeNode.value(), this.KEY_VALUE_SEPARATION(), document);
                    this.format(nameValueTypeNode.children(), document, this.indentOffset(offset), startLine);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block46;
                }
                if (astNode instanceof KeyValueTypeNode) {
                    KeyValueTypeNode keyValueTypeNode = (KeyValueTypeNode)astNode;
                    this.separateBy(keyValueTypeNode.key(), keyValueTypeNode.value(), this.KEY_VALUE_SEPARATION(), document);
                    this.format(keyValueTypeNode.children(), document, this.indentOffset(offset), startLine);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block46;
                }
                if (astNode instanceof KeyTypeNode) {
                    KeyTypeNode keyTypeNode = (KeyTypeNode)astNode;
                    this.separateBy(keyTypeNode.attrs(), this.COMMA_SEPARATION(), document);
                    this.format(keyTypeNode.children(), document, offset, startLine);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block46;
                }
                if (astNode instanceof TypeReferenceNode) {
                    TypeReferenceNode typeReferenceNode = (TypeReferenceNode)astNode;
                    if (typeReferenceNode.typeArguments().isDefined() && ((TraversableOnce)typeReferenceNode.typeArguments().get()).nonEmpty()) {
                        this.separateBy((Seq<AstNode>)((Seq)typeReferenceNode.typeArguments().get()), this.COMMA_SEPARATION(), document);
                        this.separateBy(typeReferenceNode.variable().location().endPosition(), ((WeaveLocationCapable)((IterableLike)typeReferenceNode.typeArguments().get()).head()).location().startPosition(), this.START_TYPE_REF(), document);
                        this.separateBy(((WeaveLocationCapable)((TraversableLike)typeReferenceNode.typeArguments().get()).last()).location().endPosition(), typeReferenceNode.location().endPosition(), this.END_TYPE_REF(), document);
                    }
                    this.format(typeReferenceNode.children(), document, offset, startLine);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block46;
                }
                if (astNode instanceof FunctionCallNode && this.isInfixBinaryCall(functionCallNode = (FunctionCallNode)astNode)) {
                    AstNode firstArg = (AstNode)functionCallNode.args().args().head();
                    AstNode secondArg = (AstNode)functionCallNode.args().args().last();
                    this.format(firstArg, document, offset, startLine);
                    this.forceOneSpaceBetween(firstArg, functionCallNode.function(), document);
                    int functionOffset = this.indentOffset(offset);
                    this.format(functionCallNode.function(), document, functionOffset, firstArg.location().endPosition().line());
                    this.forceOneSpaceBetween(functionCallNode.function(), secondArg, document);
                    int secondParamOffset = this.indentOffset(functionOffset);
                    previousLine = functionCallNode.function().location().endPosition().line();
                    offset = secondParamOffset;
                    ast = secondArg;
                    continue;
                }
                if (astNode instanceof ObjectNode) {
                    ObjectNode objectNode = (ObjectNode)astNode;
                    this.separateBy(objectNode.elements(), this.COMMA_SEPARATION(), document);
                    this.format(objectNode.elements(), document, this.indentOffset(offset), startLine);
                    this.indentClose(document, offset, objectNode);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block46;
                }
                if (astNode instanceof KeyValuePairNode) {
                    KeyValuePairNode keyValuePairNode = (KeyValuePairNode)astNode;
                    this.separateBy(keyValuePairNode.key(), keyValuePairNode.value(), this.KEY_VALUE_SEPARATION(), document);
                    this.format(keyValuePairNode.children(), document, this.indentOffset(offset), startLine);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block46;
                }
                if (astNode instanceof AttributesNode) {
                    AttributesNode attributesNode = (AttributesNode)astNode;
                    Seq<AstNode> paramList = attributesNode.children();
                    this.separateBy(paramList, this.COMMA_SEPARATION(), document);
                    this.format(attributesNode.children(), document, offset, startLine);
                    this.indentClose(document, offset, attributesNode);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block46;
                }
                if (astNode instanceof NameValuePairNode) {
                    NameValuePairNode nameValuePairNode = (NameValuePairNode)astNode;
                    this.separateBy(nameValuePairNode.key(), nameValuePairNode.value(), this.KEY_VALUE_SEPARATION(), document);
                    this.format(nameValuePairNode.children(), document, this.indentOffset(offset), startLine);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block46;
                }
                if (astNode instanceof DoBlockNode) {
                    DoBlockNode doBlockNode = (DoBlockNode)astNode;
                    HeaderNode headerNode = doBlockNode.header();
                    AstNode bodyNode = doBlockNode.body();
                    this.format(headerNode, document, this.indentOffset(offset), startLine);
                    Position bodyStartPosition = bodyNode.location().startPosition();
                    Position headerEndPosition = headerNode.location().endPosition();
                    if (!AstNodeHelper$.MODULE$.isInjectedNode(headerNode) && headerEndPosition.line() != bodyStartPosition.line()) {
                        this.applyIndent(headerEndPosition, document, this.indentOffset(offset));
                    }
                    this.format(bodyNode, document, this.indentOffset(offset), startLine);
                    this.indentClose(document, offset, doBlockNode);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block46;
                }
                if (astNode instanceof BinaryOpNode) {
                    bl = true;
                    binaryOpNode = (BinaryOpNode)astNode;
                    if (this.REQUIRES_WHITESPACE_OP_ID().contains((Object)binaryOpNode.binaryOpId())) {
                        this.separateBy(binaryOpNode.lhs(), binaryOpNode.rhs(), new StringBuilder(2).append(" ").append(binaryOpNode.binaryOpId().name()).append(" ").toString(), document);
                        this.format(binaryOpNode.children(), document, offset, startLine);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block46;
                    }
                }
                if (!bl || !this.SELECTION_OP_ID().contains((Object)binaryOpNode.binaryOpId())) break;
                AstNode lhs = binaryOpNode.lhs();
                AstNode rhs = binaryOpNode.rhs();
                this.forceNoSpaceBetween(lhs, rhs, document);
                this.format(lhs, document, offset, startLine);
                previousLine = startLine;
                offset = this.indentOffset(offset);
                ast = rhs;
            }
            if (astNode instanceof IfNode) {
                IfNode ifNode = (IfNode)astNode;
                this.format(ifNode.children(), document, this.indentOffset(offset), startLine);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (astNode instanceof UnlessNode) {
                UnlessNode unlessNode = (UnlessNode)astNode;
                this.format(unlessNode.children(), document, this.indentOffset(offset), startLine);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (astNode instanceof ArrayNode) {
                ArrayNode arrayNode = (ArrayNode)astNode;
                this.format(arrayNode.elements(), document, this.indentOffset(offset), startLine);
                this.indentClose(document, offset, arrayNode);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (astNode instanceof PatternExpressionsNode) {
                PatternExpressionsNode patternExpressionsNode = (PatternExpressionsNode)astNode;
                this.format(patternExpressionsNode.children(), document, this.indentOffset(offset), startLine);
                this.indentClose(document, offset, patternExpressionsNode);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                this.format(astNode.children(), document, offset, startLine);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    private boolean isInfixBinaryCall(FunctionCallNode fcn) {
        return AstNodeHelper$.MODULE$.isInfixFunctionCall(fcn) && fcn.args().args().length() == 2;
    }

    private int indentOffset(int offset) {
        return offset + (this.options.insertSpaces() ? this.options.tabSize() : 1);
    }

    public void separateBy(Seq<AstNode> nodes, String separator, WeaveTextDocument document) {
        int i = 1;
        while (i < nodes.size()) {
            this.separateBy((AstNode)nodes.apply(i - 1), (AstNode)nodes.apply(i), separator, document);
            i = this.indentOffset(i);
        }
    }

    private void indentClose(WeaveTextDocument document, int indent, AstNode astNode) {
        block0: {
            Position startPosition = (Position)astNode.children().lastOption().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.location().endPosition()).getOrElse((Function0 & Serializable & scala.Serializable)() -> astNode.location().startPosition());
            Position endPosition = astNode.location().endPosition();
            if (startPosition.line() == endPosition.line()) break block0;
            SimpleParserPosition leftPosition = new SimpleParserPosition(endPosition.index() - 1, endPosition.line(), endPosition.column() - 1, endPosition.source());
            this.applyIndent(leftPosition, document, indent);
        }
    }

    private void format(Seq<AstNode> nodes, WeaveTextDocument document, int indent, int startLine) {
        ((TraversableOnce)((SeqLike)nodes.filterNot((Function1 & Serializable & scala.Serializable)node -> BoxesRunTime.boxToBoolean((boolean)AstNodeHelper$.MODULE$.isInjectedNode(node)))).sortBy((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)FormattingService.$anonfun$format$7(x$4)), (Ordering)Ordering.Int$.MODULE$)).foldLeft((Object)BoxesRunTime.boxToInteger((int)startLine), (Function2 & Serializable & scala.Serializable)(line, child) -> BoxesRunTime.boxToInteger((int)FormattingService.$anonfun$format$8(this, document, indent, BoxesRunTime.unboxToInt((Object)line), child)));
    }

    private void formatFunction(FunctionNode fn, WeaveTextDocument document, int offset, int line, String functionSeparation) {
        Option lastParameter;
        Seq<FunctionParameter> paramList = fn.params().paramList();
        this.separateBy(paramList, this.COMMA_SEPARATION(), document);
        int paramsOffset = fn.params().location().startPosition().column();
        this.format(paramList, document, paramsOffset, fn.params().location().startPosition().line());
        if (fn.returnType().isDefined()) {
            this.separateBy(fn.params(), (AstNode)fn.returnType().get(), this.TYPE_SEPARATION(), document);
            this.separateBy((AstNode)fn.returnType().get(), fn.body(), functionSeparation, document);
        } else {
            this.separateBy(fn.params(), fn.body(), functionSeparation, document);
        }
        Option headParam = fn.params().paramList().headOption();
        if (headParam.isDefined()) {
            this.separateBy(fn.params().location().startPosition(), ((ContainerAstNode)headParam.get()).location().startPosition(), this.OPEN_PAREN_SEPARATION(), document);
        }
        if ((lastParameter = fn.params().paramList().lastOption()).isDefined()) {
            this.separateBy(((ContainerAstNode)lastParameter.get()).location().endPosition(), fn.params().location().endPosition(), this.CLOSE_PAREN_SEPARATION(), document);
        }
        this.format(fn.body(), document, this.indentOffset(offset), line);
    }

    private void forceOneSpaceBetween(AstNode leftNode, AstNode rightNode, WeaveTextDocument document) {
        block0: {
            int i;
            WeaveLocation leftLocation;
            block1: {
                if (AstNodeHelper$.MODULE$.isInjectedNode(leftNode) || AstNodeHelper$.MODULE$.isInjectedNode(rightNode)) break block0;
                leftLocation = leftNode.location();
                WeaveLocation rightLocation = rightNode.location();
                if (leftLocation.endPosition().line() != rightLocation.startPosition().line()) break block0;
                String nextChar = document.text(leftLocation.endPosition().index(), rightLocation.startPosition().index());
                i = this.countInitialWhiteSpaces(nextChar);
                if (i <= 1) break block1;
                document.delete(leftLocation.endPosition().index(), leftLocation.endPosition().index() + (i - 1));
                break block0;
            }
            if (i != 0) break block0;
            document.insert(" ", leftLocation.endPosition().index());
        }
    }

    private void forceNoSpaceBetween(AstNode leftNode, AstNode rightNode, WeaveTextDocument document) {
        block1: {
            String nextChar;
            int i;
            if (AstNodeHelper$.MODULE$.isInjectedNode(leftNode) || AstNodeHelper$.MODULE$.isInjectedNode(rightNode)) break block1;
            WeaveLocation leftLocation = leftNode.location();
            WeaveLocation rightLocation = rightNode.location();
            if (leftLocation.endPosition().line() == rightLocation.startPosition().line() && (i = this.countInitialWhiteSpaces(nextChar = document.text(leftLocation.endPosition().index(), rightLocation.startPosition().index()))) > 0) {
                document.delete(leftLocation.endPosition().index(), leftLocation.endPosition().index() + i);
            }
        }
    }

    private void separateBy(AstNode leftNode, AstNode rightNode, String expectedSeparation, WeaveTextDocument document) {
        block0: {
            if (AstNodeHelper$.MODULE$.isInjectedNode(leftNode) || AstNodeHelper$.MODULE$.isInjectedNode(rightNode)) break block0;
            WeaveLocation leftLocation = leftNode.location();
            WeaveLocation rightLocation = rightNode.location();
            this.separateBy(leftLocation.endPosition(), rightLocation.startPosition(), expectedSeparation, document);
        }
    }

    private void separateBy(Position leftLocation, Position rightLocation, String expectedSeparation, WeaveTextDocument document) {
        int endIndex;
        int startIndex = leftLocation.index();
        String separation = document.text(startIndex, endIndex = rightLocation.index());
        if (this.equalsIgnoreWhiteSpaces(expectedSeparation, separation)) {
            if (!separation.equals(expectedSeparation)) {
                if (leftLocation.line() != rightLocation.line()) {
                    String rightTrim = separation.replaceAll("\\s+$", "");
                    document.replace(startIndex, startIndex + rightTrim.length(), expectedSeparation);
                } else {
                    document.replace(startIndex, endIndex, expectedSeparation);
                }
            }
        } else {
            Predef$.MODULE$.println((Object)new StringBuilder(4).append(separation.trim()).append(" != ").append(expectedSeparation).toString());
        }
    }

    private boolean equalsIgnoreWhiteSpaces(String expectedSeparation, String separation) {
        return separation.replaceAll("\\s+", "").equals(expectedSeparation.replaceAll("\\s+", ""));
    }

    private void applyIndent(AstNode ast, WeaveTextDocument document, int column) {
        Position startPosition = ast.location().startPosition();
        this.applyIndent(startPosition, document, column);
    }

    /*
     * WARNING - void declaration
     */
    public int countInitialWhiteSpaces(String text) {
        void var2_2;
        for (int i = 0; i < text.length() && RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(text.charAt(i))); ++i) {
        }
        return (int)var2_2;
    }

    private void applyIndent(Position startPosition, WeaveTextDocument document, int column) {
        block2: {
            int actualColumn = startPosition.column() - 1;
            int startLineIndex = startPosition.index() - actualColumn;
            String text = document.text(startLineIndex, startPosition.index());
            int currentIndent = this.countInitialWhiteSpaces(text);
            if (currentIndent == column) break block2;
            int diffSpaces = column - currentIndent;
            if (diffSpaces < 0) {
                document.delete(startLineIndex, startLineIndex - diffSpaces);
            } else {
                String spaces = this.options.insertSpaces() ? " " : "\t";
                document.insert(new StringOps(Predef$.MODULE$.augmentString(spaces)).$times(diffSpaces), startLineIndex);
            }
        }
    }

    public static final /* synthetic */ int $anonfun$format$2(AnnotationNode x$1) {
        return x$1.location().startPosition().index();
    }

    public static final /* synthetic */ int $anonfun$format$3(FormattingService $this, WeaveTextDocument document$1, int offset$1, int line, AnnotationNode child) {
        $this.format(child, document$1, offset$1, line);
        return child.location().endPosition().line();
    }

    public static final /* synthetic */ int $anonfun$format$7(AstNode x$4) {
        return x$4.location().startPosition().index();
    }

    public static final /* synthetic */ int $anonfun$format$8(FormattingService $this, WeaveTextDocument document$2, int indent$1, int line, AstNode child) {
        $this.format(child, document$2, indent$1, line);
        return child.location().endPosition().line();
    }

    public FormattingService(FormattingOptions options) {
        this.options = options;
        this.TYPE_SEPARATION = ": ";
        this.KEY_VALUE_SEPARATION = ": ";
        this.EQ_SEPARATION = " = ";
        this.LAMBDA_SEPARATION = " -> ";
        this.COMMA_SEPARATION = ", ";
        this.CLOSE_PAREN_SEPARATION = ")";
        this.OPEN_PAREN_SEPARATION = "(";
        this.ANNOTATION_DECLARATION = "annotation ";
        this.TYPE_DECLARATION = "type ";
        this.VAR_DECLARATION = "var ";
        this.FUNCTION_DECLARATION = "fun ";
        this.START_TYPE_REF = "<";
        this.END_TYPE_REF = ">";
        this.REQUIRES_WHITESPACE_OP_ID = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BinaryOpIdentifier[]{AdditionOpId$.MODULE$, IsOpId$.MODULE$, SubtractionOpId$.MODULE$, DivisionOpId$.MODULE$, MultiplicationOpId$.MODULE$, RightShiftOpId$.MODULE$, LeftShiftOpId$.MODULE$, EqOpId$.MODULE$, NotEqOpId$.MODULE$, GreaterThanOpId$.MODULE$, SimilarOpId$.MODULE$, LessThanOpId$.MODULE$, LessOrEqualThanOpId$.MODULE$, AsOpId$.MODULE$}));
        this.SELECTION_OP_ID = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BinaryOpIdentifier[]{AttributeValueSelectorOpId$.MODULE$, MultiValueSelectorOpId$.MODULE$, MultiAttributeValueSelectorOpId$.MODULE$, DynamicSelectorOpId$.MODULE$, SchemaValueSelectorOpId$.MODULE$, ValueSelectorOpId$.MODULE$, ObjectKeyValueSelectorOpId$.MODULE$, FilterSelectorOpId$.MODULE$, RangeSelectorOpId$.MODULE$}));
    }
}

