package org.mule.weave.v2.completion

import org.mule.weave.v2.annotations.WeaveApi

case class DataFormatDescriptor(mimeType: String, id: Option[String], writerProperties: Array[DataFormatProperty], readerProperties: Array[DataFormatProperty]) {
  @WeaveApi(Seq("Studio"))
  def this(mimeType: String, writerProperties: Array[DataFormatProperty], readerProperties: Array[DataFormatProperty]) = {
    this(mimeType, None, writerProperties, readerProperties)
  }
}

object DataFormatDescriptor {
  def apply(mimeType: String, id: String, writerProperties: Array[DataFormatProperty], readerProperties: Array[DataFormatProperty]) = {
    new DataFormatDescriptor(mimeType, Option(id), writerProperties, readerProperties)
  }
}

case class DataFormatProperty(name: String, description: String, wtype: String, values: Array[String])

trait DataFormatDescriptorProvider {
  def dataFormats(): Array[DataFormatDescriptor]
}

object DataFormatDescriptorProvider {
  def apply(formats: Array[DataFormatDescriptor]): DataFormatDescriptorProvider = new DefaultDataFormatDescriptorProvider(formats)
}

class DefaultDataFormatDescriptorProvider(formats: Array[DataFormatDescriptor]) extends DataFormatDescriptorProvider {
  override def dataFormats(): Array[DataFormatDescriptor] = formats
}

object EmptyDataFormatDescriptorProvider extends DataFormatDescriptorProvider {
  override def dataFormats(): Array[DataFormatDescriptor] = Array()
}
