package org.mule.weave.v2.editor

import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.ts.WeaveType
import org.mule.weave.v2.utils.AsciiDocMigrator
import org.mule.weave.v2.weavedoc.WeaveDocParser
import org.mule.weave.v2.weavedoc.WeaveDocumentation

case class FunctionDefinition(nameIdentifier: NameIdentifier, asciidocDoc: String, params: Array[FunctionParameterDefinition], returnType: Option[WeaveType], labels: Array[String]) {

  /**
    * Parse the string documentation into something that can be navigated
    * @return
    */
  def parseDoc(): WeaveDocumentation = {
    WeaveDocParser.parseDocumentation(asciidocDoc)
  }

  /**
    * Returns the documentation in markdown syntax
    * @return
    */
  def markdownDoc(): String =
    AsciiDocMigrator.toMarkDown(asciidocDoc)

}

case class FunctionParameterDefinition(name: String, weaveType: Option[WeaveType], defaultValue: Option[String])
