package org.mule.weave.v2.parser.ast.functions

import org.mule.weave.v2.api.tooling.ast.DWAstNodeKind
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.Children
import org.mule.weave.v2.parser.ast.ContainerAstNode
import org.mule.weave.v2.parser.ast.MutableAstNode
import org.mule.weave.v2.parser.ast.NamedAstNode
import org.mule.weave.v2.parser.ast.VirtualAstNode
import org.mule.weave.v2.parser.ast.annotation.AnnotationNode
import org.mule.weave.v2.parser.ast.header.directives.FunctionDirectiveNode
import org.mule.weave.v2.parser.ast.types.TypeParametersListNode
import org.mule.weave.v2.parser.ast.types.WeaveTypeNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier

case class FunctionNode(var params: FunctionParameters, var body: AstNode, var returnType: Option[WeaveTypeNode] = None, var typeParameterList: Option[TypeParametersListNode] = None) extends AstNode with MutableAstNode {

  override def children(): Seq[AstNode] = Children(params, body).++=(returnType).++=(typeParameterList).result()

  override protected def doClone(): AstNode = copy(params.cloneAst(), body.cloneAst(), returnType.map(_.cloneAst()), typeParameterList.map(_.cloneAst()))

  override def cloneAst(): FunctionNode = super.cloneAst().asInstanceOf[FunctionNode]

  override def update(toBeReplaced: AstNode, withNode: AstNode): Unit = {
    if (body eq toBeReplaced) {
      body = withNode
    } else if (params eq toBeReplaced) {
      params = withNode.asInstanceOf[FunctionParameters]
    } else if (returnType.exists(_ eq withNode)) {
      returnType = Some(withNode.asInstanceOf[WeaveTypeNode])
    } else if (typeParameterList.exists(_ eq withNode)) {
      typeParameterList = Some(withNode.asInstanceOf[TypeParametersListNode])
    }
  }

  override def getKind(): String = DWAstNodeKind.FUNCTION_NODE
}

case class FunctionParameter(var variable: NameIdentifier, var defaultValue: Option[AstNode] = None, var wtype: Option[WeaveTypeNode] = None, var codeAnnotations: Seq[AnnotationNode] = Seq()) extends ContainerAstNode with NamedAstNode {
  override def children(): Seq[AstNode] = Children(variable).+=(defaultValue).+=(wtype).++=(codeAnnotations).result()

  override def cloneAst(): FunctionParameter = super.cloneAst().asInstanceOf[FunctionParameter]

  override protected def doClone(): AstNode = {
    copy(variable.cloneAst(), defaultValue.map(_.cloneAst()), wtype.map(_.cloneAst()), codeAnnotations.map(_.cloneAst()))
  }

  override def nameIdentifier: NameIdentifier = variable

  override def getKind(): String = DWAstNodeKind.FUNCTION_PARAMETER_NODE
}

case class FunctionParameters(var paramList: Seq[FunctionParameter] = Seq()) extends ContainerAstNode {

  override def children(): Seq[AstNode] = paramList

  override def cloneAst(): FunctionParameters = super.cloneAst().asInstanceOf[FunctionParameters]

  override protected def doClone(): AstNode = {
    copy(paramList.map(_.cloneAst()))
  }

  override def getKind(): String = DWAstNodeKind.FUNCTION_PARAMETERS_NODE
}

/**
  * This is a synthetic node that contains a combination of functions with the same name and arg-length.
  */
case class OverloadedFunctionNode(functionDirectives: Seq[FunctionDirectiveNode]) extends ContainerAstNode with VirtualAstNode {

  def functions: Seq[FunctionNode] = {
    functionDirectives.map(_.literal.asInstanceOf[FunctionNode])
  }

  override def children(): Seq[AstNode] = functionDirectives

  override protected def doClone(): AstNode = copy(functionDirectives.map(_.cloneAst()))

  override def getKind(): String = DWAstNodeKind.OVERLOADED_FUNCTION_NODE
}
