package org.mule.weave.v2.parser.ast.structure

import org.mule.weave.v2.api.tooling.ast.DWAstNodeKind
import org.mule.weave.v2.parser.ast.{ AstNode, Children, MutableAstNode }

case class DynamicKeyNode(var keyName: AstNode, var attr: Option[AstNode]) extends AstNode with MutableAstNode {
  override def children(): Seq[AstNode] = Children(keyName).+=(attr).result()

  override protected def doClone(): AstNode = copy(keyName.cloneAst(), attr.map(_.cloneAst()))

  override def update(toBeReplaced: AstNode, withNode: AstNode): Unit = {
    if (keyName eq toBeReplaced) {
      keyName = withNode
    } else if (attr.exists(_ eq toBeReplaced)) {
      attr = Some(withNode)
    }
  }

  override def getKind(): String = DWAstNodeKind.DYNAMIC_KEY_NODE
}